/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import java.time.LocalDateTime;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.properties.ShiroProperties;
import org.apache.streampark.console.base.util.ShaHashUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.security.Authenticator;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"passport"})
public class PassportController {
    @Autowired
    private UserService userService;
    @Autowired
    private ShiroProperties properties;
    @Autowired
    private Authenticator authenticator;

    @PostMapping(value={"signin"})
    public RestResponse signin(@NotBlank(message="{required}") @NotBlank(message="{required}") String username, @NotBlank(message="{required}") @NotBlank(message="{required}") String password) throws Exception {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return RestResponse.success().put("code", (Object)0);
        }
        User user = this.authenticator.authenticate(username, password);
        return this.login(username, password, user);
    }

    @PostMapping(value={"ldapSignin"})
    public RestResponse ldapSignin(@NotBlank(message="{required}") @NotBlank(message="{required}") String username, @NotBlank(message="{required}") @NotBlank(message="{required}") String password) throws Exception {
        if (StringUtils.isEmpty((CharSequence)username)) {
            return RestResponse.success().put("code", (Object)0);
        }
        User user = this.authenticator.ldapAuthenticate(username, password);
        return this.login(username, password, user);
    }

    @PostMapping(value={"signout"})
    public RestResponse signout() {
        SecurityUtils.getSecurityManager().logout(SecurityUtils.getSubject());
        return new RestResponse();
    }

    private RestResponse login(String username, String password, User user) throws Exception {
        if (user == null) {
            return RestResponse.success().put("code", (Object)0);
        }
        if ("0".equals(user.getStatus())) {
            return RestResponse.success().put("code", (Object)1);
        }
        this.userService.fillInTeam(user);
        if (user.getLastTeamId() == null) {
            return RestResponse.success().data(user.getUserId()).put("code", (Object)ResponseCode.CODE_FORBIDDEN);
        }
        password = ShaHashUtils.encrypt(user.getSalt(), password);
        this.userService.updateLoginTime(username);
        String token = WebUtils.encryptToken(JWTUtil.sign(user.getUserId(), username, password));
        LocalDateTime expireTime = LocalDateTime.now().plusSeconds(this.properties.getJwtTimeOut());
        String expireTimeStr = DateUtils.formatFullTime((LocalDateTime)expireTime);
        JWTToken jwtToken = new JWTToken(token, expireTimeStr);
        String userId = RandomStringUtils.randomAlphanumeric((int)20);
        user.setId(userId);
        Map<String, Object> userInfo = this.userService.generateFrontendUserInfo(user, user.getLastTeamId(), jwtToken);
        return new RestResponse().data(userInfo);
    }
}

