/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.enums;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public enum ExecutionMode implements Serializable
{
    LOCAL(0, "local"),
    REMOTE(1, "remote"),
    YARN_PER_JOB(2, "yarn-per-job"),
    YARN_SESSION(3, "yarn-session"),
    YARN_APPLICATION(4, "yarn-application"),
    KUBERNETES_NATIVE_SESSION(5, "kubernetes-session"),
    KUBERNETES_NATIVE_APPLICATION(6, "kubernetes-application");

    private final Integer mode;
    private final String name;

    private ExecutionMode(Integer mode, String name) {
        this.mode = mode;
        this.name = name;
    }

    public static ExecutionMode of(Integer value) {
        for (ExecutionMode executionMode : ExecutionMode.values()) {
            if (!executionMode.mode.equals(value)) continue;
            return executionMode;
        }
        return null;
    }

    public static ExecutionMode of(String name) {
        for (ExecutionMode executionMode : ExecutionMode.values()) {
            if (!executionMode.name.equals(name)) continue;
            return executionMode;
        }
        return null;
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isYarnMode(ExecutionMode mode) {
        return YARN_PER_JOB.equals(mode) || YARN_APPLICATION.equals(mode) || YARN_SESSION.equals(mode);
    }

    public static boolean isYarnSessionMode(ExecutionMode mode) {
        return YARN_SESSION.equals(mode);
    }

    public static boolean isYarnMode(Integer value) {
        return ExecutionMode.isYarnMode(ExecutionMode.of(value));
    }

    public static boolean isKubernetesSessionMode(Integer value) {
        return KUBERNETES_NATIVE_SESSION.equals(ExecutionMode.of(value));
    }

    public static boolean isKubernetesMode(ExecutionMode mode) {
        return KUBERNETES_NATIVE_SESSION.equals(mode) || KUBERNETES_NATIVE_APPLICATION.equals(mode);
    }

    public static boolean isKubernetesMode(Integer value) {
        return ExecutionMode.isKubernetesMode(ExecutionMode.of(value));
    }

    public static boolean isKubernetesApplicationMode(Integer value) {
        return KUBERNETES_NATIVE_APPLICATION.equals(ExecutionMode.of(value));
    }

    public static List<Integer> getKubernetesMode() {
        return Lists.newArrayList(KUBERNETES_NATIVE_SESSION.getMode(), KUBERNETES_NATIVE_APPLICATION.getMode());
    }

    public static boolean isSessionMode(ExecutionMode mode) {
        return KUBERNETES_NATIVE_SESSION.equals(mode) || YARN_SESSION.equals(mode);
    }

    public static boolean isRemoteMode(Integer value) {
        return ExecutionMode.isRemoteMode(ExecutionMode.of(value));
    }

    public static boolean isRemoteMode(ExecutionMode mode) {
        return REMOTE.equals(mode);
    }
}

