/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export default {
  footer: { website: 'Website', onlineDocument: 'Document' },
  header: {
    version: 'Version',
    // user dropdown
    dropdownItemDoc: 'Document',
    ChangePassword: 'ChangePassword',
    dropdownItemLoginOut: 'Login Out',

    tooltipErrorLog: 'Error log',
    tooltipLock: 'Lock screen',
    tooltipNotify: 'Notification',

    tooltipEntryFull: 'Full Screen',
    tooltipExitFull: 'Exit Full Screen',

    // lock
    lockScreenPassword: 'Lock screen password',
    lockScreen: 'Lock screen',
    lockScreenBtn: 'Locking',

    home: 'Home',
  },
  multipleTab: {
    reload: 'Refresh current',
    close: 'Close current',
    closeLeft: 'Close Left',
    closeRight: 'Close Right',
    closeOther: 'Close Other',
    closeAll: 'Close All',
  },
  setting: {
    // content mode
    contentModeFull: 'Full',
    contentModeFixed: 'Fixed width',
    // topMenu align
    topMenuAlignLeft: 'Left',
    topMenuAlignRight: 'Center',
    topMenuAlignCenter: 'Right',
    // menu trigger
    menuTriggerNone: 'Not Show',
    menuTriggerBottom: 'Bottom',
    menuTriggerTop: 'Top',
    // menu type
    menuTypeSidebar: 'Left menu mode',
    menuTypeMixSidebar: 'Left menu mixed mode',
    menuTypeMix: 'Top Menu Mix mode',
    menuTypeTopMenu: 'Top menu mode',

    on: 'On',
    off: 'Off',
    minute: 'Minute',

    operatingTitle: 'Successful!',
    operatingContent:
      'The copy is successful, please go to src/settings/projectSetting.ts to modify the configuration!',
    resetSuccess: 'Successfully reset!',

    copyBtn: 'Copy',
    clearBtn: 'Clear cache and to the login page',

    drawerTitle: 'Configuration',

    darkMode: 'Dark mode',
    navMode: 'Navigation mode',
    interfaceFunction: 'Interface function',
    interfaceDisplay: 'Interface display',
    animation: 'Animation',
    splitMenu: 'Split menu',
    closeMixSidebarOnChange: 'Switch page to close menu',

    sysTheme: 'System theme',
    headerTheme: 'Header theme',
    sidebarTheme: 'Menu theme',

    menuDrag: 'Drag Sidebar',
    menuSearch: 'Menu search',
    menuAccordion: 'Sidebar accordion',
    menuCollapse: 'Collapse menu',
    collapseMenuDisplayName: 'Collapse menu display name',
    topMenuLayout: 'Top menu layout',
    menuCollapseButton: 'Menu collapse button',
    contentMode: 'Content area width',
    expandedMenuWidth: 'Expanded menu width',

    breadcrumb: 'Breadcrumbs',
    breadcrumbIcon: 'Breadcrumbs Icon',
    tabs: 'Tabs',
    tabDetail: 'Tab Detail',
    tabsQuickBtn: 'Tabs quick button',
    tabsRedoBtn: 'Tabs redo button',
    tabsFoldBtn: 'Tabs flod button',
    sidebar: 'Sidebar',
    header: 'Header',
    footer: 'Footer',
    fullContent: 'Full content',
    grayMode: 'Gray mode',
    colorWeak: 'Color Weak Mode',

    progress: 'Progress',
    switchLoading: 'Switch Loading',
    switchAnimation: 'Switch animation',
    animationType: 'Animation type',

    autoScreenLock: 'Auto screen lock',
    notAutoScreenLock: 'Not auto lock',

    fixedHeader: 'Fixed header',
    fixedSideBar: 'Fixed Sidebar',

    mixSidebarTrigger: 'Mixed menu Trigger',
    triggerHover: 'Hover',
    triggerClick: 'Click',

    mixSidebarFixed: 'Fixed expanded menu',
  },
};
