/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.access;

import java.util.Map;
import org.apache.tiles.NoSuchContainerException;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TilesAccess {
    public static final String CURRENT_CONTAINER_ATTRIBUTE_NAME = "org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY";
    public static final String CONTAINER_ATTRIBUTE = "org.apache.tiles.CONTAINER";

    private TilesAccess() {
    }

    public static void setContainer(ApplicationContext context, TilesContainer container) {
        TilesAccess.setContainer(context, container, CONTAINER_ATTRIBUTE);
    }

    public static void setContainer(ApplicationContext context, TilesContainer container, String key) {
        Logger log = LoggerFactory.getLogger(TilesAccess.class);
        if (key == null) {
            key = CONTAINER_ATTRIBUTE;
        }
        if (container == null) {
            if (log.isInfoEnabled()) {
                log.info("Removing TilesContext for context: " + context.getClass().getName());
            }
            context.getApplicationScope().remove(key);
        } else {
            if (log.isInfoEnabled()) {
                log.info("Publishing TilesContext for context: " + context.getClass().getName());
            }
            context.getApplicationScope().put(key, container);
        }
    }

    public static TilesContainer getContainer(ApplicationContext context) {
        return TilesAccess.getContainer(context, CONTAINER_ATTRIBUTE);
    }

    public static TilesContainer getContainer(ApplicationContext context, String key) {
        if (key == null) {
            key = CONTAINER_ATTRIBUTE;
        }
        return (TilesContainer)context.getApplicationScope().get(key);
    }

    public static void setCurrentContainer(Request request, String key) {
        ApplicationContext applicationContext = request.getApplicationContext();
        TilesContainer container = TilesAccess.getContainer(applicationContext, key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        request.getContext("request").put(CURRENT_CONTAINER_ATTRIBUTE_NAME, container);
    }

    public static void setCurrentContainer(Request request, TilesContainer container) {
        if (container == null) {
            throw new NullPointerException("The container cannot be null");
        }
        request.getContext("request").put(CURRENT_CONTAINER_ATTRIBUTE_NAME, container);
    }

    public static TilesContainer getCurrentContainer(Request request) {
        ApplicationContext context = request.getApplicationContext();
        Map requestScope = request.getContext("request");
        TilesContainer container = (TilesContainer)requestScope.get(CURRENT_CONTAINER_ATTRIBUTE_NAME);
        if (container == null) {
            container = TilesAccess.getContainer(context);
            requestScope.put(CURRENT_CONTAINER_ATTRIBUTE_NAME, container);
        }
        return container;
    }
}

