/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.collect;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.base.Predicate;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Iterators;
import com.google.gxp.com.google.common.collect.Lists;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collections2 {
    private Collections2() {
    }

    public static <T> Collection<T> forIterable(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterable.iterator();
            }

            @Override
            public int size() {
                return Iterables.size(iterable);
            }

            @Override
            public boolean isEmpty() {
                return Iterables.isEmpty(iterable);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return Iterators.removeAll(this.iterator(), c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return Iterators.retainAll(this.iterator(), c);
            }
        };
    }

    static boolean containsAll(Collection<?> self, Collection<?> c) {
        Preconditions.checkNotNull(self);
        for (Object o : c) {
            if (self.contains(o)) continue;
            return false;
        }
        return true;
    }

    static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : Lists.newArrayList(iterable);
    }

    public static <T> Collection<T> filter(Collection<T> unfiltered, Predicate<? super T> predicate) {
        return new FilteredCollection<T>(unfiltered, predicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilteredCollection<T>
    implements Collection<T> {
        private final Collection<T> unfiltered;
        private final Predicate<? super T> predicate;

        FilteredCollection(Collection<T> unfiltered, Predicate<? super T> predicate) {
            this.unfiltered = Preconditions.checkNotNull(unfiltered);
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean add(T element) {
            Preconditions.checkArgument(this.predicate.apply(element));
            return this.unfiltered.add(element);
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            for (T element : collection) {
                Preconditions.checkArgument(this.predicate.apply(element));
            }
            return this.unfiltered.addAll(collection);
        }

        @Override
        public void clear() {
            Iterator<T> iterator = this.unfiltered.iterator();
            while (iterator.hasNext()) {
                T element = iterator.next();
                if (!this.predicate.apply(element)) continue;
                iterator.remove();
            }
        }

        @Override
        public boolean contains(Object element) {
            try {
                return this.predicate.apply(element) && this.unfiltered.contains(element);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !Iterators.any(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.filter(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public boolean remove(Object element) {
            try {
                return this.predicate.apply(element) && this.unfiltered.remove(element);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            boolean changed = false;
            Iterator<T> iterator = this.unfiltered.iterator();
            while (iterator.hasNext()) {
                T element = iterator.next();
                if (!this.predicate.apply(element) || !collection.contains(element)) continue;
                iterator.remove();
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            boolean changed = false;
            Iterator<T> iterator = this.unfiltered.iterator();
            while (iterator.hasNext()) {
                T element = iterator.next();
                if (!this.predicate.apply(element) || collection.contains(element)) continue;
                iterator.remove();
                changed = true;
            }
            return changed;
        }

        @Override
        public int size() {
            return Iterators.size(this.iterator());
        }

        @Override
        public Object[] toArray() {
            return Lists.newArrayList(this.iterator()).toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return Lists.newArrayList(this.iterator()).toArray(array);
        }

        public String toString() {
            return Iterators.toString(this.iterator());
        }
    }
}

