/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.java;

import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.java.JavaCodeGenerator;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicImplJavaCodeGenerator
extends JavaCodeGenerator {
    private final long compilationVersion;

    public DynamicImplJavaCodeGenerator(MessageExtractedTree tree, long compilationVersion) {
        super(tree, (String)null);
        this.compilationVersion = compilationVersion;
    }

    @Override
    protected TemplateWorker createTemplateWorker(Appendable appendable, AlertSink alertSink, Template template, String runtimeMessageSource) {
        return new TemplateWorker(appendable, alertSink, template, this.compilationVersion);
    }

    protected static class TemplateWorker
    extends JavaCodeGenerator.TemplateWorker {
        private final long compilationVersion;
        private Pattern PARAM_PATTERN = Pattern.compile("%[1-9%]");

        TemplateWorker(Appendable appendable, AlertSink alertSink, Template template, long compilationVersion) {
            super(appendable, alertSink, template, null);
            this.compilationVersion = compilationVersion;
        }

        @Override
        public TemplateWorker createSubWorker(Appendable newAppendable) {
            return new TemplateWorker(newAppendable, this.alertSink, this.template, this.compilationVersion);
        }

        @Override
        protected String getClassName(TemplateName templateName) {
            return super.getClassName(templateName) + "$Impl" + this.compilationVersion;
        }

        @Override
        protected String getBaseClassName() {
            return "com.google.gxp.base.dynamic.ImplGxpTemplate";
        }

        @Override
        protected StatementVisitor getStatementVisitor() {
            return new StatementVisitor();
        }

        @Override
        protected ToEscapableExpressionVisitor getToEscapableExpressionVisitor() {
            return new ToEscapableExpressionVisitor();
        }

        @Override
        protected void appendGetArgListMethod() {
        }

        @Override
        protected void appendGetGxpClosureMethod(boolean isStatic) {
        }

        @Override
        protected void appendInterface() {
        }

        @Override
        protected void appendInstance() {
        }

        private class ToEscapableExpressionVisitor
        extends JavaCodeGenerator.TemplateWorker.ToEscapableExpressionVisitor {
            private ToEscapableExpressionVisitor() {
                super(TemplateWorker.this);
            }

            @Override
            public String visitExtractedMessage(ExtractedMessage msg) {
                StringBuilder sb = new StringBuilder("formatGxpMessage(");
                sb.append(OutputLanguage.JAVA.toStringLiteral(msg.getTcMessage().getOriginal()));
                for (Expression param : msg.getParameters()) {
                    sb.append(", ");
                    sb.append(msg.getSchema().getJavaAppender());
                    sb.append(".INSTANCE.append(new StringBuilder(), gxp_context, ");
                    sb.append(TemplateWorker.this.getJavaExpression(param));
                    sb.append(").toString()");
                }
                sb.append(')');
                return sb.toString();
            }
        }

        private class StatementVisitor
        extends JavaCodeGenerator.TemplateWorker.StatementVisitor {
            private StatementVisitor() {
                super(TemplateWorker.this);
            }

            @Override
            public Void visitExtractedMessage(ExtractedMessage msg) {
                String org = msg.getTcMessage().getOriginal();
                List<Expression> params = msg.getParameters();
                ArrayList<String> paramVars = Lists.newArrayListWithExpectedSize(params.size());
                for (Expression param : params) {
                    String varName = TemplateWorker.this.createVarName("ph");
                    paramVars.add(varName);
                    TemplateWorker.this.formatLine(param.getSourcePosition(), "String %s = %s.INSTANCE.append(new StringBuilder(), gxp_context, %s).toString();", new Object[]{varName, msg.getSchema().getJavaAppender(), TemplateWorker.this.getJavaExpression(param)});
                }
                Matcher m = TemplateWorker.this.PARAM_PATTERN.matcher(org);
                int start = 0;
                while (m.find(start)) {
                    String s;
                    if (m.start() != start) {
                        TemplateWorker.this.writeString(msg.getSourcePosition(), org.substring(start, m.start()));
                    }
                    if ((s = m.group().substring(1)).equals("%")) {
                        TemplateWorker.this.writeString(msg.getSourcePosition(), "%");
                    } else {
                        String var = (String)paramVars.get(Integer.parseInt(s) - 1);
                        TemplateWorker.this.writeExpression(msg.getSourcePosition(), var);
                    }
                    start = m.end();
                }
                if (org.length() > start) {
                    TemplateWorker.this.writeString(msg.getSourcePosition(), org.substring(start));
                }
                return null;
            }
        }
    }
}

