/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import org.apache.sysml.parser.ConditionalPredicate;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;

public class IfStatement
extends Statement {
    private ConditionalPredicate _predicate = null;
    private ArrayList<StatementBlock> _ifBody = new ArrayList();
    private ArrayList<StatementBlock> _elseBody = new ArrayList();

    @Override
    public Statement rewriteStatement(String prefix) {
        throw new LanguageException(this.printErrorLocation() + "should not call rewriteStatement for IfStatement");
    }

    public void setConditionalPredicate(ConditionalPredicate pred) {
        this._predicate = pred;
    }

    public void addStatementBlockIfBody(StatementBlock sb) {
        this._ifBody.add(sb);
    }

    public void addStatementBlockElseBody(StatementBlock sb) {
        this._elseBody.add(sb);
    }

    public ConditionalPredicate getConditionalPredicate() {
        return this._predicate;
    }

    public ArrayList<StatementBlock> getIfBody() {
        return this._ifBody;
    }

    public ArrayList<StatementBlock> getElseBody() {
        return this._elseBody;
    }

    public void setIfBody(ArrayList<StatementBlock> body) {
        this._ifBody = body;
    }

    public void setElseBody(ArrayList<StatementBlock> body) {
        this._elseBody = body;
    }

    @Override
    public boolean controlStatement() {
        return true;
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
        throw new LanguageException(this.printErrorLocation() + "should never call initializeforwardLV for IfStatement");
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        throw new LanguageException(this.printErrorLocation() + "should never call initializeforwardLV for IfStatement");
    }

    public void mergeStatementBlocksIfBody() {
        this._ifBody = StatementBlock.mergeStatementBlocks(this._ifBody);
    }

    public void mergeStatementBlocksElseBody() {
        if (!this._elseBody.isEmpty()) {
            this._elseBody = StatementBlock.mergeStatementBlocks(this._elseBody);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("if ( ");
        sb.append(this._predicate.toString());
        sb.append(") { \n");
        for (StatementBlock block : this._ifBody) {
            sb.append(block.toString());
        }
        sb.append("}\n");
        if (!this._elseBody.isEmpty()) {
            sb.append(" else { \n");
            for (StatementBlock block : this._elseBody) {
                sb.append(block.toString());
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        LOG.warn("WARNING: line " + this.getBeginLine() + ", column " + this.getBeginColumn() + " --  should not call variablesRead from IfStatement ");
        return null;
    }

    @Override
    public VariableSet variablesUpdated() {
        LOG.warn("WARNING: line " + this.getBeginLine() + ", column " + this.getBeginColumn() + " --  should not call variablesUpdated from IfStatement ");
        return null;
    }
}

