/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.DenseBlockDRB;
import org.apache.sysml.runtime.matrix.data.DenseBlockLDRB;

public abstract class DenseBlockFactory {
    public static DenseBlock createDenseBlock(int rlen, int clen) {
        DenseBlock.Type type = (long)rlen * (long)clen < Integer.MAX_VALUE ? DenseBlock.Type.DRB : DenseBlock.Type.LDRB;
        return DenseBlockFactory.createDenseBlock(type, rlen, clen);
    }

    public static DenseBlock createDenseBlock(double[] data, int rlen, int clen) {
        return new DenseBlockDRB(data, rlen, clen);
    }

    public static DenseBlock createDenseBlock(DenseBlock.Type type, int rlen, int clen) {
        switch (type) {
            case DRB: {
                return new DenseBlockDRB(rlen, clen);
            }
            case LDRB: {
                return new DenseBlockLDRB(rlen, clen);
            }
        }
        throw new RuntimeException("Unexpected dense block type: " + type.name());
    }

    public static boolean isDenseBlockType(DenseBlock sblock, DenseBlock.Type type) {
        return DenseBlockFactory.getDenseBlockType(sblock) == type;
    }

    public static DenseBlock.Type getDenseBlockType(DenseBlock dblock) {
        return dblock instanceof DenseBlockDRB ? DenseBlock.Type.DRB : (dblock instanceof DenseBlockLDRB ? DenseBlock.Type.LDRB : null);
    }
}

