/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class BinaryFrameMatrixCPInstruction
extends BinaryCPInstruction {
    protected BinaryFrameMatrixCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        FrameBlock inBlock1 = ec.getFrameInput(this.input1.getName());
        MatrixBlock featurelength = ec.getMatrixInput(this.input2.getName());
        FrameBlock out = inBlock1.invalidByLength(featurelength);
        ec.releaseFrameInput(this.input1.getName());
        ec.releaseMatrixInput(this.input2.getName());
        ec.setFrameOutput(this.output.getName(), out);
    }
}

