/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.AppendRSPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDAggregateUtils;
import org.apache.sysds.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class FrameAppendRSPInstruction
extends AppendRSPInstruction {
    protected FrameAppendRSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean cbind, String opcode, String istr) {
        super(op, in1, in2, out, cbind, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<Long, FrameBlock> in2 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input2.getName());
        long leftRows = sec.getDataCharacteristics(this.input1.getName()).getRows();
        JavaPairRDD<Long, FrameBlock> out = FrameAppendRSPInstruction.appendFrameRSP(in1, in2, leftRows, this._cbind);
        this.updateBinaryAppendOutputDataCharacteristics(sec, this._cbind);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
        if (this._cbind) {
            sec.getFrameObject(this.output.getName()).setSchema(sec.getFrameObject(this.input1.getName()).mergeSchemas(sec.getFrameObject(this.input2.getName())));
        } else {
            sec.getFrameObject(this.output.getName()).setSchema(sec.getFrameObject(this.input1.getName()).getSchema());
        }
    }

    public static JavaPairRDD<Long, FrameBlock> appendFrameRSP(JavaPairRDD<Long, FrameBlock> in1, JavaPairRDD<Long, FrameBlock> in2, long leftRows, boolean cbind) {
        if (cbind) {
            long[] row_indices = in1.keys().collect().stream().mapToLong(Long::longValue).toArray();
            Arrays.sort(row_indices);
            JavaPairRDD<Long, FrameBlock> in2Aligned = in2.flatMapToPair((PairFlatMapFunction)new ReduceSideAppendAlignToLHSFunction(row_indices, leftRows));
            in2Aligned = FrameRDDAggregateUtils.mergeByKey(in2Aligned);
            return in1.join(in2Aligned).mapValues((Function)new ReduceSideColumnsFunction(cbind));
        }
        JavaPairRDD right = in2.mapToPair((PairFunction)new ReduceSideAppendRowsFunction(leftRows));
        return in1.union(right);
    }

    private static class ReduceSideAppendAlignFunction
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766409L;
        private long _rows;

        public ReduceSideAppendAlignFunction(long rows) {
            this._rows = rows;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, FrameBlock> arg0) throws Exception {
            FrameBlock resultBlock = new FrameBlock(((FrameBlock)arg0._2()).getSchema());
            long index = (Long)arg0._1() / 1000L * 1000L + 1L;
            int maxRows = (int)(this._rows - index + 1L >= 1000L ? 1000L : this._rows - index + 1L);
            resultBlock.ensureAllocatedColumns(maxRows);
            resultBlock = resultBlock.leftIndexingOperations((FrameBlock)arg0._2(), 0, maxRows - 1, 0, ((FrameBlock)arg0._2()).getNumColumns() - 1, new FrameBlock());
            return new Tuple2((Object)index, (Object)resultBlock);
        }
    }

    private static class ReduceSideAppendRowsFunction
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = 1723795153048336791L;
        private long _offset;

        public ReduceSideAppendRowsFunction(long offset) {
            this._offset = offset;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, FrameBlock> arg0) throws Exception {
            return new Tuple2((Object)((Long)arg0._1() + this._offset), (Object)((FrameBlock)arg0._2()));
        }
    }

    private static class ReduceSideAppendAlignToLHSFunction
    implements PairFlatMapFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766409L;
        private final long[] _indices;
        private final long lastIndex;

        public ReduceSideAppendAlignToLHSFunction(long[] indices, long max_rows) {
            this._indices = indices;
            this.lastIndex = max_rows + 1L;
        }

        public Iterator<Tuple2<Long, FrameBlock>> call(Tuple2<Long, FrameBlock> arg0) {
            int sizeOfRHS;
            ArrayList<Tuple2> aligned_blocks = new ArrayList<Tuple2>();
            long indexRHS = (Long)arg0._1();
            FrameBlock fb = (FrameBlock)arg0._2();
            int L = 0;
            int R = this._indices.length - 1;
            while (L <= R) {
                int m = (L + R) / 2;
                if (this._indices[m] == indexRHS) {
                    R = m;
                    break;
                }
                if (this._indices[m] < indexRHS) {
                    L = m + 1;
                    continue;
                }
                R = m - 1;
            }
            long indexLHS = this._indices[R];
            long nextIndexLHS = R < this._indices.length - 1 ? this._indices[R + 1] : this.lastIndex;
            int blkSizeLHS = (int)(nextIndexLHS - indexLHS);
            int offsetLHS = (int)(indexRHS - indexLHS);
            int offsetRHS = 0;
            int sizeOfSlice = blkSizeLHS - offsetLHS;
            FrameBlock resultBlock = new FrameBlock(fb.getSchema());
            resultBlock.ensureAllocatedColumns(blkSizeLHS);
            for (sizeOfRHS = fb.getNumRows(); sizeOfSlice < sizeOfRHS; sizeOfRHS -= sizeOfSlice) {
                FrameBlock fb_sliced = fb.slice(offsetRHS, offsetRHS + sizeOfSlice - 1);
                resultBlock = resultBlock.leftIndexingOperations(fb_sliced, offsetLHS, offsetLHS + sizeOfSlice - 1, 0, fb.getNumColumns() - 1, new FrameBlock());
                aligned_blocks.add(new Tuple2((Object)indexLHS, (Object)resultBlock));
                resultBlock = new FrameBlock(fb.getSchema());
                if (R >= this._indices.length - 1) {
                    throw new RuntimeException("Alignment Error while CBIND: LHS has fewer rows than RHS");
                }
                indexLHS = nextIndexLHS;
                offsetRHS += sizeOfSlice;
                offsetLHS = 0;
                nextIndexLHS = ++R < this._indices.length - 1 ? this._indices[R + 1] : this.lastIndex;
                sizeOfSlice = (int)(nextIndexLHS - indexLHS);
                resultBlock.ensureAllocatedColumns(sizeOfSlice);
            }
            if (offsetRHS != 0) {
                fb = fb.slice(offsetRHS, offsetRHS + sizeOfRHS - 1);
            }
            resultBlock = resultBlock.leftIndexingOperations(fb, offsetLHS, offsetLHS + fb.getNumRows() - 1, 0, fb.getNumColumns() - 1, new FrameBlock());
            aligned_blocks.add(new Tuple2((Object)indexLHS, (Object)resultBlock));
            return aligned_blocks.iterator();
        }
    }

    private static class ReduceSideColumnsFunction
    implements Function<Tuple2<FrameBlock, FrameBlock>, FrameBlock> {
        private static final long serialVersionUID = -97824903649667646L;
        private boolean _cbind = true;

        public ReduceSideColumnsFunction(boolean cbind) {
            this._cbind = cbind;
        }

        public FrameBlock call(Tuple2<FrameBlock, FrameBlock> arg0) {
            FrameBlock left = (FrameBlock)arg0._1();
            FrameBlock right = (FrameBlock)arg0._2();
            return left.append(right, this._cbind);
        }
    }
}

