package de.averbis;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.tools.PackageInstaller;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.junit.Assert;
import org.junit.Test;

public class PearMessageTest {

	Path installationDirectoryPath = Paths.get("target/pearTest");
	Path pearPackageFilePath = Paths.get("target/pear-1.0.0-SNAPSHOT.pear");


	@Test
	public void pearMessageTranslationTest() throws IOException, UIMAException {

		PackageBrowser packageBrowser = this.installPear();
		AnalysisEngine analysisEngine = this.produceAnalysisEngine(packageBrowser);

		JCas jCas = JCasFactory.createJCas();
		try {

			analysisEngine.process(jCas);

		} catch (AnalysisEngineProcessException e) {

			String translatedExceptionMessage = e.getLocalizedMessage(Locale.ENGLISH);

			String expectedErrorMessage = "TestErrorMessage for pear resourceBundle";
			String expectedArgument = "ARGUMENT";

			Assert.assertTrue("Translated message (" + translatedExceptionMessage + ") did not contain the error message (" + expectedErrorMessage + ").",
					translatedExceptionMessage.contains(expectedErrorMessage));
			Assert.assertTrue("Translated message (" + translatedExceptionMessage + ") did not contain the argument (" + expectedArgument + ")",
					translatedExceptionMessage.contains(expectedArgument));
		}
	}


	private PackageBrowser installPear() {

		File installationDirectory = this.installationDirectoryPath.toFile();
		File pearPackageFile = this.pearPackageFilePath.toFile();
		boolean verify = true;
		boolean cleanInstallDirectory = true;

		return PackageInstaller.installPackage(installationDirectory, pearPackageFile, verify, cleanInstallDirectory);
	}


	private AnalysisEngine produceAnalysisEngine(PackageBrowser packageBrowser) throws IOException, InvalidXMLException, ResourceInitializationException {

		XMLInputSource xmlInputSource = new XMLInputSource(packageBrowser.getComponentPearDescPath());
		PearSpecifier parsePearSpecifier = UIMAFramework.getXMLParser().parsePearSpecifier(xmlInputSource);

		return UIMAFramework.produceAnalysisEngine(parsePearSpecifier);
	}
}