/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.util.gradle.Path;
import org.eclipse.buildship.ui.internal.view.task.BaseProjectNode;
import org.eclipse.buildship.ui.internal.view.task.BuildInvocations;
import org.eclipse.buildship.ui.internal.view.task.FaultyProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectTask;
import org.eclipse.buildship.ui.internal.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.internal.view.task.TaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskSelector;
import org.eclipse.buildship.ui.internal.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.internal.view.task.TaskView;
import org.eclipse.buildship.ui.internal.view.task.TaskViewContent;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class TaskViewContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final TaskView taskView;

    public TaskViewContentProvider(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object input) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (input instanceof TaskViewContent) {
            TaskViewContent taskViewContent = (TaskViewContent)input;
            List<EclipseProject> projects = taskViewContent.getProjects();
            List<IProject> faultyProjects = taskViewContent.getFaultyProjects();
            result.addAll(this.createTopLevelProjectNodes(projects, faultyProjects));
        }
        return result.build().toArray();
    }

    private List<BaseProjectNode> createTopLevelProjectNodes(List<EclipseProject> projects, List<IProject> faultyProjects) {
        GradleProject gradleProject;
        ArrayList allProjectNodes = Lists.newArrayList();
        if (this.taskView.getState().isProjectHierarchyFlattened()) {
            for (EclipseProject project : projects) {
                gradleProject = project.getGradleProject();
                if (gradleProject.getParent() != null) continue;
                Map<Path, BuildInvocations> invocations = BuildInvocations.collectAll(gradleProject);
                this.collectProjectNodesRecursively(project, null, allProjectNodes, invocations);
            }
        } else {
            for (EclipseProject project : projects) {
                if (project.getParent() != null) continue;
                gradleProject = project.getGradleProject();
                Optional workspaceProject = CorePlugin.workspaceOperations().findProjectByName(project.getName());
                Map<Path, BuildInvocations> invocations = BuildInvocations.collectAll(gradleProject);
                allProjectNodes.add(new ProjectNode(null, project, gradleProject, (Optional<IProject>)workspaceProject, TaskViewContentProvider.isIncludedProject((Optional<IProject>)workspaceProject, project), invocations, Path.from((String)gradleProject.getPath())));
            }
        }
        for (IProject faultyProject : faultyProjects) {
            allProjectNodes.add(new FaultyProjectNode(faultyProject));
        }
        return allProjectNodes;
    }

    private void collectProjectNodesRecursively(EclipseProject eclipseProject, ProjectNode parentProjectNode, List<BaseProjectNode> allProjectNodes, Map<Path, BuildInvocations> invocationsContainer) {
        GradleProject gradleProject = eclipseProject.getGradleProject();
        Optional workspaceProject = CorePlugin.workspaceOperations().findProjectByName(eclipseProject.getName());
        ProjectNode projectNode = new ProjectNode(parentProjectNode, eclipseProject, gradleProject, (Optional<IProject>)workspaceProject, TaskViewContentProvider.isIncludedProject((Optional<IProject>)workspaceProject, eclipseProject), invocationsContainer, Path.from((String)gradleProject.getPath()));
        allProjectNodes.add(projectNode);
        for (EclipseProject childProject : eclipseProject.getChildren()) {
            this.collectProjectNodesRecursively(childProject, projectNode, allProjectNodes, invocationsContainer);
        }
    }

    private static boolean isIncludedProject(Optional<IProject> workspaceProject, EclipseProject modelProject) {
        if (!workspaceProject.isPresent()) {
            return false;
        }
        IProject project = (IProject)workspaceProject.get();
        if (!GradleProjectNature.isPresentOn((IProject)project)) {
            return false;
        }
        ProjectConfiguration projectConfig = CorePlugin.configurationManager().loadProjectConfiguration(project);
        File configRootDir = projectConfig.getBuildConfiguration().getRootProjectDirectory();
        File modelRootDir = modelProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
        return !modelRootDir.equals(configRootDir);
    }

    public boolean hasChildren(Object element) {
        return element instanceof ProjectNode || element instanceof TaskGroupNode;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ProjectNode) {
            return this.childrenOf((ProjectNode)parent);
        }
        if (parent instanceof TaskGroupNode) {
            return this.childrenOf((TaskGroupNode)parent);
        }
        return NO_CHILDREN;
    }

    private Object[] childrenOf(ProjectNode projectNode) {
        HashSet result = Sets.newHashSet();
        if (!this.taskView.getState().isProjectHierarchyFlattened()) {
            result.addAll(this.projectNodesFor(projectNode));
        }
        if (this.taskView.getState().isGroupTasks()) {
            result.addAll(TaskViewContentProvider.groupNodesFor(projectNode));
        } else {
            result.addAll(TaskViewContentProvider.taskNodesFor(projectNode));
        }
        return result.toArray();
    }

    private Set<ProjectNode> projectNodesFor(ProjectNode projectNode) {
        HashSet result = Sets.newHashSet();
        EclipseProject eclipseProject = projectNode.getEclipseProject();
        for (EclipseProject childProject : eclipseProject.getChildren()) {
            GradleProject gradleProject = childProject.getGradleProject();
            Optional workspaceProject = CorePlugin.workspaceOperations().findProjectByName(childProject.getName());
            ProjectNode childProjectNode = new ProjectNode(projectNode, childProject, gradleProject, (Optional<IProject>)workspaceProject, TaskViewContentProvider.isIncludedProject((Optional<IProject>)workspaceProject, eclipseProject), projectNode.getAllBuildInvocations(), Path.from((String)gradleProject.getPath()));
            result.add(childProjectNode);
        }
        return result;
    }

    public static Set<TaskGroupNode> groupNodesFor(ProjectNode projectNode) {
        HashSet result = Sets.newHashSet();
        result.add(TaskGroupNode.getDefault(projectNode));
        for (ProjectTask projectTask : projectNode.getInvocations().getProjectTasks()) {
            result.add(TaskGroupNode.forName(projectNode, projectTask.getGroup()));
        }
        for (TaskSelector taskSelector : projectNode.getInvocations().getTaskSelectors()) {
            result.add(TaskGroupNode.forName(projectNode, taskSelector.getGroup()));
        }
        return result;
    }

    public static List<TaskNode> taskNodesFor(ProjectNode projectNode) {
        ArrayList taskNodes = Lists.newArrayList();
        for (ProjectTask projectTask : projectNode.getInvocations().getProjectTasks()) {
            taskNodes.add(new ProjectTaskNode(projectNode, projectTask));
        }
        for (TaskSelector taskSelector : projectNode.getInvocations().getTaskSelectors()) {
            taskNodes.add(new TaskSelectorNode(projectNode, taskSelector));
        }
        return taskNodes;
    }

    private Object[] childrenOf(TaskGroupNode groupNode) {
        return groupNode.getTaskNodes().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof ProjectNode) {
            return ((ProjectNode)element).getParentProjectNode();
        }
        if (element instanceof TaskNode) {
            return ((TaskNode)element).getParentProjectNode();
        }
        if (element instanceof TaskGroupNode) {
            return ((TaskGroupNode)element).getProjectNode();
        }
        return null;
    }

    public void dispose() {
    }
}

