/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google$.auto.common;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.base.$Objects;
import autovalue.shaded.com.google$.common.base.$Optional;
import autovalue.shaded.com.google$.common.base.$Preconditions;
import autovalue.shaded.com.google$.common.base.$Predicate;
import autovalue.shaded.com.google$.common.base.$Throwables;
import autovalue.shaded.com.google$.common.collect.$FluentIterable;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

public final class $MoreTypes {
    private static final Class<?> INTERSECTION_TYPE;
    private static final Method GET_BOUNDS;
    private static final int HASH_SEED = 17;
    private static final int HASH_MULTIPLIER = 31;

    public static $Equivalence<TypeMirror> equivalence() {
        return TypeEquivalence.INSTANCE;
    }

    private static boolean equal(TypeMirror a, TypeMirror b, Set<ComparedElements> visiting) {
        if ($Objects.equal(a, b) && !(a instanceof ExecutableType)) {
            return true;
        }
        EqualVisitorParam p = new EqualVisitorParam();
        p.type = b;
        p.visiting = visiting;
        if (INTERSECTION_TYPE != null) {
            if ($MoreTypes.isIntersectionType(a)) {
                return $MoreTypes.equalIntersectionTypes(a, b, visiting);
            }
            if ($MoreTypes.isIntersectionType(b)) {
                return false;
            }
        }
        return a == b || a != null && b != null && a.accept(EqualVisitor.INSTANCE, p) != false;
    }

    private static TypeMirror enclosingType(DeclaredType t) {
        TypeMirror enclosing = t.getEnclosingType();
        if (enclosing.getKind().equals((Object)TypeKind.NONE) || t.asElement().getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        return enclosing;
    }

    private static boolean isIntersectionType(TypeMirror t) {
        return t != null && t.getKind().name().equals("INTERSECTION");
    }

    private static boolean equalIntersectionTypes(TypeMirror a, TypeMirror b, Set<ComparedElements> visiting) {
        List bBounds;
        List aBounds;
        if (!$MoreTypes.isIntersectionType(b)) {
            return false;
        }
        try {
            aBounds = (List)GET_BOUNDS.invoke((Object)a, new Object[0]);
            bBounds = (List)GET_BOUNDS.invoke((Object)b, new Object[0]);
        }
        catch (Exception e) {
            throw $Throwables.propagate(e);
        }
        return $MoreTypes.equalLists(aBounds, bBounds, visiting);
    }

    private static boolean equalLists(List<? extends TypeMirror> a, List<? extends TypeMirror> b, Set<ComparedElements> visiting) {
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        Iterator<? extends TypeMirror> aIterator = a.iterator();
        Iterator<? extends TypeMirror> bIterator = b.iterator();
        while (aIterator.hasNext()) {
            TypeMirror nextMirrorB;
            if (!bIterator.hasNext()) {
                return false;
            }
            TypeMirror nextMirrorA = aIterator.next();
            if ($MoreTypes.equal(nextMirrorA, nextMirrorB = bIterator.next(), visiting)) continue;
            return false;
        }
        return !aIterator.hasNext();
    }

    private static int hashList(List<? extends TypeMirror> mirrors, Set<Element> visiting) {
        int result = 17;
        for (TypeMirror typeMirror : mirrors) {
            result *= 31;
            result += $MoreTypes.hash(typeMirror, visiting);
        }
        return result;
    }

    private static int hash(TypeMirror mirror, Set<Element> visiting) {
        return mirror == null ? 0 : mirror.accept(HashVisitor.INSTANCE, visiting);
    }

    public static $ImmutableSet<TypeElement> referencedTypes(TypeMirror type) {
        $Preconditions.checkNotNull(type);
        $ImmutableSet.Builder elements = $ImmutableSet.builder();
        type.accept(ReferencedTypes.INSTANCE, elements);
        return elements.build();
    }

    public static Element asElement(TypeMirror typeMirror) {
        return typeMirror.accept(AsElementVisitor.INSTANCE, null);
    }

    public static TypeElement asTypeElement(TypeMirror mirror) {
        return $MoreElements.asType($MoreTypes.asElement(mirror));
    }

    public static $ImmutableSet<TypeElement> asTypeElements(Iterable<? extends TypeMirror> mirrors) {
        $Preconditions.checkNotNull(mirrors);
        $ImmutableSet.Builder builder = $ImmutableSet.builder();
        for (TypeMirror typeMirror : mirrors) {
            builder.add($MoreTypes.asTypeElement(typeMirror));
        }
        return builder.build();
    }

    public static ArrayType asArray(TypeMirror maybeArrayType) {
        return maybeArrayType.accept(ArrayTypeVisitor.INSTANCE, null);
    }

    public static DeclaredType asDeclared(TypeMirror maybeDeclaredType) {
        return maybeDeclaredType.accept(DeclaredTypeVisitor.INSTANCE, null);
    }

    public static ErrorType asError(TypeMirror maybeErrorType) {
        return maybeErrorType.accept(ErrorTypeVisitor.INSTANCE, null);
    }

    public static ExecutableType asExecutable(TypeMirror maybeExecutableType) {
        return maybeExecutableType.accept(ExecutableTypeVisitor.INSTANCE, null);
    }

    public static NoType asNoType(TypeMirror maybeNoType) {
        return maybeNoType.accept(NoTypeVisitor.INSTANCE, null);
    }

    public static NullType asNullType(TypeMirror maybeNullType) {
        return maybeNullType.accept(NullTypeVisitor.INSTANCE, null);
    }

    public static PrimitiveType asPrimitiveType(TypeMirror maybePrimitiveType) {
        return maybePrimitiveType.accept(PrimitiveTypeVisitor.INSTANCE, null);
    }

    public static TypeVariable asTypeVariable(TypeMirror maybeTypeVariable) {
        return maybeTypeVariable.accept(TypeVariableVisitor.INSTANCE, null);
    }

    public static WildcardType asWildcard(TypeMirror maybeWildcardType) {
        return maybeWildcardType.accept(WildcardTypeVisitor.INSTANCE, null);
    }

    public static boolean isType(TypeMirror type) {
        return type.accept(IsTypeVisitor.INSTANCE, null);
    }

    public static boolean isTypeOf(Class<?> clazz, TypeMirror type) {
        $Preconditions.checkNotNull(clazz);
        return type.accept(new IsTypeOf(clazz), null);
    }

    public static $Optional<DeclaredType> nonObjectSuperclass(final Types types, Elements elements, DeclaredType type) {
        $Preconditions.checkNotNull(types);
        $Preconditions.checkNotNull(elements);
        $Preconditions.checkNotNull(type);
        final TypeMirror objectType = elements.getTypeElement(Object.class.getCanonicalName()).asType();
        TypeMirror superclass = $Iterables.getOnlyElement($FluentIterable.from(types.directSupertypes(type)).filter(($Predicate<? extends TypeMirror>)new $Predicate<TypeMirror>(){

            @Override
            public boolean apply(TypeMirror input) {
                return input.getKind().equals((Object)TypeKind.DECLARED) && $MoreElements.asType($MoreTypes.asDeclared(input).asElement()).getKind().equals((Object)ElementKind.CLASS) && !types.isSameType(objectType, input);
            }
        }), null);
        return superclass != null ? $Optional.of($MoreTypes.asDeclared(superclass)) : $Optional.absent();
    }

    public static TypeMirror asMemberOf(Types types, DeclaredType container, VariableElement variable) {
        if (variable.getKind().equals((Object)ElementKind.PARAMETER)) {
            ExecutableElement methodOrConstructor = $MoreElements.asExecutable(variable.getEnclosingElement());
            ExecutableType resolvedMethodOrConstructor = $MoreTypes.asExecutable(types.asMemberOf(container, methodOrConstructor));
            List<? extends VariableElement> parameters = methodOrConstructor.getParameters();
            List<? extends TypeMirror> parameterTypes = resolvedMethodOrConstructor.getParameterTypes();
            $Preconditions.checkState(parameters.size() == parameterTypes.size());
            for (int i = 0; i < parameters.size(); ++i) {
                if (!parameters.get(i).equals(variable)) continue;
                return parameterTypes.get(i);
            }
            throw new IllegalStateException("Could not find variable: " + variable);
        }
        return types.asMemberOf(container, variable);
    }

    private $MoreTypes() {
    }

    static {
        Method m3;
        Class<?> c;
        try {
            c = Class.forName("javax.lang.model.type.IntersectionType");
            m3 = c.getMethod("getBounds", new Class[0]);
        }
        catch (Exception e) {
            c = null;
            m3 = null;
        }
        INTERSECTION_TYPE = c;
        GET_BOUNDS = m3;
    }

    private static abstract class CastingTypeVisitor<T>
    extends SimpleTypeVisitor6<T, Void> {
        private final String label;

        CastingTypeVisitor(String label) {
            this.label = label;
        }

        @Override
        protected T defaultAction(TypeMirror e, Void v) {
            throw new IllegalArgumentException(e + " does not represent a " + this.label);
        }
    }

    private static final class IsTypeOf
    extends SimpleTypeVisitor6<Boolean, Void> {
        private final Class<?> clazz;

        IsTypeOf(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void ignored) {
            throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitNoType(NoType noType, Void p) {
            if (noType.getKind().equals((Object)TypeKind.VOID)) {
                return this.clazz.equals(Void.TYPE);
            }
            throw new IllegalArgumentException(noType + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    return this.clazz.equals(Boolean.TYPE);
                }
                case BYTE: {
                    return this.clazz.equals(Byte.TYPE);
                }
                case CHAR: {
                    return this.clazz.equals(Character.TYPE);
                }
                case DOUBLE: {
                    return this.clazz.equals(Double.TYPE);
                }
                case FLOAT: {
                    return this.clazz.equals(Float.TYPE);
                }
                case INT: {
                    return this.clazz.equals(Integer.TYPE);
                }
                case LONG: {
                    return this.clazz.equals(Long.TYPE);
                }
                case SHORT: {
                    return this.clazz.equals(Short.TYPE);
                }
            }
            throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitArray(ArrayType array, Void p) {
            return this.clazz.isArray() && $MoreTypes.isTypeOf(this.clazz.getComponentType(), array.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void ignored) {
            TypeElement typeElement;
            try {
                typeElement = $MoreElements.asType(type.asElement());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(type + " does not represent a class or interface.");
            }
            return typeElement.getQualifiedName().contentEquals(this.clazz.getCanonicalName());
        }
    }

    private static final class IsTypeVisitor
    extends SimpleTypeVisitor6<Boolean, Void> {
        private static final IsTypeVisitor INSTANCE = new IsTypeVisitor();

        private IsTypeVisitor() {
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitNoType(NoType noType, Void p) {
            return noType.getKind().equals((Object)TypeKind.VOID);
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType array, Void p) {
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void ignored) {
            return $MoreElements.isType(type.asElement());
        }
    }

    private static final class WildcardTypeVisitor
    extends CastingTypeVisitor<WildcardType> {
        private static final WildcardTypeVisitor INSTANCE = new WildcardTypeVisitor();

        WildcardTypeVisitor() {
            super("wildcard type");
        }

        @Override
        public WildcardType visitWildcard(WildcardType type, Void ignore) {
            return type;
        }
    }

    private static final class TypeVariableVisitor
    extends CastingTypeVisitor<TypeVariable> {
        private static final TypeVariableVisitor INSTANCE = new TypeVariableVisitor();

        TypeVariableVisitor() {
            super("type variable");
        }

        @Override
        public TypeVariable visitTypeVariable(TypeVariable type, Void ignore) {
            return type;
        }
    }

    private static final class PrimitiveTypeVisitor
    extends CastingTypeVisitor<PrimitiveType> {
        private static final PrimitiveTypeVisitor INSTANCE = new PrimitiveTypeVisitor();

        PrimitiveTypeVisitor() {
            super("primitive type");
        }

        @Override
        public PrimitiveType visitPrimitive(PrimitiveType type, Void ignore) {
            return type;
        }
    }

    private static final class NullTypeVisitor
    extends CastingTypeVisitor<NullType> {
        private static final NullTypeVisitor INSTANCE = new NullTypeVisitor();

        NullTypeVisitor() {
            super("null");
        }

        @Override
        public NullType visitNull(NullType type, Void ignore) {
            return type;
        }
    }

    private static final class NoTypeVisitor
    extends CastingTypeVisitor<NoType> {
        private static final NoTypeVisitor INSTANCE = new NoTypeVisitor();

        NoTypeVisitor() {
            super("non-type");
        }

        @Override
        public NoType visitNoType(NoType type, Void ignore) {
            return type;
        }
    }

    private static final class ExecutableTypeVisitor
    extends CastingTypeVisitor<ExecutableType> {
        private static final ExecutableTypeVisitor INSTANCE = new ExecutableTypeVisitor();

        ExecutableTypeVisitor() {
            super("executable type");
        }

        @Override
        public ExecutableType visitExecutable(ExecutableType type, Void ignore) {
            return type;
        }
    }

    private static final class ErrorTypeVisitor
    extends CastingTypeVisitor<ErrorType> {
        private static final ErrorTypeVisitor INSTANCE = new ErrorTypeVisitor();

        ErrorTypeVisitor() {
            super("error type");
        }

        @Override
        public ErrorType visitError(ErrorType type, Void ignore) {
            return type;
        }
    }

    private static final class DeclaredTypeVisitor
    extends CastingTypeVisitor<DeclaredType> {
        private static final DeclaredTypeVisitor INSTANCE = new DeclaredTypeVisitor();

        DeclaredTypeVisitor() {
            super("declared type");
        }

        @Override
        public DeclaredType visitDeclared(DeclaredType type, Void ignore) {
            return type;
        }
    }

    private static final class ArrayTypeVisitor
    extends CastingTypeVisitor<ArrayType> {
        private static final ArrayTypeVisitor INSTANCE = new ArrayTypeVisitor();

        ArrayTypeVisitor() {
            super("primitive array");
        }

        @Override
        public ArrayType visitArray(ArrayType type, Void ignore) {
            return type;
        }
    }

    private static final class AsElementVisitor
    extends SimpleTypeVisitor6<Element, Void> {
        private static final AsElementVisitor INSTANCE = new AsElementVisitor();

        private AsElementVisitor() {
        }

        @Override
        protected Element defaultAction(TypeMirror e, Void p) {
            throw new IllegalArgumentException(e + " cannot be converted to an Element");
        }

        @Override
        public Element visitDeclared(DeclaredType t, Void p) {
            return t.asElement();
        }

        @Override
        public Element visitError(ErrorType t, Void p) {
            return t.asElement();
        }

        @Override
        public Element visitTypeVariable(TypeVariable t, Void p) {
            return t.asElement();
        }
    }

    private static final class ReferencedTypes
    extends SimpleTypeVisitor6<Void, $ImmutableSet.Builder<TypeElement>> {
        private static final ReferencedTypes INSTANCE = new ReferencedTypes();

        private ReferencedTypes() {
        }

        @Override
        public Void visitArray(ArrayType t, $ImmutableSet.Builder<TypeElement> p) {
            t.getComponentType().accept(this, p);
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType t, $ImmutableSet.Builder<TypeElement> p) {
            p.add((Object)$MoreElements.asType(t.asElement()));
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                typeMirror.accept(this, p);
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, $ImmutableSet.Builder<TypeElement> p) {
            t.getLowerBound().accept(this, p);
            t.getUpperBound().accept(this, p);
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, $ImmutableSet.Builder<TypeElement> p) {
            TypeMirror superBound;
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                extendsBound.accept(this, p);
            }
            if ((superBound = t.getSuperBound()) != null) {
                superBound.accept(this, p);
            }
            return null;
        }
    }

    private static final class HashVisitor
    extends SimpleTypeVisitor6<Integer, Set<Element>> {
        private static final HashVisitor INSTANCE = new HashVisitor();

        private HashVisitor() {
        }

        int hashKind(int seed, TypeMirror t) {
            int result = seed * 31;
            return result += t.getKind().hashCode();
        }

        @Override
        protected Integer defaultAction(TypeMirror e, Set<Element> visiting) {
            return this.hashKind(17, e);
        }

        @Override
        public Integer visitArray(ArrayType t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            return result += t.getComponentType().accept(this, visiting).intValue();
        }

        @Override
        public Integer visitDeclared(DeclaredType t, Set<Element> visiting) {
            Element element = t.asElement();
            if (visiting.contains(element)) {
                return 0;
            }
            HashSet<Element> newVisiting = new HashSet<Element>(visiting);
            newVisiting.add(element);
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.asElement().hashCode();
            result *= 31;
            result += t.getEnclosingType().accept(this, newVisiting).intValue();
            result *= 31;
            return result += $MoreTypes.hashList(t.getTypeArguments(), newVisiting);
        }

        @Override
        public Integer visitExecutable(ExecutableType t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += $MoreTypes.hashList(t.getParameterTypes(), visiting);
            result *= 31;
            result += t.getReturnType().accept(this, visiting).intValue();
            result *= 31;
            result += $MoreTypes.hashList(t.getThrownTypes(), visiting);
            result *= 31;
            return result += $MoreTypes.hashList(t.getTypeVariables(), visiting);
        }

        @Override
        public Integer visitTypeVariable(TypeVariable t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.getLowerBound().accept(this, visiting).intValue();
            TypeParameterElement element = (TypeParameterElement)t.asElement();
            for (TypeMirror typeMirror : element.getBounds()) {
                result *= 31;
                result += typeMirror.accept(this, visiting).intValue();
            }
            return result;
        }

        @Override
        public Integer visitWildcard(WildcardType t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.getExtendsBound() == null ? 0 : t.getExtendsBound().accept(this, visiting);
            result *= 31;
            return result += t.getSuperBound() == null ? 0 : t.getSuperBound().accept(this, visiting);
        }

        @Override
        public Integer visitUnknown(TypeMirror t, Set<Element> visiting) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class EqualVisitor
    extends SimpleTypeVisitor6<Boolean, EqualVisitorParam> {
        private static final EqualVisitor INSTANCE = new EqualVisitor();

        private EqualVisitor() {
        }

        @Override
        protected Boolean defaultAction(TypeMirror a, EqualVisitorParam p) {
            return a.getKind().equals((Object)p.type.getKind());
        }

        @Override
        public Boolean visitArray(ArrayType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.ARRAY)) {
                ArrayType b = (ArrayType)p.type;
                return $MoreTypes.equal(a.getComponentType(), b.getComponentType(), p.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitDeclared(DeclaredType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.DECLARED)) {
                DeclaredType b = (DeclaredType)p.type;
                Element aElement = a.asElement();
                Element bElement = b.asElement();
                Set<ComparedElements> newVisiting = this.visitingSetPlus(p.visiting, aElement, a.getTypeArguments(), bElement, b.getTypeArguments());
                if (newVisiting.equals(p.visiting)) {
                    return true;
                }
                return aElement.equals(bElement) && $MoreTypes.equal($MoreTypes.enclosingType(a), $MoreTypes.enclosingType(b), newVisiting) && $MoreTypes.equalLists(a.getTypeArguments(), b.getTypeArguments(), newVisiting);
            }
            return false;
        }

        @Override
        public Boolean visitError(ErrorType a, EqualVisitorParam p) {
            return a.equals(p.type);
        }

        @Override
        public Boolean visitExecutable(ExecutableType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.EXECUTABLE)) {
                ExecutableType b = (ExecutableType)p.type;
                return $MoreTypes.equalLists(a.getParameterTypes(), b.getParameterTypes(), p.visiting) && $MoreTypes.equal(a.getReturnType(), b.getReturnType(), p.visiting) && $MoreTypes.equalLists(a.getThrownTypes(), b.getThrownTypes(), p.visiting) && $MoreTypes.equalLists(a.getTypeVariables(), b.getTypeVariables(), p.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.TYPEVAR)) {
                TypeParameterElement bElement;
                TypeVariable b = (TypeVariable)p.type;
                TypeParameterElement aElement = (TypeParameterElement)a.asElement();
                Set<ComparedElements> newVisiting = this.visitingSetPlus(p.visiting, aElement, bElement = (TypeParameterElement)b.asElement());
                if (newVisiting.equals(p.visiting)) {
                    return true;
                }
                return $MoreTypes.equalLists(aElement.getBounds(), bElement.getBounds(), newVisiting) && $MoreTypes.equal(a.getLowerBound(), b.getLowerBound(), newVisiting) && a.asElement().getSimpleName().equals(b.asElement().getSimpleName());
            }
            return false;
        }

        @Override
        public Boolean visitWildcard(WildcardType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.WILDCARD)) {
                WildcardType b = (WildcardType)p.type;
                return $MoreTypes.equal(a.getExtendsBound(), b.getExtendsBound(), p.visiting) && $MoreTypes.equal(a.getSuperBound(), b.getSuperBound(), p.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitUnknown(TypeMirror a, EqualVisitorParam p) {
            throw new UnsupportedOperationException();
        }

        private Set<ComparedElements> visitingSetPlus(Set<ComparedElements> visiting, Element a, Element b) {
            $ImmutableList noArguments = $ImmutableList.of();
            return this.visitingSetPlus(visiting, a, noArguments, b, noArguments);
        }

        private Set<ComparedElements> visitingSetPlus(Set<ComparedElements> visiting, Element a, List<? extends TypeMirror> aArguments, Element b, List<? extends TypeMirror> bArguments) {
            ComparedElements comparedElements = new ComparedElements(a, $ImmutableList.copyOf(aArguments), b, $ImmutableList.copyOf(bArguments));
            HashSet<ComparedElements> newVisiting = new HashSet<ComparedElements>(visiting);
            newVisiting.add(comparedElements);
            return newVisiting;
        }
    }

    private static class ComparedElements {
        final Element a;
        final $ImmutableList<TypeMirror> aArguments;
        final Element b;
        final $ImmutableList<TypeMirror> bArguments;

        ComparedElements(Element a, $ImmutableList<TypeMirror> aArguments, Element b, $ImmutableList<TypeMirror> bArguments) {
            this.a = a;
            this.aArguments = aArguments;
            this.b = b;
            this.bArguments = bArguments;
        }

        public boolean equals(Object o) {
            if (o instanceof ComparedElements) {
                ComparedElements that = (ComparedElements)o;
                int nArguments = this.aArguments.size();
                if (!this.a.equals(that.a) || !this.b.equals(that.b) || nArguments != this.bArguments.size()) {
                    return false;
                }
                for (int i = 0; i < nArguments; ++i) {
                    if (this.aArguments.get(i) == this.bArguments.get(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }
    }

    private static final class EqualVisitorParam {
        TypeMirror type;
        Set<ComparedElements> visiting;

        private EqualVisitorParam() {
        }
    }

    private static final class TypeEquivalence
    extends $Equivalence<TypeMirror> {
        private static final TypeEquivalence INSTANCE = new TypeEquivalence();

        private TypeEquivalence() {
        }

        @Override
        protected boolean doEquivalent(TypeMirror a, TypeMirror b) {
            return $MoreTypes.equal(a, b, $ImmutableSet.of());
        }

        @Override
        protected int doHash(TypeMirror t) {
            return $MoreTypes.hash(t, $ImmutableSet.of());
        }
    }
}

