/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.collect.$BiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableMultimap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.collect.$LinkedListMultimap;
import autovalue.shaded.com.google$.common.collect.$Multimap;
import autovalue.shaded.com.google$.common.collect.$Sets;
import com.google.auto.value.processor.AutoValueOrOneOfProcessor;
import com.google.auto.value.processor.AutoValueProcessor;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.EclipseHack;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.Optionalish;
import com.google.auto.value.processor.PropertyBuilderClassifier;
import com.google.auto.value.processor.PropertyNames;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import com.google.auto.value.processor.TypeVariables;
import java.util.AbstractCollection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class BuilderMethodClassifier {
    private static final $Equivalence<TypeMirror> TYPE_EQUIVALENCE = $MoreTypes.equivalence();
    private final ErrorReporter errorReporter;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeElement autoValueClass;
    private final TypeElement builderType;
    private final $ImmutableBiMap<ExecutableElement, String> getterToPropertyName;
    private final $ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType;
    private final $ImmutableMap<String, ExecutableElement> getterNameToGetter;
    private final Set<ExecutableElement> buildMethods = new LinkedHashSet<ExecutableElement>();
    private final Map<String, BuilderSpec.PropertyGetter> builderGetters = new LinkedHashMap<String, BuilderSpec.PropertyGetter>();
    private final Map<String, PropertyBuilderClassifier.PropertyBuilder> propertyNameToPropertyBuilder = new LinkedHashMap<String, PropertyBuilderClassifier.PropertyBuilder>();
    private final $Multimap<String, BuilderSpec.PropertySetter> propertyNameToPrefixedSetters = $LinkedListMultimap.create();
    private final $Multimap<String, BuilderSpec.PropertySetter> propertyNameToUnprefixedSetters = $LinkedListMultimap.create();
    private final EclipseHack eclipseHack;
    private boolean settersPrefixed;

    private BuilderMethodClassifier(ErrorReporter errorReporter, ProcessingEnvironment processingEnv, TypeElement autoValueClass, TypeElement builderType, $ImmutableBiMap<ExecutableElement, String> getterToPropertyName, $ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType) {
        this.errorReporter = errorReporter;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.autoValueClass = autoValueClass;
        this.builderType = builderType;
        this.getterToPropertyName = getterToPropertyName;
        this.getterToPropertyType = getterToPropertyType;
        $ImmutableMap.Builder<String, ExecutableElement> getterToPropertyNameBuilder = $ImmutableMap.builder();
        for (ExecutableElement getter : getterToPropertyName.keySet()) {
            getterToPropertyNameBuilder.put(getter.getSimpleName().toString(), getter);
        }
        this.getterNameToGetter = getterToPropertyNameBuilder.build();
        this.eclipseHack = new EclipseHack(processingEnv);
    }

    static Optional<BuilderMethodClassifier> classify(Iterable<ExecutableElement> methods, ErrorReporter errorReporter, ProcessingEnvironment processingEnv, TypeElement autoValueClass, TypeElement builderType, $ImmutableBiMap<ExecutableElement, String> getterToPropertyName, $ImmutableMap<ExecutableElement, TypeMirror> getterToPropertyType, boolean autoValueHasToBuilder) {
        BuilderMethodClassifier classifier = new BuilderMethodClassifier(errorReporter, processingEnv, autoValueClass, builderType, getterToPropertyName, getterToPropertyType);
        if (classifier.classifyMethods(methods, autoValueHasToBuilder)) {
            return Optional.of(classifier);
        }
        return Optional.empty();
    }

    $ImmutableMultimap<String, BuilderSpec.PropertySetter> propertyNameToSetters() {
        return $ImmutableMultimap.copyOf(this.settersPrefixed ? this.propertyNameToPrefixedSetters : this.propertyNameToUnprefixedSetters);
    }

    Map<String, PropertyBuilderClassifier.PropertyBuilder> propertyNameToPropertyBuilder() {
        return this.propertyNameToPropertyBuilder;
    }

    $ImmutableMap<String, BuilderSpec.PropertyGetter> builderGetters() {
        return $ImmutableMap.copyOf(this.builderGetters);
    }

    Set<ExecutableElement> buildMethods() {
        return $ImmutableSet.copyOf(this.buildMethods);
    }

    private boolean classifyMethods(Iterable<ExecutableElement> methods, boolean autoValueHasToBuilder) {
        $Multimap<String, BuilderSpec.PropertySetter> propertyNameToSetter;
        int startErrorCount = this.errorReporter.errorCount();
        for (ExecutableElement method : methods) {
            this.classifyMethod(method);
        }
        if (this.errorReporter.errorCount() > startErrorCount) {
            return false;
        }
        if (this.propertyNameToPrefixedSetters.isEmpty()) {
            propertyNameToSetter = this.propertyNameToUnprefixedSetters;
            this.settersPrefixed = false;
        } else if (this.propertyNameToUnprefixedSetters.isEmpty()) {
            propertyNameToSetter = this.propertyNameToPrefixedSetters;
            this.settersPrefixed = true;
        } else {
            this.errorReporter.reportError(this.propertyNameToUnprefixedSetters.values().iterator().next().getSetter(), "If any setter methods use the setFoo convention then all must", new Object[0]);
            return false;
        }
        this.getterToPropertyName.forEach((getter, property) -> {
            boolean hasBuilder;
            TypeMirror propertyType = this.getterToPropertyType.get(getter);
            boolean hasSetter = propertyNameToSetter.containsKey(property);
            PropertyBuilderClassifier.PropertyBuilder propertyBuilder = this.propertyNameToPropertyBuilder.get(property);
            boolean bl = hasBuilder = propertyBuilder != null;
            if (hasBuilder) {
                boolean needToMakeBarBuilder;
                boolean canMakeBarBuilder = propertyBuilder.getBuiltToBuilder() != null || propertyBuilder.getCopyAll() != null;
                boolean bl2 = needToMakeBarBuilder = autoValueHasToBuilder || hasSetter;
                if (needToMakeBarBuilder && !canMakeBarBuilder) {
                    this.errorReporter.reportError(propertyBuilder.getPropertyBuilderMethod(), "Property builder method returns %1$s but there is no way to make that type from %2$s: %2$s does not have a non-static toBuilder() method that returns %1$s, and %1$s does not have a method addAll or putAll that accepts an argument of type %2$s", propertyBuilder.getBuilderTypeMirror(), propertyType);
                }
            } else if (!hasSetter) {
                String setterName = this.settersPrefixed ? BuilderMethodClassifier.prefixWithSet(property) : property;
                this.errorReporter.reportError(this.builderType, "Expected a method with this signature: %s%s %s(%s), or a %sBuilder() method", this.builderType, this.typeParamsString(), setterName, propertyType, property);
            }
        });
        return this.errorReporter.errorCount() == startErrorCount;
    }

    private void classifyMethod(ExecutableElement method) {
        switch (method.getParameters().size()) {
            case 0: {
                this.classifyMethodNoArgs(method);
                break;
            }
            case 1: {
                this.classifyMethodOneArg(method);
                break;
            }
            default: {
                this.errorReporter.reportError(method, "Builder methods must have 0 or 1 parameters", new Object[0]);
            }
        }
    }

    private void classifyMethodNoArgs(ExecutableElement method) {
        String property;
        String methodName = method.getSimpleName().toString();
        TypeMirror returnType = this.builderMethodReturnType(method);
        ExecutableElement getter = this.getterNameToGetter.get(methodName);
        if (getter != null) {
            this.classifyGetter(method, getter);
            return;
        }
        if (methodName.endsWith("Builder") && this.getterToPropertyName.containsValue(property = methodName.substring(0, methodName.length() - "Builder".length()))) {
            PropertyBuilderClassifier propertyBuilderClassifier = new PropertyBuilderClassifier(this.errorReporter, this.typeUtils, this.elementUtils, this, this.getterToPropertyName, this.getterToPropertyType, this.eclipseHack);
            Optional<PropertyBuilderClassifier.PropertyBuilder> propertyBuilder = propertyBuilderClassifier.makePropertyBuilder(method, property);
            if (propertyBuilder.isPresent()) {
                this.propertyNameToPropertyBuilder.put(property, propertyBuilder.get());
            }
            return;
        }
        if (TYPE_EQUIVALENCE.equivalent(returnType, this.autoValueClass.asType())) {
            this.buildMethods.add(method);
        } else {
            this.errorReporter.reportError(method, "Method without arguments should be a build method returning %1$s%2$s, or a getter method with the same name and type as a getter method of %1$s, or fooBuilder() where foo() or getFoo() is a getter method of %1$s", this.autoValueClass, this.typeParamsString());
        }
    }

    private void classifyGetter(ExecutableElement builderGetter, ExecutableElement originalGetter) {
        String propertyName = (String)this.getterToPropertyName.get(originalGetter);
        TypeMirror originalGetterType = this.getterToPropertyType.get(originalGetter);
        TypeMirror builderGetterType = this.builderMethodReturnType(builderGetter);
        String builderGetterTypeString = TypeEncoder.encodeWithAnnotations(builderGetterType);
        if (TYPE_EQUIVALENCE.equivalent(builderGetterType, originalGetterType)) {
            this.builderGetters.put(propertyName, new BuilderSpec.PropertyGetter(builderGetter, builderGetterTypeString, null));
            return;
        }
        Optionalish optional = Optionalish.createIfOptional(builderGetterType);
        if (optional != null) {
            TypeMirror boxedOriginalType;
            TypeMirror containedType = optional.getContainedType(this.typeUtils);
            TypeMirror typeMirror = boxedOriginalType = originalGetterType.getKind().isPrimitive() ? this.typeUtils.boxedClass($MoreTypes.asPrimitiveType(originalGetterType)).asType() : null;
            if (TYPE_EQUIVALENCE.equivalent(containedType, originalGetterType) || TYPE_EQUIVALENCE.equivalent(containedType, boxedOriginalType)) {
                this.builderGetters.put(propertyName, new BuilderSpec.PropertyGetter(builderGetter, builderGetterTypeString, optional));
                return;
            }
        }
        this.errorReporter.reportError(builderGetter, "Method matches a property of %1$s but has return type %2$s instead of %3$s or an Optional wrapping of %3$s", this.autoValueClass, builderGetterType, originalGetterType);
    }

    private void classifyMethodOneArg(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        $BiMap propertyNameToGetter = this.getterToPropertyName.inverse();
        String propertyName = null;
        ExecutableElement valueGetter = (ExecutableElement)propertyNameToGetter.get(methodName);
        $Multimap<String, BuilderSpec.PropertySetter> propertyNameToSetters = null;
        if (valueGetter != null) {
            propertyNameToSetters = this.propertyNameToUnprefixedSetters;
            propertyName = methodName;
        } else if (valueGetter == null && methodName.startsWith("set") && methodName.length() > 3) {
            propertyNameToSetters = this.propertyNameToPrefixedSetters;
            propertyName = PropertyNames.decapitalizeLikeJavaBeans(methodName.substring(3));
            valueGetter = (ExecutableElement)propertyNameToGetter.get(propertyName);
            if (valueGetter == null) {
                propertyName = PropertyNames.decapitalizeNormally(methodName.substring(3));
                valueGetter = (ExecutableElement)propertyNameToGetter.get(propertyName);
            }
        }
        if (valueGetter == null || propertyNameToSetters == null) {
            this.errorReporter.reportError(method, "Method does not correspond to a property of %s", this.autoValueClass);
            this.checkForFailedJavaBean(method);
            return;
        }
        Optional<BuilderSpec.Copier> function = this.getSetterFunction(valueGetter, method);
        if (function.isPresent()) {
            DeclaredType builderTypeMirror = $MoreTypes.asDeclared(this.builderType.asType());
            ExecutableType methodMirror = $MoreTypes.asExecutable(this.typeUtils.asMemberOf(builderTypeMirror, method));
            if (TYPE_EQUIVALENCE.equivalent(methodMirror.getReturnType(), this.builderType.asType())) {
                TypeMirror parameterType = $Iterables.getOnlyElement(methodMirror.getParameterTypes());
                propertyNameToSetters.put(propertyName, new BuilderSpec.PropertySetter(method, parameterType, function.get()));
            } else {
                this.errorReporter.reportError(method, "Setter methods must return %s%s", this.builderType, this.typeParamsString());
            }
        }
    }

    private void checkForFailedJavaBean(ExecutableElement rejectedSetter) {
        Set allGetters = this.getterToPropertyName.keySet();
        $ImmutableSet<ExecutableElement> prefixedGetters = AutoValueProcessor.prefixedGettersIn(allGetters);
        if (prefixedGetters.size() < ((AbstractCollection)((Object)allGetters)).size() && prefixedGetters.size() >= ((AbstractCollection)((Object)allGetters)).size() / 2) {
            this.errorReporter.reportNote(rejectedSetter, "This might be because you are using the getFoo() convention for some but not all methods. These methods don't follow the convention: %s", $Sets.difference(allGetters, prefixedGetters));
        }
    }

    private Optional<BuilderSpec.Copier> getSetterFunction(ExecutableElement valueGetter, ExecutableElement setter) {
        VariableElement parameterElement = $Iterables.getOnlyElement(setter.getParameters());
        boolean nullableParameter = AutoValueOrOneOfProcessor.nullableAnnotationFor(parameterElement, parameterElement.asType()).isPresent();
        TypeMirror targetType = this.getterToPropertyType.get(valueGetter);
        ExecutableType finalSetter = $MoreTypes.asExecutable(this.typeUtils.asMemberOf($MoreTypes.asDeclared(this.builderType.asType()), setter));
        TypeMirror parameterType = finalSetter.getParameterTypes().get(0);
        if (this.typeUtils.isAssignable(parameterType, targetType) && this.typeUtils.isAssignable(targetType, parameterType)) {
            boolean nullableProperty;
            if (nullableParameter && !(nullableProperty = AutoValueOrOneOfProcessor.nullableAnnotationFor(valueGetter, valueGetter.getReturnType()).isPresent())) {
                this.errorReporter.reportError(setter, "Parameter of setter method is @Nullable but property method %s.%s() is not", this.autoValueClass, valueGetter.getSimpleName());
                return Optional.empty();
            }
            return Optional.of(BuilderSpec.Copier.IDENTITY);
        }
        $ImmutableList<ExecutableElement> copyOfMethods = this.copyOfMethods(targetType, nullableParameter);
        if (!copyOfMethods.isEmpty()) {
            return this.getConvertingSetterFunction(copyOfMethods, valueGetter, setter, parameterType);
        }
        this.errorReporter.reportError(setter, "Parameter type %s of setter method should be %s to match getter %s.%s", parameterType, targetType, this.autoValueClass, valueGetter.getSimpleName());
        return Optional.empty();
    }

    private Optional<BuilderSpec.Copier> getConvertingSetterFunction($ImmutableList<ExecutableElement> copyOfMethods, ExecutableElement valueGetter, ExecutableElement setter, TypeMirror parameterType) {
        DeclaredType targetType = $MoreTypes.asDeclared(this.getterToPropertyType.get(valueGetter));
        for (ExecutableElement copyOfMethod : copyOfMethods) {
            Optional<BuilderSpec.Copier> function = this.getConvertingSetterFunction(copyOfMethod, targetType, parameterType);
            if (!function.isPresent()) continue;
            return function;
        }
        String targetTypeSimpleName = targetType.asElement().getSimpleName().toString();
        this.errorReporter.reportError(setter, "Parameter type %s of setter method should be %s to match getter %s.%s, or it should be a type that can be passed to %s.%s to produce %s", parameterType, targetType, this.autoValueClass, valueGetter.getSimpleName(), targetTypeSimpleName, ((ExecutableElement)copyOfMethods.get(0)).getSimpleName(), targetType);
        return Optional.empty();
    }

    private Optional<BuilderSpec.Copier> getConvertingSetterFunction(ExecutableElement copyOfMethod, DeclaredType targetType, TypeMirror parameterType) {
        if (TypeVariables.canAssignStaticMethodResult(copyOfMethod, parameterType, targetType, this.typeUtils)) {
            String method = TypeEncoder.encodeRaw(targetType) + "." + copyOfMethod.getSimpleName();
            Function<String, String> callMethod = s2 -> method + "(" + s2 + ")";
            BuilderSpec.Copier copier = method.contains("Nullable") ? BuilderSpec.Copier.acceptingNull(callMethod) : BuilderSpec.Copier.notAcceptingNull(callMethod);
            return Optional.of(copier);
        }
        return Optional.empty();
    }

    private $ImmutableList<ExecutableElement> copyOfMethods(TypeMirror targetType, boolean nullableParameter) {
        if (!targetType.getKind().equals((Object)TypeKind.DECLARED)) {
            return $ImmutableList.of();
        }
        Optionalish optionalish = Optionalish.createIfOptional(targetType);
        $ImmutableSet<String> copyOfNames = optionalish == null ? $ImmutableSet.of("copyOfSorted", "copyOf") : $ImmutableSet.of(nullableParameter ? optionalish.ofNullable() : "of");
        TypeElement targetTypeElement = $MoreElements.asType(this.typeUtils.asElement(targetType));
        $ImmutableList.Builder copyOfMethods = $ImmutableList.builder();
        for (String copyOfName : copyOfNames) {
            for (ExecutableElement method : ElementFilter.methodsIn(targetTypeElement.getEnclosedElements())) {
                if (!method.getSimpleName().contentEquals(copyOfName) || method.getParameters().size() != 1 || !method.getModifiers().contains((Object)Modifier.STATIC)) continue;
                copyOfMethods.add(method);
            }
        }
        return copyOfMethods.build();
    }

    TypeMirror builderMethodReturnType(ExecutableElement builderMethod) {
        TypeMirror methodMirror;
        DeclaredType builderTypeMirror = $MoreTypes.asDeclared(this.builderType.asType());
        try {
            methodMirror = this.typeUtils.asMemberOf(builderTypeMirror, builderMethod);
        }
        catch (IllegalArgumentException e) {
            return builderMethod.getReturnType();
        }
        return $MoreTypes.asExecutable(methodMirror).getReturnType();
    }

    private static String prefixWithSet(String propertyName) {
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String typeParamsString() {
        return TypeSimplifier.actualTypeParametersString(this.autoValueClass);
    }
}

