/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import com.google.common.collect.ImmutableList;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

final class MorePosixFilePermissions {
    private static final ImmutableList<PosixFilePermission> POSIX_PERMISSIONS = ImmutableList.of(PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ);
    private static final int MAX_MODE = (1 << POSIX_PERMISSIONS.size()) - 1;

    private MorePosixFilePermissions() {
        throw new AssertionError();
    }

    public static long toFileMode(Set<PosixFilePermission> permissions) {
        int filemode = 0;
        int i = 0;
        while (i < POSIX_PERMISSIONS.size()) {
            if (permissions.contains(POSIX_PERMISSIONS.get(i))) {
                filemode |= 1 << i;
            }
            ++i;
        }
        return filemode;
    }

    public static Set<PosixFilePermission> fromFileMode(long filemode) {
        if ((filemode & (long)MAX_MODE) != filemode) {
            throw new IllegalStateException("Invalid file mode '" + Integer.toOctalString((int)filemode) + "'. File mode must be between 0 and " + MAX_MODE + " (" + Integer.toOctalString(MAX_MODE) + " in octal)");
        }
        EnumSet<PosixFilePermission> ret = EnumSet.noneOf(PosixFilePermission.class);
        int i = 0;
        while (i < POSIX_PERMISSIONS.size()) {
            if ((filemode & (long)(1 << i)) != 0L) {
                ret.add((PosixFilePermission)((Object)POSIX_PERMISSIONS.get(i)));
            }
            ++i;
        }
        return ret;
    }
}

