/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Random;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.UnaryOperator;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MultiReaderList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.ParallelListIterable;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.PartitionMutableCollection;
import org.eclipse.collections.api.partition.list.PartitionList;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import org.eclipse.collections.impl.factory.Iterables;
import org.eclipse.collections.impl.lazy.ReverseIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ListIterableParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.list.MultiReaderParallelListIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.SynchronizedMutableList;
import org.eclipse.collections.impl.list.mutable.UnmodifiableMutableList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

public final class MultiReaderFastList<T>
extends AbstractMultiReaderMutableCollection<T>
implements RandomAccess,
Externalizable,
MultiReaderList<T> {
    private static final long serialVersionUID = 1L;
    private MutableList<T> delegate;

    @Deprecated
    public MultiReaderFastList() {
    }

    private MultiReaderFastList(MutableList<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderFastList(MutableList<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(newLock);
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderFastList<T> newList() {
        return new MultiReaderFastList(FastList.newList());
    }

    public static <T> MultiReaderFastList<T> newList(int capacity) {
        return new MultiReaderFastList(Lists.mutable.withInitialCapacity(capacity));
    }

    public static <T> MultiReaderFastList<T> newList(Iterable<? extends T> iterable) {
        return new MultiReaderFastList<T>(FastList.newList(iterable));
    }

    public static <T> MultiReaderFastList<T> newListWith(T ... elements) {
        return new MultiReaderFastList<T>(FastList.newListWith(elements));
    }

    @Override
    protected MutableList<T> getDelegate() {
        return this.delegate;
    }

    UntouchableMutableList<T> asReadUntouchable() {
        return new UntouchableMutableList((MutableList)this.delegate.asUnmodifiable());
    }

    UntouchableMutableList<T> asWriteUntouchable() {
        return new UntouchableMutableList(this.delegate);
    }

    @Override
    public void withReadLockAndDelegate(Procedure<? super MutableList<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UntouchableMutableList<T> list = this.asReadUntouchable();
            procedure.value(list);
            list.becomeUseless();
        }
    }

    @Override
    public void withWriteLockAndDelegate(Procedure<? super MutableList<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            UntouchableMutableList<T> list = this.asWriteUntouchable();
            procedure.value(list);
            list.becomeUseless();
        }
    }

    @Override
    public MutableList<T> asSynchronized() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            SynchronizedMutableList synchronizedMutableList = SynchronizedMutableList.of(this);
            return synchronizedMutableList;
        }
    }

    @Override
    public MutableList<T> asUnmodifiable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnmodifiableMutableList unmodifiableMutableList = UnmodifiableMutableList.of(this);
            return unmodifiableMutableList;
        }
    }

    @Override
    public ImmutableList<T> toImmutable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableList<T> immutableList = Lists.immutable.withAll(this.delegate);
            return immutableList;
        }
    }

    @Override
    public MultiReaderList<T> clone() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MultiReaderFastList<T> multiReaderFastList = new MultiReaderFastList<T>(this.delegate.clone());
            return multiReaderFastList;
        }
    }

    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCollection mutableCollection = this.delegate.collect((Function)function);
            return mutableCollection;
        }
    }

    @Override
    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBooleanCollection mutableBooleanCollection = this.delegate.collectBoolean((BooleanFunction)booleanFunction);
            return mutableBooleanCollection;
        }
    }

    @Override
    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableByteCollection mutableByteCollection = this.delegate.collectByte((ByteFunction)byteFunction);
            return mutableByteCollection;
        }
    }

    @Override
    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCharCollection mutableCharCollection = this.delegate.collectChar((CharFunction)charFunction);
            return mutableCharCollection;
        }
    }

    @Override
    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableDoubleCollection mutableDoubleCollection = this.delegate.collectDouble((DoubleFunction)doubleFunction);
            return mutableDoubleCollection;
        }
    }

    @Override
    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableFloatCollection mutableFloatCollection = this.delegate.collectFloat((FloatFunction)floatFunction);
            return mutableFloatCollection;
        }
    }

    @Override
    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableIntCollection mutableIntCollection = this.delegate.collectInt((IntFunction)intFunction);
            return mutableIntCollection;
        }
    }

    @Override
    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableLongCollection mutableLongCollection = this.delegate.collectLong((LongFunction)longFunction);
            return mutableLongCollection;
        }
    }

    @Override
    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableShortCollection mutableShortCollection = this.delegate.collectShort((ShortFunction)shortFunction);
            return mutableShortCollection;
        }
    }

    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCollection mutableCollection = this.delegate.flatCollect(function);
            return mutableCollection;
        }
    }

    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCollection mutableCollection = this.delegate.collectIf((Predicate)predicate, (Function)function);
            return mutableCollection;
        }
    }

    @Override
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCollection mutableCollection = this.delegate.collectWith(function, (Object)parameter);
            return mutableCollection;
        }
    }

    @Override
    public MultiReaderList<T> newEmpty() {
        return MultiReaderFastList.newList();
    }

    @Override
    public MultiReaderList<T> tap(Procedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.forEach(procedure);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionMutableCollection partitionMutableCollection = this.delegate.partition((Predicate)predicate);
            return partitionMutableCollection;
        }
    }

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionMutableCollection partitionMutableCollection = this.delegate.partitionWith(predicate, (Object)parameter);
            return partitionMutableCollection;
        }
    }

    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCollection mutableCollection = this.delegate.selectInstancesOf((Class)clazz);
            return mutableCollection;
        }
    }

    @Override
    public MutableList<T> distinct() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.distinct();
            return listIterable;
        }
    }

    @Override
    public MutableList<T> distinct(HashingStrategy<? super T> hashingStrategy) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.distinct(hashingStrategy);
            return listIterable;
        }
    }

    @Override
    public <V> MutableList<T> distinctBy(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.distinctBy((Function)function);
            return listIterable;
        }
    }

    @Override
    public MultiReaderList<T> sortThis() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThis();
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThis(Comparator<? super T> comparator) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThis(comparator);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public <V extends Comparable<? super V>> MultiReaderList<T> sortThisBy(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisBy(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByInt(IntFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByInt(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByBoolean(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByChar(CharFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByChar(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByByte(ByteFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByByte(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByShort(ShortFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByShort(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByFloat(FloatFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByFloat(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByLong(LongFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByLong(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> sortThisByDouble(DoubleFunction<? super T> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sortThisByDouble(function);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> subList(int fromIndex, int toIndex) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MultiReaderFastList<T> multiReaderFastList = new MultiReaderFastList<T>(this.delegate.subList(fromIndex, toIndex), this.lock);
            return multiReaderFastList;
        }
    }

    @Override
    public boolean equals(Object o) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.equals(o);
            return bl;
        }
    }

    @Override
    public int hashCode() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.hashCode();
            return n;
        }
    }

    @Override
    public T get(int index) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object e = this.delegate.get(index);
            return (T)e;
        }
    }

    @Override
    public Optional<T> getFirstOptional() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.delegate.getFirstOptional();
            return optional;
        }
    }

    @Override
    public Optional<T> getLastOptional() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.delegate.getLastOptional();
            return optional;
        }
    }

    @Override
    public int indexOf(Object o) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.indexOf(o);
            return n;
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.lastIndexOf(o);
            return n;
        }
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("ListIterator is not supported for MultiReaderFastList.  If you would like to use a ListIterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.replaceAll(operator);
        }
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.sort(comparator);
        }
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("ListIterator is not supported for MultiReaderFastList.  If you would like to use a ListIterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    @Override
    public T remove(int index) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            Object e = this.delegate.remove(index);
            return (T)e;
        }
    }

    @Override
    public T set(int index, T element) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            T t = this.delegate.set(index, element);
            return t;
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.delegate.addAll(index, collection);
            return bl;
        }
    }

    @Override
    public void add(int index, T element) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.add(index, element);
        }
    }

    @Override
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.corresponds(other, predicate);
            return bl;
        }
    }

    @Override
    public void forEach(int startIndex, int endIndex, Procedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.delegate.forEach(startIndex, endIndex, procedure);
        }
    }

    @Override
    public <T2> void forEachInBoth(ListIterable<T2> other, Procedure2<? super T, ? super T2> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.delegate.forEachInBoth(other, procedure);
        }
    }

    @Override
    public int binarySearch(T key, Comparator<? super T> comparator) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = Collections.binarySearch(this, key, comparator);
            return n;
        }
    }

    @Override
    public int binarySearch(T key) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = Collections.binarySearch(this, key);
            return n;
        }
    }

    @Override
    public void reverseForEach(Procedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.delegate.reverseForEach(procedure);
        }
    }

    @Override
    public void reverseForEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.delegate.reverseForEachWithIndex(procedure);
        }
    }

    @Override
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.delegate.forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableList)in.readObject();
        this.lock = new ReentrantReadWriteLock();
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(this.lock);
    }

    @Override
    public int detectIndex(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.detectIndex(predicate);
            return n;
        }
    }

    @Override
    public int detectLastIndex(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.detectLastIndex(predicate);
            return n;
        }
    }

    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMultimap mutableMultimap = this.delegate.groupBy((Function)function);
            return mutableMultimap;
        }
    }

    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMultimap mutableMultimap = this.delegate.groupByEach(function);
            return mutableMultimap;
        }
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MapIterable mapIterable = this.delegate.groupByUniqueKey((Function)function);
            return mapIterable;
        }
    }

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCollection mutableCollection = this.delegate.zip((Iterable)that);
            return mutableCollection;
        }
    }

    @Override
    public MutableList<Pair<T, Integer>> zipWithIndex() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCollection mutableCollection = this.delegate.zipWithIndex();
            return mutableCollection;
        }
    }

    @Override
    public MutableList<T> toReversed() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.toReversed();
            return listIterable;
        }
    }

    @Override
    public MultiReaderList<T> reverseThis() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.reverseThis();
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> shuffleThis() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.shuffleThis();
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MultiReaderList<T> shuffleThis(Random rnd) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.delegate.shuffleThis(rnd);
            MultiReaderFastList multiReaderFastList = this;
            return multiReaderFastList;
        }
    }

    @Override
    public MutableStack<T> toStack() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableStack mutableStack = this.delegate.toStack();
            return mutableStack;
        }
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            RichIterable richIterable = this.delegate.chunk(size);
            return richIterable;
        }
    }

    @Override
    public MutableList<T> take(int count) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.take(count);
            return listIterable;
        }
    }

    @Override
    public MutableList<T> takeWhile(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.takeWhile((Predicate)predicate);
            return listIterable;
        }
    }

    @Override
    public MutableList<T> drop(int count) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.drop(count);
            return listIterable;
        }
    }

    @Override
    public MutableList<T> dropWhile(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.dropWhile((Predicate)predicate);
            return listIterable;
        }
    }

    @Override
    public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionList partitionList = this.delegate.partitionWhile((Predicate)predicate);
            return partitionList;
        }
    }

    @Override
    public LazyIterable<T> asReversed() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ReverseIterable reverseIterable = ReverseIterable.adapt(this);
            return reverseIterable;
        }
    }

    @Override
    public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MultiReaderParallelListIterable multiReaderParallelListIterable = new MultiReaderParallelListIterable(this.delegate.asParallel(executorService, batchSize), this.lock);
            return multiReaderParallelListIterable;
        }
    }

    private static final class UntouchableListIterator<T>
    implements ListIterator<T> {
        private Iterator<T> delegate;

        private UntouchableListIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public void add(T o) {
            ((ListIterator)this.delegate).add(o);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return ((ListIterator)this.delegate).hasPrevious();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public int nextIndex() {
            return ((ListIterator)this.delegate).nextIndex();
        }

        @Override
        public T previous() {
            return (T)((ListIterator)this.delegate).previous();
        }

        @Override
        public int previousIndex() {
            return ((ListIterator)this.delegate).previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void set(T o) {
            ((ListIterator)this.delegate).set(o);
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    static final class UntouchableMutableList<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableList<T> {
        private final MutableList<UntouchableListIterator<T>> requestedIterators = Iterables.mList();
        private final MutableList<UntouchableMutableList<T>> requestedSubLists = Iterables.mList();

        private UntouchableMutableList(MutableList<T> delegate) {
            super(delegate);
        }

        @Override
        protected MutableList<T> getDelegate() {
            return (MutableList)this.delegate;
        }

        @Override
        public MutableList<T> with(T element) {
            this.add(element);
            return this;
        }

        @Override
        public MutableList<T> without(T element) {
            this.remove(element);
            return this;
        }

        @Override
        public MutableList<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        @Override
        public MutableList<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        @Override
        public MutableList<T> asSynchronized() {
            throw new UnsupportedOperationException("Cannot call asSynchronized() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableList<T> asUnmodifiable() {
            throw new UnsupportedOperationException("Cannot call asUnmodifiable() on " + this.getClass().getSimpleName());
        }

        @Override
        public ImmutableList<T> toImmutable() {
            return this.getDelegate().toImmutable();
        }

        @Override
        public MutableList<T> clone() {
            return this.getDelegate().clone();
        }

        @Override
        public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect((Function)function);
        }

        @Override
        public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean((BooleanFunction)booleanFunction);
        }

        @Override
        public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte((ByteFunction)byteFunction);
        }

        @Override
        public MutableCharList collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar((CharFunction)charFunction);
        }

        @Override
        public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble((DoubleFunction)doubleFunction);
        }

        @Override
        public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat((FloatFunction)floatFunction);
        }

        @Override
        public MutableIntList collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt((IntFunction)intFunction);
        }

        @Override
        public MutableLongList collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong((LongFunction)longFunction);
        }

        @Override
        public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort((ShortFunction)shortFunction);
        }

        @Override
        public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect((Function)function);
        }

        @Override
        public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf((Predicate)predicate, (Function)function);
        }

        @Override
        public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith((Function2)function, (Object)parameter);
        }

        @Override
        public int detectIndex(Predicate<? super T> predicate) {
            return this.getDelegate().detectIndex(predicate);
        }

        @Override
        public int detectLastIndex(Predicate<? super T> predicate) {
            return this.getDelegate().detectLastIndex(predicate);
        }

        @Override
        public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy((Function)function);
        }

        @Override
        public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach((Function)function);
        }

        @Override
        public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
            return this.getDelegate().corresponds(other, predicate);
        }

        @Override
        public void forEach(int fromIndex, int toIndex, Procedure<? super T> procedure) {
            this.getDelegate().forEach(fromIndex, toIndex, procedure);
        }

        @Override
        public void reverseForEach(Procedure<? super T> procedure) {
            this.getDelegate().reverseForEach(procedure);
        }

        @Override
        public void reverseForEachWithIndex(ObjectIntProcedure<? super T> procedure) {
            this.getDelegate().reverseForEachWithIndex(procedure);
        }

        @Override
        public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
            this.getDelegate().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }

        @Override
        public MutableList<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        @Override
        public MutableList<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject((Predicate)predicate);
        }

        @Override
        public MutableList<T> distinct() {
            return this.getDelegate().distinct();
        }

        @Override
        public MutableList<T> distinct(HashingStrategy<? super T> hashingStrategy) {
            return this.getDelegate().distinct(hashingStrategy);
        }

        @Override
        public <V> MutableList<T> distinctBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().distinctBy(function);
        }

        @Override
        public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith((Predicate2)predicate, (Object)parameter);
        }

        @Override
        public MutableList<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        @Override
        public MutableList<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select((Predicate)predicate);
        }

        @Override
        public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith((Predicate2)predicate, (Object)parameter);
        }

        @Override
        public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition((Predicate)predicate);
        }

        @Override
        public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith((Predicate2)predicate, (Object)parameter);
        }

        @Override
        public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf((Class)clazz);
        }

        @Override
        public void sort(Comparator<? super T> comparator) {
            this.getDelegate().sort(comparator);
        }

        @Override
        public MutableList<T> sortThis() {
            this.getDelegate().sortThis();
            return this;
        }

        @Override
        public MutableList<T> sortThis(Comparator<? super T> comparator) {
            this.getDelegate().sortThis(comparator);
            return this;
        }

        @Override
        public MutableList<T> toReversed() {
            return this.getDelegate().toReversed();
        }

        @Override
        public MutableList<T> reverseThis() {
            this.getDelegate().reverseThis();
            return this;
        }

        @Override
        public MutableList<T> shuffleThis() {
            this.getDelegate().shuffleThis();
            return this;
        }

        @Override
        public MutableList<T> shuffleThis(Random rnd) {
            this.getDelegate().shuffleThis(rnd);
            return this;
        }

        @Override
        public MutableStack<T> toStack() {
            return ArrayStack.newStack(this.delegate);
        }

        @Override
        public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
            this.getDelegate().sortThisBy(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByInt(IntFunction<? super T> function) {
            this.getDelegate().sortThisByInt(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
            this.getDelegate().sortThisByBoolean(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByChar(CharFunction<? super T> function) {
            this.getDelegate().sortThisByChar(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByByte(ByteFunction<? super T> function) {
            this.getDelegate().sortThisByByte(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByShort(ShortFunction<? super T> function) {
            this.getDelegate().sortThisByShort(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByFloat(FloatFunction<? super T> function) {
            this.getDelegate().sortThisByFloat(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByLong(LongFunction<? super T> function) {
            this.getDelegate().sortThisByLong(function);
            return this;
        }

        @Override
        public MutableList<T> sortThisByDouble(DoubleFunction<? super T> function) {
            this.getDelegate().sortThisByDouble(function);
            return this;
        }

        @Override
        public MutableList<T> take(int count) {
            return this.getDelegate().take(count);
        }

        @Override
        public MutableList<T> takeWhile(Predicate<? super T> predicate) {
            return this.getDelegate().takeWhile(predicate);
        }

        @Override
        public MutableList<T> drop(int count) {
            return this.getDelegate().drop(count);
        }

        @Override
        public MutableList<T> dropWhile(Predicate<? super T> predicate) {
            return this.getDelegate().dropWhile(predicate);
        }

        @Override
        public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
            return this.getDelegate().partitionWhile(predicate);
        }

        @Override
        public MutableList<T> subList(int fromIndex, int toIndex) {
            UntouchableMutableList<T> subList = new UntouchableMutableList<T>(this.getDelegate().subList(fromIndex, toIndex));
            this.requestedSubLists.add(subList);
            return subList;
        }

        @Override
        public Iterator<T> iterator() {
            UntouchableListIterator iterator = new UntouchableListIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator);
            return iterator;
        }

        @Override
        public void add(int index, T element) {
            this.getDelegate().add(index, element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> collection) {
            return this.getDelegate().addAll(index, collection);
        }

        @Override
        public T get(int index) {
            return (T)this.getDelegate().get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.getDelegate().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.getDelegate().lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            UntouchableListIterator iterator = new UntouchableListIterator(this.getDelegate().listIterator());
            this.requestedIterators.add(iterator);
            return iterator;
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            UntouchableListIterator iterator = new UntouchableListIterator(this.getDelegate().listIterator(index));
            this.requestedIterators.add(iterator);
            return iterator;
        }

        @Override
        public T remove(int index) {
            return (T)this.getDelegate().remove(index);
        }

        @Override
        public T set(int index, T element) {
            return this.getDelegate().set(index, element);
        }

        @Override
        public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip((Iterable)that);
        }

        @Override
        public MutableList<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        @Override
        public LazyIterable<T> asReversed() {
            return ReverseIterable.adapt(this);
        }

        @Override
        public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
            return new ListIterableParallelIterable(this, executorService, batchSize);
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedSubLists.each(UntouchableMutableList::becomeUseless);
            this.requestedIterators.each(UntouchableListIterator::becomeUseless);
        }
    }
}

