/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bimap.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bimap.ImmutableBiMap;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.bimap.AbstractBiMap;
import org.eclipse.collections.impl.bimap.mutable.HashBiMap;
import org.eclipse.collections.impl.bimap.mutable.SynchronizedBiMap;
import org.eclipse.collections.impl.bimap.mutable.UnmodifiableBiMap;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.factory.BiMaps;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.partition.set.PartitionUnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.MapIterate;

abstract class AbstractMutableBiMap<K, V>
extends AbstractBiMap<K, V>
implements MutableBiMap<K, V> {
    private UnifiedMap<K, V> delegate;
    private AbstractMutableBiMap<V, K> inverse;

    AbstractMutableBiMap(Map<K, V> map) {
        this.delegate = UnifiedMap.newMap();
        this.inverse = new Inverse<V, K>(UnifiedMap.newMap(), this);
        this.putAll(map);
    }

    AbstractMutableBiMap(Map<K, V> delegate, Map<V, K> inverse) {
        this.checkNull(delegate, inverse);
        this.checkSame(delegate, inverse);
        this.delegate = UnifiedMap.newMap(delegate);
        this.inverse = new Inverse<K, V>(inverse, this);
    }

    private AbstractMutableBiMap(Map<K, V> delegate, AbstractMutableBiMap<V, K> valuesToKeys) {
        this.delegate = UnifiedMap.newMap(delegate);
        this.inverse = valuesToKeys;
    }

    private void checkNull(Map<K, V> delegate, Map<V, K> inverse) {
        if (delegate == null || inverse == null) {
            throw new IllegalArgumentException("The delegate maps cannot be null.");
        }
    }

    private void checkSame(Map<K, V> keysToValues, Map<V, K> valuesToKeys) {
        if (keysToValues == valuesToKeys) {
            throw new IllegalArgumentException("The delegate maps cannot be same.");
        }
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    @Override
    protected UnifiedMap<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    protected UnifiedMap<V, K> getInverse() {
        return this.inverse.delegate;
    }

    @Override
    public HashBiMap<K, V> newEmpty() {
        return new HashBiMap();
    }

    @Override
    public MutableBiMap<K, V> withKeyValue(K key, V value) {
        this.put(key, value);
        return this;
    }

    @Override
    public MutableBiMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        for (Pair<K, V> keyVal : keyValues) {
            this.put(keyVal.getOne(), keyVal.getTwo());
        }
        return this;
    }

    @Override
    public MutableBiMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        return this.withAllKeyValues(ArrayAdapter.adapt(keyValuePairs));
    }

    @Override
    public MutableBiMap<K, V> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public MutableBiMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableBiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public MutableSetMultimap<V, K> flip() {
        return MapIterate.flip(this);
    }

    @Override
    public MutableBiMap<V, K> flipUniqueValues() {
        return new HashBiMap(this.inverse());
    }

    @Override
    public V put(K key, V value) {
        if (this.inverse.delegate.containsKey(value)) {
            if (AbstractMutableBiMap.nullSafeEquals(key, this.inverse.delegate.get(value))) {
                return value;
            }
            throw new IllegalArgumentException("Value " + value + " already exists in map!");
        }
        boolean containsKey = this.delegate.containsKey(key);
        if (containsKey) {
            V oldValue = this.delegate.put(key, value);
            V oldKeyToPreserve = this.inverse.delegate.removeKey(oldValue);
            this.inverse.delegate.put(value, oldKeyToPreserve);
            return oldValue;
        }
        V put = this.delegate.put(key, value);
        this.inverse.delegate.put(value, key);
        return put;
    }

    @Override
    public V forcePut(K key, V value) {
        boolean containsValue = this.inverse.delegate.containsKey(value);
        if (containsValue && AbstractMutableBiMap.nullSafeEquals(key, this.inverse.delegate.get(value))) {
            return value;
        }
        boolean containsKey = this.delegate.containsKey(key);
        if (containsValue) {
            V oldValueToPreserve = this.delegate.get(this.inverse.delegate.get(value));
            V put = this.delegate.put(key, oldValueToPreserve);
            if (containsKey) {
                V oldKeyToPreserve = this.inverse.delegate.removeKey(put);
                V oldKey = this.inverse.delegate.put(value, oldKeyToPreserve);
                this.delegate.removeKey(oldKey);
                return put;
            }
            V oldKey = this.inverse.delegate.put(value, key);
            this.delegate.removeKey(oldKey);
            return put;
        }
        V put = this.delegate.put(key, value);
        if (containsKey) {
            this.inverse.delegate.removeKey(put);
        }
        this.inverse.delegate.put(value, key);
        return put;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Set<Map.Entry<K, V>> entries = map.entrySet();
        for (Map.Entry<K, V> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V add(Pair<K, V> keyValuePair) {
        return this.put(keyValuePair.getOne(), keyValuePair.getTwo());
    }

    @Override
    public V remove(Object key) {
        if (!this.delegate.containsKey(key)) {
            return null;
        }
        V oldValue = this.delegate.remove(key);
        this.inverse.delegate.remove(oldValue);
        return oldValue;
    }

    @Override
    public V removeKey(K key) {
        return this.remove(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    @Override
    public V getIfAbsentPut(K key, V value) {
        V oldValue = this.delegate.get(key);
        if (oldValue != null || this.delegate.containsKey(key)) {
            return oldValue;
        }
        this.put(key, value);
        return value;
    }

    @Override
    public V getIfAbsentPut(K key, Function0<? extends V> function) {
        V value = this.delegate.get(key);
        if (value != null || this.delegate.containsKey(key)) {
            return value;
        }
        V newValue = function.value();
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        V value = this.delegate.get(key);
        if (value != null || this.delegate.containsKey(key)) {
            return value;
        }
        V newValue = function.valueOf(parameter);
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public V getIfAbsentPutWithKey(K key, Function<? super K, ? extends V> function) {
        V value = this.delegate.get(key);
        if (value != null || this.delegate.containsKey(key)) {
            return value;
        }
        V newValue = function.valueOf(key);
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        if (this.delegate.containsKey(key)) {
            V newValue = function.valueOf(this.delegate.get(key));
            this.put(key, newValue);
            return newValue;
        }
        V newValue = function.valueOf(factory.value());
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        if (this.delegate.containsKey(key)) {
            V newValue = function.value(this.delegate.get(key), parameter);
            this.put(key, newValue);
            return newValue;
        }
        V newValue = function.value(factory.value(), parameter);
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValuesCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Iterator<V> iterator() {
        return new InternalIterator();
    }

    @Override
    public ImmutableBiMap<K, V> toImmutable() {
        return BiMaps.immutable.withAll(this.delegate);
    }

    @Override
    public MutableBiMap<K, V> asSynchronized() {
        return SynchronizedBiMap.of(this);
    }

    @Override
    public MutableBiMap<K, V> asUnmodifiable() {
        return UnmodifiableBiMap.of(this);
    }

    @Override
    public MutableBiMap<K, V> clone() {
        return new HashBiMap(this);
    }

    @Override
    public MutableBiMap<K, V> tap(Procedure<? super V> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public HashBiMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        HashBiMap result = HashBiMap.newMap();
        this.delegate.forEachKeyValue((key, value) -> {
            if (predicate.accept((Object)key, (Object)value)) {
                result.put(key, value);
            }
        });
        return result;
    }

    @Override
    public HashBiMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        HashBiMap result = HashBiMap.newMap();
        this.delegate.forEachKeyValue((key, value) -> {
            if (!predicate.accept((Object)key, (Object)value)) {
                result.put(key, value);
            }
        });
        return result;
    }

    @Override
    public <K2, V2> HashBiMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        HashBiMap result = HashBiMap.newMap();
        this.delegate.forEachKeyValue((key, value) -> {
            Pair pair = (Pair)function.value((Object)key, (Object)value);
            result.put(pair.getOne(), pair.getTwo());
        });
        return result;
    }

    @Override
    public <R> HashBiMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        HashBiMap result = HashBiMap.newMap();
        this.delegate.forEachKeyValue((key, value) -> result.put(key, function.value((Object)key, (Object)value)));
        return result;
    }

    @Override
    public <VV> MutableBag<VV> collect(Function<? super V, ? extends VV> function) {
        return this.delegate.collect((Function)function);
    }

    @Override
    public <P, VV> MutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.delegate.collectWith(function, (Object)parameter);
    }

    @Override
    public <VV> MutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.flatCollect(function);
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.delegate.collectBoolean((BooleanFunction)booleanFunction);
    }

    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        return this.delegate.collectByte((ByteFunction)byteFunction);
    }

    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        return this.delegate.collectChar((CharFunction)charFunction);
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.delegate.collectDouble((DoubleFunction)doubleFunction);
    }

    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        return this.delegate.collectFloat((FloatFunction)floatFunction);
    }

    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        return this.delegate.collectInt((IntFunction)intFunction);
    }

    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        return this.delegate.collectLong((LongFunction)longFunction);
    }

    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        return this.delegate.collectShort((ShortFunction)shortFunction);
    }

    @Override
    public <VV> MutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.delegate.collectIf((Predicate)predicate, (Function)function);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.delegate.zipWithIndex(new UnifiedSet());
    }

    @Override
    public <VV> MutableSetMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.delegate.groupBy(function, new UnifiedSetMultimap());
    }

    @Override
    public <VV> MutableSetMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.groupByEach(function, new UnifiedSetMultimap());
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<V, S>> zip(Iterable<S> that) {
        return this.delegate.zip(that, new UnifiedSet());
    }

    @Override
    public MutableSet<V> select(Predicate<? super V> predicate) {
        return this.delegate.select(predicate, new UnifiedSet());
    }

    @Override
    public <P> MutableSet<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.selectWith(predicate, parameter, new UnifiedSet());
    }

    @Override
    public MutableSet<V> reject(Predicate<? super V> predicate) {
        return this.delegate.reject(predicate, new UnifiedSet());
    }

    @Override
    public <P> MutableSet<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.rejectWith(predicate, parameter, new UnifiedSet());
    }

    @Override
    public PartitionMutableSet<V> partition(Predicate<? super V> predicate) {
        PartitionUnifiedSet result = new PartitionUnifiedSet();
        this.inverse.forEachKey(new PartitionProcedure<V>(predicate, result));
        return result;
    }

    @Override
    public <P> PartitionMutableSet<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.partition((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        this.inverse.delegate.forEachKey(procedure);
    }

    @Override
    public <VV> MutableBiMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return new HashBiMap(this.delegate.groupByUniqueKey((Function)function));
    }

    @Override
    public <K2, V2> MutableMap<K2, V2> aggregateBy(Function<? super V, ? extends K2> groupBy, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V, ? extends V2> nonMutatingAggregator) {
        return this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    @Override
    public <K2, V2> MutableMap<K2, V2> aggregateInPlaceBy(Function<? super V, ? extends K2> groupBy, Function0<? extends V2> zeroValueFactory, Procedure2<? super V2, ? super V> mutatingAggregator) {
        return this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        return this.delegate.sumByInt((Function)groupBy, (IntFunction)function);
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        return this.delegate.sumByFloat((Function)groupBy, (FloatFunction)function);
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        return this.delegate.sumByLong((Function)groupBy, (LongFunction)function);
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        return this.delegate.sumByDouble((Function)groupBy, (DoubleFunction)function);
    }

    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        UnifiedSet result = new UnifiedSet();
        this.inverse.forEachKey(new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.delegate.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = UnifiedMap.newMap();
        this.delegate.readExternal(in);
        UnifiedMap inverseDelegate = UnifiedMap.newMap();
        this.delegate.forEachKeyValue((key, value) -> inverseDelegate.put(value, key));
        this.inverse = new Inverse<V, K>(inverseDelegate, this);
    }

    private class EntrySet
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return AbstractMutableBiMap.this.hashCode();
        }

        @Override
        public int size() {
            return AbstractMutableBiMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AbstractMutableBiMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object actualValue = AbstractMutableBiMap.this.get(key);
            if (actualValue != null) {
                return actualValue.equals(entry.getValue());
            }
            return entry.getValue() == null && AbstractMutableBiMap.this.containsKey(key);
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[AbstractMutableBiMap.this.size()];
            return this.copyEntries(result);
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = AbstractMutableBiMap.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyEntries(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object e) {
            if (!(e instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)e;
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object actualValue = AbstractMutableBiMap.this.delegate.get(key);
            if (actualValue != null) {
                if (actualValue.equals(value)) {
                    AbstractMutableBiMap.this.remove(key);
                    return true;
                }
                return false;
            }
            if (value == null && AbstractMutableBiMap.this.delegate.containsKey(key)) {
                AbstractMutableBiMap.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = AbstractMutableBiMap.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != AbstractMutableBiMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            AbstractMutableBiMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new InternalEntrySetIterator();
        }

        private Object[] copyEntries(Object[] result) {
            int count = 0;
            for (Pair pair : AbstractMutableBiMap.this.keyValuesView()) {
                result[count] = new InternalEntry(pair.getOne(), pair.getTwo());
                ++count;
            }
            return result;
        }

        private final class InternalEntry
        implements Map.Entry<K, V> {
            private final K key;
            private V value;

            private InternalEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry other = (Map.Entry)obj;
                    Object otherKey = other.getKey();
                    Object otherValue = other.getValue();
                    return AbstractMutableBiMap.nullSafeEquals(this.key, otherKey) && AbstractMutableBiMap.nullSafeEquals(this.value, otherValue);
                }
                return false;
            }

            @Override
            public int hashCode() {
                return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
            }

            public String toString() {
                return this.key + "=" + this.value;
            }

            @Override
            public V setValue(V value) {
                Object result = AbstractMutableBiMap.this.put(this.key, value);
                this.value = value;
                return result;
            }
        }

        private class InternalEntrySetIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, V>> iterator;
            private V currentValue;

            private InternalEntrySetIterator() {
                this.iterator = AbstractMutableBiMap.this.delegate.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry next = this.iterator.next();
                InternalEntry result = new InternalEntry(next.getKey(), next.getValue());
                this.currentValue = result.getValue();
                return result;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractMutableBiMap.this.inverse.delegate.removeKey(this.currentValue);
            }
        }
    }

    private class InternalIterator
    implements Iterator<V> {
        private final Iterator<V> iterator;
        private V currentValue;

        private InternalIterator() {
            this.iterator = AbstractMutableBiMap.this.delegate.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            Object next = this.iterator.next();
            this.currentValue = next;
            return next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            AbstractMutableBiMap.this.inverse.delegate.remove(this.currentValue);
        }
    }

    private static class Inverse<K, V>
    extends AbstractMutableBiMap<K, V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;

        public Inverse() {
            super(UnifiedMap.newMap(), UnifiedMap.newMap());
        }

        Inverse(Map<K, V> delegate, AbstractMutableBiMap<V, K> inverse) {
            super(delegate, inverse);
        }
    }

    private class KeySet
    implements Set<K>,
    Serializable {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            return AbstractMutableBiMap.this.delegate.keySet().equals(obj);
        }

        @Override
        public int hashCode() {
            return AbstractMutableBiMap.this.delegate.keySet().hashCode();
        }

        @Override
        public int size() {
            return AbstractMutableBiMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AbstractMutableBiMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object key) {
            return AbstractMutableBiMap.this.delegate.containsKey(key);
        }

        @Override
        public Object[] toArray() {
            return AbstractMutableBiMap.this.delegate.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return AbstractMutableBiMap.this.delegate.keySet().toArray(a);
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = AbstractMutableBiMap.this.size();
            AbstractMutableBiMap.this.remove(key);
            return AbstractMutableBiMap.this.size() != oldSize;
        }

        @Override
        public boolean containsAll(Collection<?> source) {
            for (Object key : source) {
                if (AbstractMutableBiMap.this.delegate.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = AbstractMutableBiMap.this.size();
            for (Object next : this) {
                if (collection.contains(next)) continue;
                this.remove(next);
            }
            return oldSize != AbstractMutableBiMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = AbstractMutableBiMap.this.size();
            for (Object object : collection) {
                AbstractMutableBiMap.this.remove(object);
            }
            return oldSize != AbstractMutableBiMap.this.size();
        }

        @Override
        public void clear() {
            AbstractMutableBiMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return AbstractMutableBiMap.this.inverse().iterator();
        }

        public String toString() {
            return Iterate.makeString(this, "[", ", ", "]");
        }

        protected Object writeReplace() {
            UnifiedSet replace = UnifiedSet.newSet(AbstractMutableBiMap.this.size());
            AbstractMutableBiMap.this.forEachKey(CollectionAddProcedure.on(replace));
            return replace;
        }
    }

    private class ValuesCollection
    implements Collection<V> {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return AbstractMutableBiMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AbstractMutableBiMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object key) {
            return AbstractMutableBiMap.this.inverse.delegate.containsKey(key);
        }

        @Override
        public Object[] toArray() {
            return AbstractMutableBiMap.this.delegate.values().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return AbstractMutableBiMap.this.delegate.values().toArray(a);
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object value) {
            int oldSize = AbstractMutableBiMap.this.size();
            AbstractMutableBiMap.this.inverse().remove(value);
            return oldSize != AbstractMutableBiMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object key : collection) {
                if (AbstractMutableBiMap.this.inverse.delegate.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = AbstractMutableBiMap.this.size();
            for (Object object : collection) {
                this.remove(object);
            }
            return oldSize != AbstractMutableBiMap.this.size();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = AbstractMutableBiMap.this.size();
            for (Object next : this) {
                if (collection.contains(next)) continue;
                this.remove(next);
            }
            return oldSize != AbstractMutableBiMap.this.size();
        }

        @Override
        public void clear() {
            AbstractMutableBiMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return AbstractMutableBiMap.this.iterator();
        }

        public String toString() {
            return Iterate.makeString(this, "[", ", ", "]");
        }
    }
}

