/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.pub;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.pub.PubService;
import org.eclipse.dartboard.util.DartPreferences;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PubspecChangeListener
implements IResourceChangeListener {
    private static final ILog LOG = Platform.getLog(PubspecChangeListener.class);
    private ScopedPreferenceStore preferences = DartPreferences.getPreferenceStore();
    private PubService pub;

    public PubspecChangeListener(PubService pubService) {
        this.pub = pubService;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean syncPub = this.preferences.getBoolean("auto_pub_sync");
        if (!syncPub) {
            return;
        }
        if (event.getType() == 1) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 1 && "pubspec.yaml".equals(resource.getName()) && (delta.getKind() == 1 || PubspecChangeListener.this.isContentChanged(delta))) {
                            boolean offline = PubspecChangeListener.this.preferences.getBoolean("offline_pub");
                            PubspecChangeListener.this.pub.get(resource.getProject(), offline);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                LOG.log(StatusUtil.createError(e.getMessage(), e));
            }
        }
    }

    private boolean isContentChanged(IResourceDelta delta) {
        return delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0;
    }
}

