/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.triggers;

import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseTrigger;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.triggers.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SybaseImages;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TriggersViewerLabelProvider
implements ITableLabelProvider {
    private DatabaseIdentifier _databaseIdentifier;

    public TriggersViewerLabelProvider(DatabaseIdentifier identifier) {
        this._databaseIdentifier = identifier;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return SybaseImages.get("org.eclipse.datatools.enablement.sybasetrigger.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof SybaseASABaseTrigger)) {
            return "";
        }
        SybaseASABaseTrigger trigger = (SybaseASABaseTrigger)element;
        switch (columnIndex) {
            case 0: {
                return trigger.getName();
            }
            case 1: {
                if (trigger.getSybaseASABaseActionTime().getValue() == 3) {
                    return "";
                }
                return trigger.getActionGranularity().getName();
            }
            case 2: {
                if (trigger.getSybaseASABaseActionTime().getValue() == 3) {
                    return "";
                }
                return trigger.getSybaseASABaseActionTime().getName();
            }
            case 3: {
                StringBuffer sb = new StringBuffer("");
                if (trigger.isInsertType() && !trigger.isUpdateColumnType()) {
                    sb.append(Messages.TriggersViewerLabelProvider_insert).append(",");
                }
                if (trigger.isUpdateType() && !trigger.isUpdateColumnType()) {
                    sb.append(Messages.TriggersViewerLabelProvider_update).append(",");
                }
                if (trigger.isDeleteType() && !trigger.isUpdateColumnType()) {
                    sb.append(Messages.TriggersViewerLabelProvider_delete).append(",");
                }
                if (trigger.isUpdateColumnType()) {
                    sb.append(Messages.TriggersViewerLabelProvider_updateof);
                    for (Column col : trigger.getTriggerColumn()) {
                        sb.append(col.getName()).append(",");
                    }
                }
                if (sb.toString().length() > 0) {
                    return sb.toString().substring(0, sb.toString().length() - 1);
                }
                return "";
            }
            case 4: {
                if (trigger.getSybaseASABaseActionTime().getValue() == 3) {
                    return "";
                }
                return Integer.toString(trigger.getOrder());
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

