/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.ui.impl;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class ContainerCheckedGraphViewer
extends CheckboxTreeViewer {
    ContainerCheckedGraphViewer(Composite parent, int style) {
        super(parent, style);
        this.initViewer();
    }

    private void initViewer() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ContainerCheckedGraphViewer.this.doCheckStateChanged(event.getElement());
            }
        });
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Widget item = ContainerCheckedGraphViewer.this.findItem(event.getElement());
                if (item instanceof TreeItem) {
                    ContainerCheckedGraphViewer.this.initializeItem((TreeItem)item, true);
                }
            }
        });
    }

    private void doCheckStateChanged(Object element) {
        Widget item = this.findItem(element);
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            if (!treeItem.getChecked()) {
                treeItem.setGrayed(false);
                this.updateChildrenItems(treeItem, false);
            } else if (treeItem.getItemCount() != 0) {
                treeItem.setGrayed(true);
            }
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    private void initializeItem(TreeItem item, boolean isExpanding) {
        if (!item.getGrayed()) {
            this.updateChildrenItems(item, isExpanding);
        }
    }

    private void updateChildrenItems(TreeItem parent, boolean isExpanding) {
        Item[] children = this.getChildren((Widget)parent);
        if (!(children != null && children.length != 0 || isExpanding)) {
            return;
        }
        boolean state = parent.getChecked();
        int i = 0;
        while (i < children.length) {
            TreeItem current = (TreeItem)children[i];
            if (current.getData() != null && (current.getChecked() != state || current.getGrayed())) {
                current.setChecked(state);
                current.setGrayed(false);
                this.updateChildrenItems(current, false);
            }
            ++i;
        }
    }

    private void updateParentItems(TreeItem item) {
        if (item == null) {
            return;
        }
        Item[] children = this.getChildren((Widget)item);
        boolean containsChecked = false;
        boolean containsUnchecked = false;
        int i = 0;
        while (i < children.length) {
            TreeItem curr = (TreeItem)children[i];
            containsChecked |= curr.getChecked();
            containsUnchecked |= !curr.getChecked() || curr.getGrayed();
            ++i;
        }
        item.setChecked(containsChecked);
        item.setGrayed(containsChecked && containsUnchecked);
        this.updateParentItems(item.getParentItem());
    }

    public boolean setChecked(Object element, boolean state) {
        if (super.setChecked(element, state)) {
            this.doCheckStateChanged(element);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        int i = 0;
        while (i < elements.length) {
            this.doCheckStateChanged(elements[i]);
            ++i;
        }
    }

    protected void setExpanded(Item item, boolean expand) {
        super.setExpanded(item, expand);
        if (expand && item instanceof TreeItem) {
            this.initializeItem((TreeItem)item, expand);
        }
    }
}

