/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileDriver;
import org.eclipse.datatools.connectivity.oda.flatfile.InvalidResourceException;
import org.eclipse.datatools.connectivity.oda.flatfile.ResourceLocator;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.util.Utility;
import org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil.ColumnsInfoUtil;
import org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil.QueryTextUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelectionWizardPage
extends DataSetWizardPage
implements ISelectionChangedListener {
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFile");
    private static final String ALL_CSV_EXTENSION = "*.csv";
    private static final String CSV_EXTENSION = ".csv";
    private static final String ALL_SSV_EXTENSION = "*.ssv";
    private static final String SSV_EXTENSION = ".ssv";
    private static final String ALL_TSV_EXTENSION = "*.tsv";
    private static final String TSV_EXTENSION = ".tsv";
    private static final String ALL_PSV_EXTENSION = "*.psv";
    private static final String PSV_EXTENSION = ".psv";
    private static final String ALL_TXT_EXTENSION = "*.txt";
    private static final String TXT_EXTENSION = ".txt";
    private static final String MATCH_ALL_FILES = "*.*";
    private static final String queryTextDelimiter = ":";
    private static final String columnsInfoStartSymbol = "{";
    private static final String columnsInfoEndSymbol = "}";
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};
    private HashMap<Integer, String> dataTypeDisplayNameMap = new HashMap();
    private HashMap<String, String> dataTypeValueMape = new HashMap();
    private final int DEFAULT_WIDTH = 200;
    private final int DEFAULT_HEIGHT = 200;
    private transient ComboViewer fileViewer = null;
    private transient ComboViewer fileFilter = null;
    private transient org.eclipse.swt.widgets.List availableList = null;
    private transient TableViewer selectedColumnsViewer = null;
    private transient Button btnAdd = null;
    private transient Button btnRemove = null;
    private transient Button btnMoveUp = null;
    private transient Button btnMoveDown = null;
    private boolean initialized = true;
    private String odaHome;
    private String fileURI;
    private String charSet = null;
    private String inclColumnNameLine;
    private String flatfileDelimiterType;
    private String inclTypeLine;
    private String savedSelectedColumnsInfoString;
    private String trailNullCols;
    private String selectedFileFilter;
    private Object selectedFile;
    private String nameOfFileWithErrorInLastAccess = null;
    private List<String[]> originalFileColumnsInfoList = new ArrayList<String[]>();
    private List<String[]> savedSelectedColumnsInfoList = new ArrayList<String[]>();

    public FileSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.createColumnTypeMap();
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public FileSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Dialog_SelectTableColumn_ID");
    }

    private void createColumnTypeMap() {
        this.dataTypeDisplayNameMap.put(new Integer(4), Messages.getString("datatypes.integer"));
        this.dataTypeDisplayNameMap.put(new Integer(8), Messages.getString("datatypes.float"));
        this.dataTypeDisplayNameMap.put(new Integer(12), Messages.getString("datatypes.string"));
        this.dataTypeDisplayNameMap.put(new Integer(91), Messages.getString("datatypes.date"));
        this.dataTypeDisplayNameMap.put(new Integer(92), Messages.getString("datatypes.time"));
        this.dataTypeDisplayNameMap.put(new Integer(93), Messages.getString("datatypes.dateTime"));
        this.dataTypeDisplayNameMap.put(new Integer(2), Messages.getString("datatypes.decimal"));
        this.dataTypeDisplayNameMap.put(new Integer(16), Messages.getString("datatypes.boolean"));
        this.dataTypeValueMape.put(Messages.getString("datatypes.integer"), "INT");
        this.dataTypeValueMape.put(Messages.getString("datatypes.float"), "DOUBLE");
        this.dataTypeValueMape.put(Messages.getString("datatypes.string"), "STRING");
        this.dataTypeValueMape.put(Messages.getString("datatypes.date"), "DATE");
        this.dataTypeValueMape.put(Messages.getString("datatypes.time"), "TIME");
        this.dataTypeValueMape.put(Messages.getString("datatypes.dateTime"), "TIMESTAMP");
        this.dataTypeValueMape.put(Messages.getString("datatypes.decimal"), "BIGDECIMAL");
        this.dataTypeValueMape.put(Messages.getString("datatypes.boolean"), "BOOLEAN");
    }

    private void initializeControl() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null) {
            return;
        }
        this.updateValuesFromQuery(queryText);
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.fileViewer == null) {
            return design;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("label.selectFile"));
        label.setLayoutData((Object)data);
        this.createTopComposite(composite, label);
        this.createLeftComposite(composite);
        Composite btnComposite = this.createAddBtnComposite(composite);
        this.createRightComposite(composite, btnComposite);
        this.loadProperties();
        this.populateFileFilter();
        this.updateFileListAndCharSet();
        return composite;
    }

    private void createTopComposite(Composite composite, Label label) {
        final Shell shell = composite.getShell();
        FormData data = new FormData();
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(80, -5);
        this.fileViewer = new ComboViewer(composite, 2056);
        this.fileViewer.getControl().setLayoutData((Object)data);
        this.fileViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fileViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    return ((File)element).getName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return element.toString();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(this.fileViewer.getControl(), 5);
        data.top = new FormAttachment(0, 5);
        label = new Label(composite, 0);
        label.setText(Messages.getString("label.fileFilter"));
        label.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(100, -5);
        this.fileFilter = new ComboViewer(composite, 8);
        this.fileFilter.getControl().setLayoutData((Object)data);
        this.fileFilter.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FileSelectionWizardPage.this.fileURI != null && FileSelectionWizardPage.this.fileURI.length() > 0) {
                    return;
                }
                String currSelectFilter = FileSelectionWizardPage.this.fileFilter.getCombo().getText();
                if (currSelectFilter.equalsIgnoreCase(FileSelectionWizardPage.this.selectedFileFilter)) {
                    return;
                }
                if (!FileSelectionWizardPage.this.initialized) {
                    FileSelectionWizardPage.this.selectedFileFilter = currSelectFilter;
                    FileSelectionWizardPage.this.updateFileListAndCharSet();
                    FileSelectionWizardPage.this.initialized = true;
                } else if (currSelectFilter.equals(FileSelectionWizardPage.MATCH_ALL_FILES) || MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("confirm.reselectFileFilterTitle"), (String)Messages.getString("confirm.reselectFileFilterMessage"))) {
                    FileSelectionWizardPage.this.selectedFileFilter = currSelectFilter;
                    FileSelectionWizardPage.this.updateFileListAndCharSet();
                } else {
                    FileSelectionWizardPage.this.fileFilter.getCombo().setText(FileSelectionWizardPage.this.selectedFileFilter);
                }
            }
        });
    }

    private void createLeftComposite(Composite composite) {
        FormData data = new FormData();
        data.top = new FormAttachment(this.fileViewer.getControl(), 10, 1024);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(40, -5);
        data.bottom = new FormAttachment(100, -5);
        data.width = 200;
        data.height = 200;
        this.availableList = new org.eclipse.swt.widgets.List(composite, 2818);
        this.availableList.setLayoutData((Object)data);
        this.availableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.selectedColumnsViewer.getTable().deselectAll();
                FileSelectionWizardPage.this.updateButtons();
            }
        });
        this.availableList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileSelectionWizardPage.this.addColumns();
                FileSelectionWizardPage.this.validateSelectedColumns();
            }
        });
    }

    private Composite createAddBtnComposite(Composite composite) {
        FormData data = new FormData();
        data.top = new FormAttachment(50, 5);
        data.left = new FormAttachment((Control)this.availableList, 3);
        Composite btnComposite = new Composite(composite, 0);
        btnComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        btnComposite.setLayout((Layout)layout);
        this.btnAdd = new Button(btnComposite, 0);
        GridData gridData = new GridData(772);
        gridData.heightHint = 25;
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnAdd.setToolTipText(Messages.getString("tooltip.button.add"));
        if (this.btnAdd.getStyle() == (this.btnAdd.getStyle() | 0x2000000)) {
            this.btnAdd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        } else {
            this.btnAdd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        }
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.addColumns();
                FileSelectionWizardPage.this.validateSelectedColumns();
            }
        });
        return btnComposite;
    }

    private void createRightComposite(Composite composite, Composite btnComposite) {
        FormData data = new FormData();
        data.top = new FormAttachment(this.fileViewer.getControl(), 10, 1024);
        data.left = new FormAttachment((Control)btnComposite, 3);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -5);
        Composite rightComposite = new Composite(composite, 2048);
        rightComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rightComposite.setLayout((Layout)layout);
        this.selectedColumnsViewer = new TableViewer(rightComposite, 68354);
        this.selectedColumnsViewer.getTable().setHeaderVisible(true);
        this.selectedColumnsViewer.getTable().setLinesVisible(true);
        this.selectedColumnsViewer.getTable().setLayoutData((Object)new GridData(1808));
        TableColumn column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.originalName"));
        column.setWidth(100);
        column = new TableColumn(this.selectedColumnsViewer.getTable(), 0);
        column.setText(Messages.getString("editor.title.type"));
        column.setWidth(100);
        Menu menu = new Menu((Control)this.selectedColumnsViewer.getTable());
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                FileSelectionWizardPage.this.selectedColumnsViewer.cancelEditing();
            }
        });
        final MenuItem menuRemove = new MenuItem(menu, 0);
        menuRemove.setText(Messages.getString("FileSelectionWizardPage.MenuItem.remove"));
        menuRemove.setEnabled(this.selectedColumnsViewer.getTable().getSelectionCount() > 0);
        menuRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.removeColumns();
                FileSelectionWizardPage.this.updateButtons();
                FileSelectionWizardPage.this.validateSelectedColumns();
            }
        });
        MenuItem menuRemoveAll = new MenuItem(menu, 0);
        menuRemoveAll.setText(Messages.getString("FileSelectionWizardPage.MenuItem.removeAll"));
        menuRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.removeAllColumns();
                FileSelectionWizardPage.this.updateButtons();
                FileSelectionWizardPage.this.validateSelectedColumns();
            }
        });
        this.selectedColumnsViewer.getTable().setMenu(menu);
        this.selectedColumnsViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                menuRemove.setEnabled(FileSelectionWizardPage.this.selectedColumnsViewer.getTable().getSelectionCount() > 0);
                FileSelectionWizardPage.this.availableList.deselectAll();
                FileSelectionWizardPage.this.updateButtons();
            }
        });
        this.selectedColumnsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FileSelectionWizardPage.this.doEdit();
            }
        });
        this.selectedColumnsViewer.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    FileSelectionWizardPage.this.removeColumns();
                    FileSelectionWizardPage.this.updateButtons();
                    FileSelectionWizardPage.this.validateSelectedColumns();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.setColumnsViewerContent();
        this.setColumnsViewerLabels();
        this.createEditBtnGroup(rightComposite);
    }

    protected void doEdit() {
        if (this.selectedColumnsViewer.getTable().getSelection().length > 0) {
            ColumnEditDialog editDialog = new ColumnEditDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            TableItem item = this.selectedColumnsViewer.getTable().getSelection()[0];
            editDialog.setInput(item.getText(0), item.getText(1), item.getText(2));
            if (editDialog.open() == 0) {
                int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
                this.savedSelectedColumnsInfoList.set(index, new String[]{editDialog.getColumnName(), editDialog.getOriginalName(), editDialog.getDataType()});
                this.selectedColumnsViewer.refresh();
                this.validateSelectedColumns();
            }
        }
    }

    private void createEditBtnGroup(Composite rightComposite) {
        Composite btnComposite = new Composite(rightComposite, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        btnComposite.setLayout((Layout)layout);
        this.btnMoveUp = new Button(btnComposite, 0);
        this.btnMoveUp.setText(Messages.getString("button.moveUp"));
        this.btnMoveUp.setToolTipText(Messages.getString("tooltip.button.up"));
        this.btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.moveUpItem();
            }
        });
        this.btnRemove = new Button(btnComposite, 0);
        this.btnRemove.setText(Messages.getString("button.delete"));
        this.btnRemove.setToolTipText(Messages.getString("tooltip.button.delete"));
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.removeColumns();
            }
        });
        this.btnMoveDown = new Button(btnComposite, 0);
        this.btnMoveDown.setText(Messages.getString("button.moveDown"));
        this.btnMoveDown.setToolTipText(Messages.getString("tooltip.button.down"));
        this.btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.moveDownItem();
            }
        });
        this.resetButtonWidth();
    }

    private void resetButtonWidth() {
        int widthHint = Math.max(this.btnMoveUp.computeSize((int)-1, (int)-1).x, this.btnRemove.computeSize((int)-1, (int)-1).x);
        widthHint = Math.max(widthHint, this.btnMoveDown.computeSize((int)-1, (int)-1).x);
        widthHint = Math.max(widthHint, 52);
        GridData btnGd = new GridData();
        btnGd.widthHint = widthHint;
        this.btnMoveUp.setLayoutData((Object)btnGd);
        this.btnRemove.setLayoutData((Object)btnGd);
        this.btnMoveDown.setLayoutData((Object)btnGd);
    }

    private void setColumnsViewerLabels() {
        this.selectedColumnsViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((String[])element)[columnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void setColumnsViewerContent() {
        this.selectedColumnsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private int getExistenceCount(String columnName) {
        int count = 0;
        ArrayList<String[]> existedColumns = new ArrayList<String[]>();
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            if (columnName.equals(this.savedSelectedColumnsInfoList.get(i)[1])) {
                ++count;
                existedColumns.add(this.savedSelectedColumnsInfoList.get(i));
            }
            ++i;
        }
        int j = 0;
        while (j < existedColumns.size()) {
            if ((String.valueOf(columnName) + "_" + count).equals(((String[])existedColumns.get(j))[0])) {
                ++count;
                j = -1;
            }
            ++j;
        }
        return count;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object file = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (this.fileURI != null && this.fileURI.length() > 0) {
            if (file != null) {
                this.updateAvailableColumnsInfo((String)file);
                this.validateSelectedColumns();
            }
            return;
        }
        if (file.equals(this.selectedFile)) {
            return;
        }
        this.setPageComplete(false);
        this.availableList.removeAll();
        this.nameOfFileWithErrorInLastAccess = null;
        this.updateAvailableColumnsInfo(((File)file).getName());
        if (this.selectedFile != null && this.savedSelectedColumnsInfoList.size() > 0) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("confirm.reselectFileNameTitle"), (String)Messages.getString("confirm.reselectFileNameMessage"))) {
                this.validateSelectedColumns();
            } else {
                this.selectedColumnsViewer.getTable().removeAll();
                this.savedSelectedColumnsInfoList.clear();
            }
        }
        this.selectedFile = file;
    }

    private void updateAvailableColumnsInfo(String fileName) {
        String[] columnNames = this.getFileColumnNames(fileName);
        if (columnNames != null && columnNames.length != 0) {
            this.enableListAndViewer();
            this.availableList.setItems(columnNames);
            this.availableList.select(0);
            this.updateButtons();
            if (!(fileName.endsWith(CSV_EXTENSION) || fileName.endsWith(TXT_EXTENSION) || fileName.endsWith(SSV_EXTENSION) || fileName.endsWith(TSV_EXTENSION) || fileName.endsWith(PSV_EXTENSION))) {
                this.setMessage(Messages.getString("warning.fileExtensionInvalid"), 2);
            } else {
                this.setMessage(DEFAULT_MESSAGE);
            }
        }
    }

    private void updateButtons() {
        if (this.availableList.getSelectionCount() > 0) {
            this.btnAdd.setEnabled(true);
            this.btnRemove.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
        } else if (this.selectedColumnsViewer.getTable().getSelectionCount() > 0) {
            this.btnAdd.setEnabled(false);
            this.btnRemove.setEnabled(true);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
            int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
            if (index > 0) {
                this.btnMoveUp.setEnabled(true);
            }
            if (index < this.selectedColumnsViewer.getTable().getItemCount() - 1) {
                this.btnMoveDown.setEnabled(true);
            }
        } else {
            this.btnAdd.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
        }
    }

    private void updateSelectionFocus() {
        int[] indices = this.availableList.getSelectionIndices();
        if (indices.length > 0) {
            int nextIndex = indices[indices.length - 1] + 1;
            if (this.availableList.getItemCount() > nextIndex) {
                this.availableList.deselectAll();
                this.availableList.select(nextIndex);
            }
        }
    }

    private void validateSelectedColumns() {
        boolean pageComplete = true;
        String[] columnNames = this.availableList.getItems();
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            String columnName = this.savedSelectedColumnsInfoList.get(i)[0];
            String originalName = this.savedSelectedColumnsInfoList.get(i)[1];
            boolean columnExists = false;
            int k = 0;
            while (k < columnNames.length) {
                if (columnName != null && columnName.equals(columnNames[k]) || originalName != null && originalName.equals(columnNames[k])) {
                    columnExists = true;
                    break;
                }
                ++k;
            }
            if (!columnExists) {
                this.setMessage(Messages.getFormattedString("warning.columnNotExist", new Object[]{columnName}), 3);
                pageComplete = false;
                break;
            }
            if (this.isNumeric(columnName)) {
                this.setMessage(Messages.getString("FileSelectionWizardPage.error.selectColumn.numberName"), 3);
                pageComplete = false;
            }
            ++i;
        }
        if (this.savedSelectedColumnsInfoList.size() <= 0) {
            this.setMessage(Messages.getString("FileSelectionWizardPage.error.selectColumn.NoColumnSelected"), 3);
            pageComplete = false;
        }
        if (pageComplete) {
            this.setMessage(DEFAULT_MESSAGE);
            this.setPageComplete(true);
        }
    }

    private boolean isNumeric(String text) {
        long indexTest = this.indexFromString(text);
        return indexTest >= 0L;
    }

    private long indexFromString(String str) {
        int len = str.length();
        if (len > 0) {
            int i = 0;
            boolean negate = false;
            int c = str.charAt(0);
            if (c == 45 && len > 1) {
                c = str.charAt(1);
                i = 1;
                negate = true;
            }
            if ((c -= 48) >= 0 && c <= 9 && len <= (negate ? 11 : 10)) {
                int index = -c;
                int oldIndex = 0;
                ++i;
                if (index != 0) {
                    while (i != len && (c = str.charAt(i) - 48) >= 0 && c <= 9) {
                        oldIndex = index;
                        index = 10 * index - c;
                        ++i;
                    }
                }
                if (i == len && (oldIndex > -214748364 || oldIndex == -214748364 && c <= (negate ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(negate ? index : -index);
                }
            }
        }
        return -1L;
    }

    private void loadProperties() {
        File cpFile;
        DataSourceDesign dataSourceDesign = this.getInitializationDesign().getDataSourceDesign();
        Properties dataSourceProps = null;
        try {
            dataSourceProps = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)dataSourceDesign);
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            return;
        }
        String sourcePath = dataSourceProps.getProperty("OdaConnProfileStorePath");
        if (sourcePath != null && (cpFile = DesignUtil.convertPathToResourceFile((String)sourcePath, (ResourceIdentifiers)dataSourceDesign.getHostResourceIdentifiers())) == null) {
            this.setMessage(Messages.getFormattedString("error.invalidConnectionFilePath", new Object[]{sourcePath}), 3);
            return;
        }
        this.odaHome = dataSourceProps.getProperty("HOME");
        this.fileURI = dataSourceProps.getProperty("URI");
        this.charSet = dataSourceProps.getProperty("CHARSET");
        this.flatfileDelimiterType = dataSourceProps.getProperty("DELIMTYPE");
        this.inclColumnNameLine = dataSourceProps.getProperty("INCLCOLUMNNAME");
        this.inclTypeLine = dataSourceProps.getProperty("INCLTYPELINE");
        this.trailNullCols = dataSourceProps.getProperty("TRAILNULLCOLS");
        this.verifyFileLocation();
    }

    private void verifyFileLocation() {
        if (this.fileURI != null && this.fileURI.length() > 0) {
            try {
                ResourceLocator.validateFileURI((String)this.fileURI, (org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers)this.getResourceIdentifiers());
            }
            catch (InvalidResourceException invalidResourceException) {
                this.setMessage(Messages.getFormattedString("Connection.error.invalidFileURI", new Object[]{this.fileURI}), 3);
                this.fileURI = null;
            }
        } else if (this.odaHome != null && this.odaHome.length() > 0) {
            try {
                ResourceLocator.validateHomeFolder((String)this.odaHome);
            }
            catch (InvalidResourceException invalidResourceException) {
                this.setMessage(Messages.getFormattedString("Connection.error.invalidHomeFolder", new Object[]{this.odaHome}), 3);
                this.odaHome = null;
            }
        } else {
            this.setMessage(Messages.getString("Connection.error.invalidPath"), 3);
            this.fileURI = null;
            this.odaHome = null;
        }
    }

    private void updateFileListAndCharSet() {
        if (this.fileViewer != null && !this.fileViewer.getControl().isDisposed()) {
            if (this.odaHome == null && this.fileURI == null) {
                this.disableAll();
                return;
            }
            ArrayList<Object> allFiles = new ArrayList<Object>();
            if (this.odaHome != null) {
                File folder = new File(this.odaHome);
                if (folder.isDirectory() && folder.exists()) {
                    File[] files = folder.getAbsoluteFile().listFiles(new CSVFileFilter(this.fileFilter.getCombo().getText()));
                    allFiles.addAll(Arrays.asList(files));
                }
            } else if (this.fileURI != null) {
                allFiles.add(this.fileURI);
            }
            this.fileViewer.setInput((Object)allFiles.toArray());
            if (allFiles.size() <= 0) {
                this.setMessage(Messages.getFormattedString("error.noCSVFiles", new Object[]{new File(this.odaHome).getAbsolutePath()}));
                this.disableAll();
            } else {
                this.updateFileSelection();
                this.updateButtons();
            }
        }
    }

    private void updateFileSelection() {
        Object[] files = (Object[])this.fileViewer.getInput();
        if (files.length > 0) {
            this.enableListAndViewer();
            Object toSelectFile = null;
            if (this.selectedFile != null) {
                int i = 0;
                while (i < files.length) {
                    if (files[i].equals(this.selectedFile)) {
                        toSelectFile = this.selectedFile;
                        break;
                    }
                    ++i;
                }
            }
            if (toSelectFile == null) {
                toSelectFile = files[0];
            }
            this.fileViewer.setSelection((ISelection)new StructuredSelection(toSelectFile));
            if (this.nameOfFileWithErrorInLastAccess == null || !this.nameOfFileWithErrorInLastAccess.equals(this.fileViewer.getCombo().getText())) {
                this.setMessage(DEFAULT_MESSAGE);
            }
        } else {
            this.setMessage(Messages.getFormattedString("error.noCSVFiles", new Object[]{new File(this.odaHome).getAbsolutePath()}));
            this.disableAll();
        }
    }

    private String[] getFileColumnNames(String file) {
        String[] result;
        List<String[]> propList = this.getQueryColumnsInfo("select * from " + QueryTextUtil.getQuotedName((String)file));
        if (propList != null) {
            this.originalFileColumnsInfoList = new ArrayList<String[]>(propList);
            result = new String[propList.size()];
            int i = 0;
            while (i < propList.size()) {
                result[i] = propList.get(i)[1];
                ++i;
            }
        } else {
            result = new String[]{};
        }
        return result;
    }

    private List<String[]> getQueryColumnsInfo(String queryText) {
        FlatFileDriver ffDriver = new FlatFileDriver();
        IConnection conn = null;
        ArrayList<String[]> columnList = new ArrayList<String[]>();
        try {
            conn = ffDriver.getConnection(null);
            IResultSetMetaData metadata = this.getResultSetMetaData(queryText, conn);
            int columnCount = metadata.getColumnCount();
            if (columnCount == 0) {
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                return arrayList;
            }
            int i = 0;
            while (i < columnCount) {
                String[] result;
                result = new String[]{metadata.getColumnName(i + 1), this.getOriginalColumnName(result[0], this.savedSelectedColumnsInfoString, metadata), this.getDataTypeDisplayName(new Integer(metadata.getColumnType(i + 1)))};
                columnList.add(result);
                ++i;
            }
            ArrayList<String[]> arrayList = columnList;
            return arrayList;
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.updateExceptionInfo();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            return arrayList;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void updateExceptionInfo() {
        this.nameOfFileWithErrorInLastAccess = this.fileViewer.getCombo().getText();
        if (this.availableList.getItemCount() == 0) {
            this.disableAvailableListAndButtons();
        }
    }

    private void disableAvailableListAndButtons() {
        this.availableList.setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
    }

    private String getDataTypeDisplayName(Integer type) {
        if (this.dataTypeDisplayNameMap.get(type) != null) {
            return this.dataTypeDisplayNameMap.get(type);
        }
        return Messages.getString("datatypes.string");
    }

    private String getDataTypeValue(String displayName) {
        if (this.dataTypeValueMape.get(displayName) != null) {
            return this.dataTypeValueMape.get(displayName);
        }
        return "STRING";
    }

    private String getOriginalColumnName(String name, String columnsInfo, IResultSetMetaData metadata) {
        String originalName = null;
        if (columnsInfo.length() != 0) {
            ColumnsInfoUtil ciu = new ColumnsInfoUtil(columnsInfo);
            String[] names = ciu.getColumnNames();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    originalName = ciu.getOriginalColumnNames()[i];
                    break;
                }
                ++i;
            }
        }
        if (originalName == null) {
            try {
                int j = 0;
                while (j < metadata.getColumnCount()) {
                    if (name.equals(metadata.getColumnName(j + 1))) {
                        originalName = name;
                    }
                    ++j;
                }
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
        return originalName;
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (OdaException odaException) {}
    }

    private IResultSetMetaData getResultSetMetaData(String queryText, IConnection conn) throws OdaException {
        Properties prop = new Properties();
        if (this.odaHome != null) {
            prop.put("HOME", this.odaHome);
        }
        if (this.fileURI != null) {
            prop.put("URI", this.fileURI);
        }
        if (this.flatfileDelimiterType != null) {
            prop.put("DELIMTYPE", this.flatfileDelimiterType);
        }
        if (this.charSet != null) {
            prop.put("CHARSET", this.charSet);
        }
        if (this.inclColumnNameLine != null) {
            prop.put("INCLCOLUMNNAME", this.inclColumnNameLine);
        }
        if (this.inclTypeLine != null) {
            prop.put("INCLTYPELINE", this.inclTypeLine);
        }
        if (this.trailNullCols != null) {
            prop.put("TRAILNULLCOLS", this.trailNullCols);
        }
        this.savedSelectedColumnsInfoString = new QueryTextUtil(queryText).getColumnsInfo();
        Map appContext = DesignSessionUtil.createResourceIdentifiersContext((ResourceIdentifiers)this.getHostResourceIdentifiers());
        conn.setAppContext((Object)appContext);
        conn.open(prop);
        IQuery query = conn.newQuery(null);
        query.setMaxRows(1);
        query.prepare(queryText);
        query.executeQuery();
        return query.getMetaData();
    }

    private org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers getResourceIdentifiers() {
        return DesignSessionUtil.createRuntimeResourceIdentifiers((ResourceIdentifiers)this.getHostResourceIdentifiers());
    }

    private void enableListAndViewer() {
        this.availableList.setEnabled(true);
        this.selectedColumnsViewer.getTable().setEnabled(true);
    }

    private void disableAll() {
        this.availableList.setEnabled(false);
        this.selectedColumnsViewer.getTable().setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        this.setPageComplete(false);
    }

    private void setDisplayContent(List<String[]> list, TableViewer tViewer) {
        tViewer.getTable().removeAll();
        tViewer.setInput(list);
        tViewer.getTable().select(tViewer.getTable().getTopIndex());
    }

    private String getQuery() {
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            return "";
        }
        String tableName = null;
        StringBuffer buf = new StringBuffer();
        Object file = ((StructuredSelection)this.fileViewer.getSelection()).getFirstElement();
        if (file != null) {
            if (file instanceof File) {
                tableName = ((File)file).getName();
            } else if (file instanceof String) {
                tableName = (String)file;
            }
        }
        if (tableName != null) {
            tableName = QueryTextUtil.getQuotedName(tableName);
            if (this.availableList.getItemCount() == 0) {
                buf.append("select * from ").append(tableName);
            } else {
                buf.append("select ");
                String[] columns = new String[this.selectedColumnsViewer.getTable().getItemCount()];
                int m = 0;
                while (m < columns.length) {
                    columns[m] = this.selectedColumnsViewer.getTable().getItem(m).getText(1);
                    ++m;
                }
                int n = 0;
                while (n < columns.length) {
                    StringBuffer sb = new StringBuffer();
                    char[] columnChars = columns[n].toCharArray();
                    int i = 0;
                    while (i < columnChars.length) {
                        if (columnChars[i] == '\"') {
                            sb.append("\\\"");
                        } else if (columnChars[i] == '\\') {
                            sb.append("\\\\");
                        } else {
                            sb.append(columnChars[i]);
                        }
                        ++i;
                    }
                    buf.append(String.valueOf('\"') + sb.toString() + '\"');
                    if (n < columns.length - 1) {
                        buf.append(", ");
                    }
                    ++n;
                }
                buf.append(" from ").append(tableName);
            }
        }
        return buf.toString();
    }

    private void updateValuesFromQuery(String queryText) {
        if (queryText.length() == 0) {
            return;
        }
        try {
            String f;
            String query = new QueryTextUtil(queryText).getQuery();
            String[] metadata = QueryTextUtil.getQueryMetaData((String)query);
            if (metadata != null && metadata[0] != null && metadata[2] != null && (f = this.selectTableFromQuery(metadata[2])) != null) {
                this.updateColumnsFromQuery(queryText, f);
            }
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.updateExceptionInfo();
        }
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
        }
    }

    private void updateColumnsFromQuery(String queryText, String file) {
        this.availableList.setItems(this.getFileColumnNames(file));
        this.selectedColumnsViewer.getTable().removeAll();
        this.savedSelectedColumnsInfoList.clear();
        this.savedSelectedColumnsInfoList = this.getQueryColumnsInfo(queryText);
        this.setDisplayContent(this.savedSelectedColumnsInfoList, this.selectedColumnsViewer);
        this.setPageComplete(true);
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
        }
        this.updateButtons();
    }

    private String selectTableFromQuery(String tableName) {
        String selected = null;
        if (this.fileURI != null && this.fileURI.length() > 0) {
            if (!this.fileURI.equals(tableName)) {
                this.availableList.removeAll();
                this.nameOfFileWithErrorInLastAccess = null;
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("fileURIChanged.warning.reselectColumnsTitle"), (String)Messages.getString("fileURIChanged.warning.reselectColumnsMessage"));
                this.updateAvailableColumnsInfo(this.fileURI);
                this.selectedColumnsViewer.getTable().removeAll();
                this.savedSelectedColumnsInfoList.clear();
                this.fileViewer.setSelection((ISelection)new StructuredSelection((Object)this.fileURI));
                this.setPageComplete(false);
                this.setMessage(Messages.getString("error.selectColumns"), 3);
            } else {
                selected = tableName;
            }
        } else {
            this.resetInitialized();
            this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)MATCH_ALL_FILES));
            Object[] files = (Object[])this.fileViewer.getInput();
            if (files != null) {
                int n = 0;
                while (n < files.length) {
                    File f = (File)files[n];
                    if (f.getName().equalsIgnoreCase(tableName)) {
                        this.selectedFile = f;
                        this.resetInitialized();
                        this.setFileFilter(tableName);
                        this.fileViewer.setSelection((ISelection)new StructuredSelection(files[n]));
                        selected = f.getName();
                        break;
                    }
                    ++n;
                }
            }
        }
        return selected;
    }

    private void setFileFilter(String table) {
        String tableName = table.toLowerCase();
        if (tableName.endsWith(CSV_EXTENSION)) {
            this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_CSV_EXTENSION));
        } else if (tableName.endsWith(TXT_EXTENSION)) {
            this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_TXT_EXTENSION));
        } else if (tableName.endsWith(SSV_EXTENSION)) {
            this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_SSV_EXTENSION));
        } else if (tableName.endsWith(TSV_EXTENSION)) {
            this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_TSV_EXTENSION));
        } else if (tableName.endsWith(PSV_EXTENSION)) {
            this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_PSV_EXTENSION));
        } else {
            this.fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_PSV_EXTENSION));
        }
    }

    private void resetInitialized() {
        this.initialized = false;
    }

    private void populateFileFilter() {
        if (this.fileFilter != null && !this.fileFilter.getControl().isDisposed() && this.fileFilter.getCombo().getSelectionIndex() == -1) {
            if ("COMMA".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_CSV_EXTENSION);
                this.selectedFileFilter = ALL_CSV_EXTENSION;
            } else if ("SEMICOLON".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_SSV_EXTENSION);
                this.selectedFileFilter = ALL_SSV_EXTENSION;
            } else if ("TAB".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_TSV_EXTENSION);
                this.selectedFileFilter = ALL_TSV_EXTENSION;
            } else if ("PIPE".equalsIgnoreCase(this.flatfileDelimiterType)) {
                this.fileFilter.add((Object)ALL_PSV_EXTENSION);
                this.selectedFileFilter = ALL_PSV_EXTENSION;
            } else {
                this.selectedFileFilter = MATCH_ALL_FILES;
            }
            this.fileFilter.add((Object)ALL_TXT_EXTENSION);
            this.fileFilter.add((Object)MATCH_ALL_FILES);
            this.fileFilter.getCombo().select(0);
        }
    }

    private void moveUpItem() {
        int count = this.selectedColumnsViewer.getTable().getItemCount();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        if (index > 0 && index < count) {
            if (!this.btnMoveDown.isEnabled()) {
                this.btnMoveDown.setEnabled(true);
            }
            String[] columnInfo = this.savedSelectedColumnsInfoList.get(index);
            this.savedSelectedColumnsInfoList.set(index, this.savedSelectedColumnsInfoList.get(index - 1));
            this.savedSelectedColumnsInfoList.set(index - 1, columnInfo);
            this.selectedColumnsViewer.refresh();
            this.selectedColumnsViewer.getTable().setSelection(index - 1);
        }
        if (index == 1) {
            this.btnMoveUp.setEnabled(false);
        }
    }

    private void moveDownItem() {
        int count = this.selectedColumnsViewer.getTable().getItemCount();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        if (index > -1 && index < count - 1) {
            if (!this.btnMoveUp.isEnabled()) {
                this.btnMoveUp.setEnabled(true);
            }
            String[] columnInfo = this.savedSelectedColumnsInfoList.get(index);
            this.savedSelectedColumnsInfoList.set(index, this.savedSelectedColumnsInfoList.get(index + 1));
            this.savedSelectedColumnsInfoList.set(index + 1, columnInfo);
            this.selectedColumnsViewer.refresh();
            this.selectedColumnsViewer.getTable().setSelection(index + 1);
        }
        if (index == count - 2) {
            this.btnMoveDown.setEnabled(false);
        }
    }

    private void addColumns() {
        List<String[]> addedItems = this.createAddedColumnsInfo(this.availableList.getSelection());
        int i = 0;
        while (i < addedItems.size()) {
            this.savedSelectedColumnsInfoList.add(addedItems.get(i));
            ++i;
        }
        this.setDisplayContent(this.savedSelectedColumnsInfoList, this.selectedColumnsViewer);
        this.selectedColumnsViewer.getTable().setSelection(this.selectedColumnsViewer.getTable().getItemCount() - 1);
        this.selectedColumnsViewer.getTable().setSelection(-1);
        this.updateSelectionFocus();
        this.updateButtons();
    }

    private List<String[]> createAddedColumnsInfo(String[] addedColumnNames) {
        ArrayList<String[]> addedColumnsInfo = new ArrayList<String[]>();
        int count = 0;
        int i = 0;
        while (i < addedColumnNames.length) {
            count = this.getExistenceCount(addedColumnNames[i]);
            String[] addedColumns = new String[]{count == 0 ? addedColumnNames[i] : String.valueOf(addedColumnNames[i]) + "_" + count, addedColumnNames[i], this.getColumnTypeName(addedColumnNames[i])};
            addedColumnsInfo.add(addedColumns);
            ++i;
        }
        return addedColumnsInfo;
    }

    private String getColumnTypeName(String columnName) {
        int i = 0;
        while (i < this.originalFileColumnsInfoList.size()) {
            if (columnName.equals(this.originalFileColumnsInfoList.get(i)[1])) {
                return this.originalFileColumnsInfoList.get(i)[2];
            }
            ++i;
        }
        return null;
    }

    private void removeColumns() {
        TableItem[] tis = this.selectedColumnsViewer.getTable().getSelection();
        int index = this.selectedColumnsViewer.getTable().getSelectionIndex();
        String[] removedColumnInfo = null;
        ArrayList<String[]> removedItems = new ArrayList<String[]>();
        int i = 0;
        while (i < tis.length) {
            removedColumnInfo = new String[]{tis[i].getText(0), tis[i].getText(1), tis[i].getText(2)};
            removedItems.add(removedColumnInfo);
            ++i;
        }
        this.removeItemsFromSelectedOnes(removedItems);
        this.selectedColumnsViewer.refresh();
        if (index > 0) {
            this.selectedColumnsViewer.getTable().setSelection(index - 1);
        } else {
            this.selectedColumnsViewer.getTable().setSelection(index);
        }
        if (this.selectedColumnsViewer.getTable().getSelectionCount() == 0) {
            this.btnRemove.setEnabled(false);
        }
        if (this.savedSelectedColumnsInfoList.size() <= 1) {
            this.btnMoveDown.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
        }
        if (this.selectedColumnsViewer.getTable().getItemCount() == 0) {
            this.setPageComplete(false);
        }
    }

    private void removeAllColumns() {
        this.selectedColumnsViewer.getTable().removeAll();
        this.savedSelectedColumnsInfoList.clear();
        this.selectedColumnsViewer.refresh();
        this.btnRemove.setEnabled(false);
        this.btnMoveDown.setEnabled(false);
        this.btnMoveUp.setEnabled(false);
        this.setPageComplete(false);
    }

    private void removeItemsFromSelectedOnes(List<String[]> removedItemsList) {
        int i = 0;
        while (i < removedItemsList.size()) {
            int j = 0;
            while (j < this.savedSelectedColumnsInfoList.size()) {
                if (removedItemsList.get(i)[0].equals(this.savedSelectedColumnsInfoList.get(j)[0]) && removedItemsList.get(i)[1].equals(this.savedSelectedColumnsInfoList.get(j)[1]) && removedItemsList.get(i)[2].equals(this.savedSelectedColumnsInfoList.get(j)[2])) {
                    this.savedSelectedColumnsInfoList.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.validateSelectedColumns();
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block6: {
            String queryText = this.getQueryText();
            if (queryText.equals(dataSetDesign.getQueryText())) {
                return;
            }
            dataSetDesign.setQueryText(queryText);
            IConnection conn = null;
            try {
                try {
                    FlatFileDriver ffDriver = new FlatFileDriver();
                    conn = ffDriver.getConnection(null);
                    IResultSetMetaData metadata = this.getResultSetMetaData(queryText, conn);
                    this.setResultSetMetaData(dataSetDesign, metadata);
                }
                catch (OdaException odaException) {
                    dataSetDesign.setResultSets(null);
                    this.closeConnection(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
    }

    private String getQueryText() {
        String query = this.getQuery();
        String queryText = query.length() > 0 ? String.valueOf(query) + " " + queryTextDelimiter + " " + columnsInfoStartSymbol + this.createSelectedColumnsInfoString() + columnsInfoEndSymbol : "";
        return queryText;
    }

    private String createSelectedColumnsInfoString() {
        String prop = "";
        int i = 0;
        while (i < this.savedSelectedColumnsInfoList.size()) {
            char[] columnNameChars = this.savedSelectedColumnsInfoList.get(i)[0].toCharArray();
            StringBuffer columnNameBuf = new StringBuffer();
            char[] originalColumnNameChars = this.savedSelectedColumnsInfoList.get(i)[1].toCharArray();
            StringBuffer originalColumnNameBuf = new StringBuffer();
            int m = 0;
            while (m < columnNameChars.length) {
                if (ColumnsInfoUtil.isColumnsInfoKeyWord((char)columnNameChars[m])) {
                    columnNameBuf.append("\\" + columnNameChars[m]);
                } else {
                    columnNameBuf.append(columnNameChars[m]);
                }
                ++m;
            }
            prop = String.valueOf(prop) + '\"' + columnNameBuf.toString() + '\"' + ",";
            m = 0;
            while (m < originalColumnNameChars.length) {
                if (ColumnsInfoUtil.isColumnsInfoKeyWord((char)originalColumnNameChars[m])) {
                    originalColumnNameBuf.append("\\" + originalColumnNameChars[m]);
                } else {
                    originalColumnNameBuf.append(originalColumnNameChars[m]);
                }
                ++m;
            }
            prop = String.valueOf(prop) + '\"' + originalColumnNameBuf.toString() + '\"' + ",";
            prop = i != this.savedSelectedColumnsInfoList.size() - 1 ? String.valueOf(prop) + this.getDataTypeValue(this.savedSelectedColumnsInfoList.get(i)[2]) + ";" : String.valueOf(prop) + this.getDataTypeValue(this.savedSelectedColumnsInfoList.get(i)[2]);
            ++i;
        }
        this.savedSelectedColumnsInfoString = prop;
        return this.savedSelectedColumnsInfoString;
    }

    private void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    class CSVFileFilter
    implements FilenameFilter {
        private String extension = null;

        CSVFileFilter(String ext) {
            this.extension = FileSelectionWizardPage.ALL_CSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.CSV_EXTENSION : (FileSelectionWizardPage.ALL_TXT_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.TXT_EXTENSION : (FileSelectionWizardPage.ALL_SSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.SSV_EXTENSION : (FileSelectionWizardPage.ALL_TSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.TSV_EXTENSION : (FileSelectionWizardPage.ALL_PSV_EXTENSION.equalsIgnoreCase(ext) ? FileSelectionWizardPage.PSV_EXTENSION : null))));
        }

        public boolean accept(File dir, String name) {
            if (this.extension == null) {
                File file = new File(dir + File.separator + name);
                return file.isFile() && !file.isHidden();
            }
            return name.toLowerCase().endsWith(this.extension);
        }
    }

    private class ColumnEditDialog
    extends StatusDialog {
        String columnName;
        String columnOriginalName;
        String columnDataType;

        public ColumnEditDialog(Shell parent) {
            super(parent);
        }

        public void setInput(String columnName, String columnOriginalName, String columnDataType) {
            this.columnName = columnName;
            this.columnOriginalName = columnOriginalName;
            this.columnDataType = columnDataType;
        }

        protected boolean isResizable() {
            return true;
        }

        public void create() {
            super.create();
            Point pt = this.getShell().computeSize(-1, -1);
            pt.x = Math.max(pt.x, 400);
            pt.y = Math.max(pt.y, 250);
            this.getShell().setSize(pt);
            this.getShell().setText(FileSelectionWizardPage.this.getTitle());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginRight = 20;
            layout.marginTop = 20;
            layout.marginLeft = 20;
            layout.marginBottom = 5;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            composite.setLayoutData((Object)data);
            GridData lableData = new GridData();
            lableData.widthHint = 100;
            Label columnNameLabel = new Label(composite, 1);
            columnNameLabel.setLayoutData((Object)lableData);
            columnNameLabel.setText(Messages.getString("FileSelectionWizardPage.label.columnName"));
            int width = columnNameLabel.computeSize((int)-1, (int)-1).x;
            if (width > lableData.widthHint) {
                lableData.widthHint = width;
            }
            columnNameLabel.setLayoutData((Object)lableData);
            final Text columnNameText = new Text(composite, 2048);
            columnNameText.setLayoutData((Object)new GridData(768));
            columnNameText.setText(this.columnName);
            columnNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    ColumnEditDialog.this.columnName = columnNameText.getText().trim();
                    ColumnEditDialog.this.validate();
                }
            });
            Label originalNameLabel = new Label(composite, 1);
            originalNameLabel.setText(Messages.getString("FileSelectionWizardPage.label.originalName"));
            width = originalNameLabel.computeSize((int)-1, (int)-1).x;
            if (width > lableData.widthHint) {
                lableData.widthHint = width;
            }
            originalNameLabel.setLayoutData((Object)lableData);
            Text originalNameText = new Text(composite, 2056);
            originalNameText.setLayoutData((Object)new GridData(768));
            originalNameText.setText(this.columnOriginalName);
            Label typeLabel = new Label(composite, 1);
            typeLabel.setLayoutData((Object)lableData);
            typeLabel.setText(Messages.getString("FileSelectionWizardPage.label.dataType"));
            final CCombo combo = new CCombo(composite, 2056);
            combo.setLayoutData((Object)new GridData(768));
            combo.setItems(dataTypeDisplayNames);
            combo.setText(this.columnDataType);
            combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    ColumnEditDialog.this.columnDataType = combo.getText();
                }
            });
            Utility.setSystemHelp(FileSelectionWizardPage.this.getControl(), "org.eclipse.datatools.oda.cshelp.Dialog_ColumnEditDialog_ID");
            return parent;
        }

        private boolean isDuplicatedName() {
            int i = 0;
            while (i < FileSelectionWizardPage.this.savedSelectedColumnsInfoList.size()) {
                if ((this.columnOriginalName == null || !this.columnOriginalName.equals(((String[])FileSelectionWizardPage.this.savedSelectedColumnsInfoList.get(i))[1])) && this.columnName.equals(((String[])FileSelectionWizardPage.this.savedSelectedColumnsInfoList.get(i))[0])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void validate() {
            Status status = this.columnName.trim().length() == 0 ? this.getMiscStatus(4, Messages.getString("FileSelectionWizardPage.error.selectColumn.EmptyName")) : (this.isDuplicatedName() ? this.getMiscStatus(4, Messages.getString("FileSelectionWizardPage.error.selectColumn.duplicatedFileName")) : (FileSelectionWizardPage.this.isNumeric(this.columnName.trim()) ? this.getMiscStatus(4, Messages.getString("FileSelectionWizardPage.error.selectColumn.numberName")) : this.getOKStatus()));
            this.updateStatus((IStatus)status);
        }

        protected Status getOKStatus() {
            return this.getMiscStatus(0, "");
        }

        protected Status getMiscStatus(int severity, String message) {
            return new Status(severity, "org.eclipse.ui", severity, message, null);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getOriginalName() {
            return this.columnOriginalName;
        }

        public String getDataType() {
            return this.columnDataType;
        }
    }
}

