/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCProcedure;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCUserDefinedFunction;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.EClass;

public class SQL2005RoutineLoader
extends JDBCRoutineLoader {
    public static final String COLUMN_ROUTINE_NAME = "ROUTINE_NAME";
    public static final String COLUMN_ROUTINE_CATALOG = "SPECIFIC_CATALOG";
    public static final String COLUMN_ROUTINE_SCHEMA = "SPECIFIC_SCHEMA";
    public static final String COLUMN_ROUTINE_TYPE = "ROUTINE_TYPE";
    public static final String COLUMN_ROUTINE_DEFINITION = "ROUTINE_DEFINITION";
    private static final String ROUTINE_QUERY = "select SPECIFIC_CATALOG as 'SPECIFIC_CATALOG', SPECIFIC_SCHEMA as 'SPECIFIC_SCHEMA', ROUTINE_NAME as 'ROUTINE_NAME', ROUTINE_DEFINITION as 'ROUTINE_DEFINITION', ROUTINE_TYPE as 'ROUTINE_TYPE' from catalogName.INFORMATION_SCHEMA.ROUTINES where SPECIFIC_SCHEMA = ?";
    private JDBCRoutineLoader.IRoutineFactory mUserDefinedFunctionFactory;
    private JDBCRoutineLoader.IRoutineFactory mProcedureFactory;

    private static final String getRoutineQuery(String catalogName) {
        return ROUTINE_QUERY.replaceAll("catalogName", catalogName);
    }

    public SQL2005RoutineLoader() {
        super(null);
    }

    public SQL2005RoutineLoader(ICatalogObject catalogObject) {
        super(catalogObject);
    }

    public SQL2005RoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        this.mUserDefinedFunctionFactory = new SQL2005UserDefinedFunctionFactory(catalogObject);
        this.mProcedureFactory = new SQL2005ProcedureFactory(catalogObject);
        this.setProcedureFactory(this.mProcedureFactory);
        this.setUserDefinedFunctionFactory(this.mUserDefinedFunctionFactory);
    }

    public SQL2005RoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, JDBCRoutineLoader.IRoutineFactory udfFactory, JDBCRoutineLoader.IRoutineFactory spFactory) {
        super(catalogObject, connectionFilterProvider, udfFactory, spFactory);
        this.mUserDefinedFunctionFactory = new SQL2005UserDefinedFunctionFactory(catalogObject);
        this.mProcedureFactory = new SQL2005ProcedureFactory(catalogObject);
        this.setProcedureFactory(this.mProcedureFactory);
        this.setUserDefinedFunctionFactory(this.mUserDefinedFunctionFactory);
    }

    protected ResultSet createResultSet() throws SQLException {
        String catalogName = this.getSchema().getCatalog().getName();
        String schemaName = this.getSchema().getName();
        String query = SQL2005RoutineLoader.getRoutineQuery(catalogName);
        if (this.getJDBCFilterPattern() != null && this.getJDBCFilterPattern().length() > 0) {
            String filter = " AND ALIAS LIKE " + this.getJDBCFilterPattern();
            query = String.valueOf(query) + filter;
        }
        query = String.valueOf(query) + " ORDER BY " + COLUMN_ROUTINE_NAME;
        PreparedStatement prepareStatement = this.getCatalogObject().getConnection().prepareStatement(query);
        prepareStatement.setString(1, schemaName);
        return prepareStatement.executeQuery();
    }

    protected boolean isProcedure(ResultSet rs) throws SQLException {
        return rs.getString(COLUMN_ROUTINE_TYPE).startsWith("P");
    }

    public JDBCRoutineLoader.IRoutineFactory getProcedureFactory() {
        return this.mProcedureFactory;
    }

    public JDBCRoutineLoader.IRoutineFactory getUserDefinedFunctionFactory() {
        return this.mUserDefinedFunctionFactory;
    }

    protected Routine processRow(ResultSet rs) throws SQLException {
        ICatalogObject object = this.getCatalogObject();
        Database database = object.getCatalogDatabase();
        if (this.mProcedureFactory == null) {
            this.mProcedureFactory = new SQL2005ProcedureFactory(object);
            ((SQL2005ProcedureFactory)this.mProcedureFactory).setDatabase(database);
        }
        if (this.mUserDefinedFunctionFactory == null) {
            this.mUserDefinedFunctionFactory = new SQL2005UserDefinedFunctionFactory(object);
            ((SQL2005UserDefinedFunctionFactory)this.mUserDefinedFunctionFactory).setDatabase(database);
        }
        JDBCRoutineLoader.IRoutineFactory routineFactory = this.isProcedure(rs) ? this.mProcedureFactory : this.mUserDefinedFunctionFactory;
        return routineFactory.createRoutine(rs);
    }

    public void loadRoutines(List containmentList, Collection existingRoutines) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            ICatalogObject object = this.getCatalogObject();
            Database database = object.getCatalogDatabase();
            rs = this.createResultSet();
            while (rs.next()) {
                String routineName = rs.getString(COLUMN_ROUTINE_NAME);
                if (routineName == null || this.isFiltered(routineName)) continue;
                Routine routine = (Routine)this.getAndRemoveSQLObject(existingRoutines, routineName);
                if (routine == null) {
                    routine = this.processRow(rs);
                    if (routine == null) continue;
                    containmentList.add(routine);
                    continue;
                }
                if (this.isProcedure(rs)) {
                    ((SQL2005ProcedureFactory)this.mProcedureFactory).setDatabase(database);
                    this.mProcedureFactory.initialize(routine, rs);
                } else {
                    ((SQL2005UserDefinedFunctionFactory)this.mUserDefinedFunctionFactory).setDatabase(database);
                    this.mUserDefinedFunctionFactory.initialize(routine, rs);
                }
                containmentList.add(routine);
                if (!(routine instanceof ICatalogObject)) continue;
                ((ICatalogObject)routine).refresh();
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
        if (rs != null) {
            this.closeResultSet(rs);
        }
    }

    private static void loadSource(Routine routine, String aliasInfo, Database database) {
        if (aliasInfo == null || aliasInfo.trim().length() == 0) {
            return;
        }
        int index = -1;
        int begin = aliasInfo.toLowerCase().indexOf("begin");
        int returns = aliasInfo.toLowerCase().indexOf("returns");
        if (begin == -1 && returns == -1) {
            return;
        }
        index = begin == -1 ? returns : (returns > -1 && begin > -1 ? Math.min(returns, begin) : begin);
        String body = aliasInfo.substring(index);
        DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = definition.getDataModelElementFactory();
        Source s = (Source)factory.create(SQLRoutinesPackage.eINSTANCE.getSource());
        s.setBody(body);
        routine.setSource(s);
    }

    public static class SQL2005ProcedureFactory
    extends JDBCRoutineLoader.ProcedureFactory {
        private Database database = null;
        private final ICatalogObject catalogObject;

        public SQL2005ProcedureFactory(ICatalogObject catalogObject) {
            this.catalogObject = catalogObject;
        }

        public void setDatabase(Database db) {
            this.database = db;
        }

        public void initialize(Routine routine, ResultSet rs) throws SQLException {
            String name = rs.getString(SQL2005RoutineLoader.COLUMN_ROUTINE_NAME);
            if (name.indexOf(";") > -1) {
                name = name.substring(0, name.indexOf(";") - 1);
            }
            routine.setName(name);
            String source = rs.getString(SQL2005RoutineLoader.COLUMN_ROUTINE_DEFINITION);
            SQL2005RoutineLoader.loadSource(routine, source, this.database);
        }

        protected Routine newRoutine() {
            return new JDBCProcedure();
        }
    }

    public static class SQL2005UserDefinedFunctionFactory
    extends SQL2005ProcedureFactory {
        private final ICatalogObject catalogObject;

        public SQL2005UserDefinedFunctionFactory(ICatalogObject catalogObject) {
            super(catalogObject);
            this.catalogObject = catalogObject;
        }

        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
        }

        protected Routine newRoutine() {
            return new JDBCUserDefinedFunction();
        }
    }
}

