/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ui.plan;

import java.util.HashMap;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.plan.BaseExplainAction;
import org.eclipse.datatools.sqltools.sqleditor.plan.Images;
import org.eclipse.datatools.sqltools.sqleditor.plan.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IUpdate;

public class IngresExplainSQLActionDelegate
extends BaseExplainAction
implements IEditorActionDelegate,
ISelectionChangedListener,
IUpdate {
    protected SQLEditor _sqlEditor;

    public IngresExplainSQLActionDelegate() {
        this.setText(Messages.getString((String)"ExplainSQLActionDelegate.action_title"));
        this.setToolTipText(Messages.getString((String)"ExplainSQLActionDelegate.action_tooltip"));
        this.setImageDescriptor(Images.DESC_EXPLAIN_SQL);
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.ExplainSQLAction");
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
    }

    public void update() {
        this.setEnabled(this._sqlEditor != null && this._sqlEditor.isConnected() && super.canBeEnabled());
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._sqlEditor == null ? null : this._sqlEditor.getDatabaseIdentifier();
    }

    public String getSQLStatements() {
        String orignalSql = this._sqlEditor == null ? null : this._sqlEditor.getTargetText();
        return orignalSql;
    }

    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            public void run() {
                IngresExplainSQLActionDelegate.this._sqlEditor.getEditorSite().getPage().activate((IWorkbenchPart)IngresExplainSQLActionDelegate.this._sqlEditor);
            }
        };
        return postRun;
    }

    protected HashMap getVariableDeclarations() {
        ITextSelection _selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        int start = 0;
        int length = 0;
        if (_selection == null) {
            _selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        }
        if (_selection != null && !_selection.isEmpty()) {
            start = _selection.getOffset();
            length = _selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
        }
        int offset = length > 0 ? start + 1 : start;
        IDocument document = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        ParsingResult result = this._sqlEditor.getParsingResult();
        HashMap variables = new HashMap();
        if (result != null) {
            variables = result.getVariables(document, offset);
            HashMap sp_params = result.getParameters(document, offset);
            variables.putAll(sp_params);
        }
        return variables;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this.update();
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setActiveEditor((SQLEditor)targetEditor);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.update();
        }
    }
}

