/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.plan;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.plan.EPVFacade;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.plan.PlanSupportRunnable;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.plan.Messages;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class GroupPlanSupportRunnable
extends PlanSupportRunnable {
    private Runnable _postRun;

    public GroupPlanSupportRunnable(PlanRequest request, DatabaseIdentifier databaseIdentifier, Runnable postRun) {
        super(request, databaseIdentifier.getProfileName(), databaseIdentifier.getDBname());
        this._postRun = postRun;
    }

    protected String explainPlan(Statement stmt) throws SQLException {
        return null;
    }

    public void run() {
        this.run(null);
    }

    protected void handleEnd(Connection connection, Statement stmt) {
    }

    protected IStatus run(IProgressMonitor monitor) {
        IJobManager manager = Platform.getJobManager();
        if (monitor == null) {
            monitor = manager.createProgressGroup();
        }
        String[] groups = new String[]{this._request.getSql()};
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(this._profileName, this._dbName);
        SQLService helper = SQLToolsFacade.getSQLService((DatabaseIdentifier)databaseIdentifier, (String)this._request.getDatabaseDefinitionId().toString());
        if (helper != null) {
            groups = helper.splitSQL(this._request.getSql());
        }
        String task = Messages.getString("GroupPlanSupportRunnable.sql_execution_plan");
        if (groups.length > 1) {
            task = String.valueOf(task) + NLS.bind((String)Messages.getString("GroupPlanSupportRunnable.groups"), (Object[])new Object[]{"" + groups.length});
        }
        monitor.beginTask(task, groups.length);
        int i = 0;
        while (i < groups.length) {
            if (groups.length > 1) {
                monitor.subTask(NLS.bind((String)Messages.getString("GroupPlanSupportRunnable.group"), (Object[])new Object[]{"" + i}));
            }
            PlanSupportRunnable planRunnable = null;
            PlanRequest request = new PlanRequest(groups[i], this._request.getDatabaseDefinitionId(), this._request.getPlanType(), this._request.getMode());
            request.setNoexec(this._request.isNoexec());
            request.setSql(this.processVarDecs(request.getSql(), databaseIdentifier, this._request.getVarDecs()));
            if (request.getSql() == null) {
                monitor.worked(1);
            } else {
                IPlanService planService = SQLToolsUIFacade.getPlanService((DatabaseIdentifier)databaseIdentifier);
                if (planService != null) {
                    planRunnable = planService.createPlanSupportRunnable(request, this._profileName, this._dbName);
                }
                if (planRunnable != null) {
                    if (this.getConnection() != null) {
                        planRunnable.setConnection(this.getConnection());
                    }
                    planRunnable.setProgressGroup(monitor, 1);
                    planRunnable.schedule();
                    try {
                        planRunnable.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (EPVFacade.getInstance().getStatus(request) == 2 && i < groups.length - 1) {
                        IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
                        String errorpm = store.getString("PreferenceConstants.EXECUTE_SQL_ERROR_MODE");
                        if (errorpm == null || errorpm.equals("") || "PreferenceConstants.PROMPT_MODE_PROMPT".equals(errorpm)) {
                            ConfirmRunnable run = new ConfirmRunnable();
                            SQLEditorPlugin.getDisplay().syncExec((Runnable)run);
                            if (!run.goon) {
                                break;
                            }
                        } else if (!"PreferenceConstants.PROMPT_MODE_ALWAYS".equals(errorpm)) break;
                    }
                }
            }
            ++i;
        }
        if (this._postRun != null) {
            SQLEditorPlugin.getDisplay().syncExec(this._postRun);
        }
        return Status.OK_STATUS;
    }

    protected String processVarDecs(String sql, DatabaseIdentifier databaseIdentifier, Map varDecs) {
        return sql;
    }

    private final class ConfirmRunnable
    implements Runnable {
        boolean goon = false;

        private ConfirmRunnable() {
        }

        public void run() {
            IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)SQLEditorPlugin.getActiveWorkbenchShell(), (String)Messages.getString("GroupPlanSupportRunnable.continue_explain"), (String)Messages.getString("GroupPlanSupportRunnable.error_info"), null, (boolean)false, (IPreferenceStore)store, (String)"PreferenceConstants.EXECUTE_SQL_ERROR_MODE");
            int result = dlg.getReturnCode();
            if (dlg.getToggleState()) {
                String preferenceValue = result == 2 ? "PreferenceConstants.PROMPT_MODE_ALWAYS" : "PreferenceConstants.PROMPT_MODE_NEVER";
                store.setValue("PreferenceConstants.EXECUTE_SQL_ERROR_MODE", preferenceValue);
            }
            this.goon = result == 2;
        }
    }
}

