/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NullOrderingType implements Enumerator
{
    UNKNOWN(0, "Unknown", "Unknown"),
    NULLS_FIRST(1, "NullsFirst", "NullsFirst"),
    NULLS_LAST(2, "NullsLast", "NullsLast");

    public static final String copyright = "Copyright (c) 2009 Actuate Corporation";
    public static final int UNKNOWN_VALUE = 0;
    public static final int NULLS_FIRST_VALUE = 1;
    public static final int NULLS_LAST_VALUE = 2;
    private static final NullOrderingType[] VALUES_ARRAY;
    public static final List<NullOrderingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NullOrderingType[]{UNKNOWN, NULLS_FIRST, NULLS_LAST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NullOrderingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NullOrderingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NullOrderingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NullOrderingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NullOrderingType get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return NULLS_FIRST;
            }
            case 2: {
                return NULLS_LAST;
            }
        }
        return null;
    }

    private NullOrderingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

