/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.catalog;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCTable;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableConstraintLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.IngresTableConstraintLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.IngresTableTriggerLoader;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.emf.common.util.EList;

public class IngresCatalogTable
extends JDBCTable {
    private final Object TRIGGER_LOCK = new Object();
    private final Object CCS_LOCK = new Object();
    private Boolean triggersLoaded = Boolean.FALSE;
    private Boolean ccsLoaded = Boolean.FALSE;
    private transient SoftReference triggerLoaderRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getTriggers() {
        Object object = this.TRIGGER_LOCK;
        synchronized (object) {
            if (!this.triggersLoaded.booleanValue()) {
                this.loadTriggers();
            }
        }
        return super.getTriggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getConstraints() {
        Object object = this.CCS_LOCK;
        synchronized (object) {
            if (!this.ccsLoaded.booleanValue()) {
                this.loadCheckConstraints();
            }
        }
        return super.getConstraints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.TRIGGER_LOCK;
        synchronized (object) {
            if (this.triggersLoaded.booleanValue()) {
                this.triggersLoaded = Boolean.FALSE;
            }
        }
        object = this.CCS_LOCK;
        synchronized (object) {
            if (this.ccsLoaded.booleanValue()) {
                this.ccsLoaded = Boolean.FALSE;
            }
        }
        super.refresh();
    }

    private void loadTriggers() {
        boolean deliver = this.eDeliver();
        try {
            try {
                EList container = super.getTriggers();
                ArrayList existingTriggers = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getTriggerLoader().loadTriggers((List)container, existingTriggers);
                this.getTriggerLoader().clearTriggers(existingTriggers);
                this.triggersLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    protected final IngresTableTriggerLoader getTriggerLoader() {
        if (this.triggerLoaderRef == null || this.triggerLoaderRef.get() == null) {
            this.triggerLoaderRef = new SoftReference<IngresTableTriggerLoader>(this.createTriggerLoader());
        }
        return (IngresTableTriggerLoader)((Object)this.triggerLoaderRef.get());
    }

    protected IngresTableTriggerLoader createTriggerLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getTrigger().getInstanceClassName());
        if (loader != null) {
            IngresTableTriggerLoader triggerLoader = (IngresTableTriggerLoader)loader;
            triggerLoader.setCatalogObject((ICatalogObject)this);
            return triggerLoader;
        }
        return new IngresTableTriggerLoader((ICatalogObject)this);
    }

    private void loadCheckConstraints() {
        boolean deliver = this.eDeliver();
        try {
            try {
                EList container = super.getConstraints();
                List existingCCs = this.internalGetCheckConstraints((Collection)container);
                container.removeAll(existingCCs);
                JDBCTableConstraintLoader loader = this.getConstraintLoader();
                if (loader instanceof IngresTableConstraintLoader) {
                    ((IngresTableConstraintLoader)loader).loadCheckConstraints((List)container, existingCCs);
                }
                this.ccsLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    private List internalGetCheckConstraints(Collection constraints) {
        Vector<Constraint> uniqueConstraints = new Vector<Constraint>();
        for (Constraint currentConstraint : constraints) {
            if (!(currentConstraint instanceof CheckConstraint)) continue;
            uniqueConstraints.add(currentConstraint);
        }
        return uniqueConstraints;
    }
}

