/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.ClassLoaderCacheManager;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.services.PluginResourceLocatorImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ConnectivityPlugin
extends Plugin {
    public static final int INTERNAL_ERROR = 10001;
    public static final String PLUGIN_ID = "org.eclipse.datatools.connectivity";
    public static final String PROP_SYSTEM_REPOSITORIES_ENABLED = "org.eclipse.datatools.connectivity.repositoriesEnabled";
    private static ConnectivityPlugin plugin;
    private static IPath defaultWorkspace;
    private static Logger jdkLogger;
    private ResourceBundle resourceBundle;
    private Preferences localPreferences;

    public ConnectivityPlugin() {
        plugin = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectivityPlugin getDefault() {
        if (plugin != null) return plugin;
        Class<ConnectivityPlugin> clazz = ConnectivityPlugin.class;
        synchronized (ConnectivityPlugin.class) {
            if (plugin != null) return plugin;
            new ConnectivityPlugin();
            // ** MonitorExit[var0] (shouldn't be in output)
            return plugin;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        InternalProfileManager.getInstance().dispose();
        ClassLoaderCacheManager.releaseInstance();
        super.stop(context);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.internal.resources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public String getResourceString(String key) {
        try {
            ResourceBundle resBundle = this.getResourceBundle();
            if (resBundle == null) {
                return key;
            }
            return resBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public String getResourceString(String key, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getResourceString(key));
        return f.format((Object)arguments);
    }

    public static String getSymbolicName() {
        Bundle theBundle = ConnectivityPlugin.getDefault().getBundle();
        return theBundle != null ? theBundle.getSymbolicName() : PLUGIN_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPath getDefaultStateLocation() {
        if (defaultWorkspace != null) return defaultWorkspace;
        IPath wsPath = PluginResourceLocatorImpl.getPluginStateLocation(PLUGIN_ID);
        if (wsPath == null) {
            String messageId = "ConnectivityPlugin.error.noDefaultWorkspace";
            String errorMsg = ConnectivityPlugin.getDefault().getResourceString(messageId);
            ConnectivityPlugin.getDefault().logError(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        Class<ConnectivityPlugin> clazz = ConnectivityPlugin.class;
        synchronized (ConnectivityPlugin.class) {
            if (defaultWorkspace != null) return defaultWorkspace;
            defaultWorkspace = wsPath;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return defaultWorkspace;
        }
    }

    public static IPath getWorkspaceFilePath(String filename) {
        IPath metadataPath = ConnectivityPlugin.getDefaultStateLocation();
        return metadataPath.append(filename);
    }

    public static IPath getStorageLocation() {
        IPath defaultLocation = ConnectivityPlugin.getDefaultStateLocation();
        File file = defaultLocation.toFile();
        if (!file.exists()) {
            try {
                file.mkdir();
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().logWarning(e.getMessage());
                return null;
            }
        }
        return defaultLocation;
    }

    public static URL getEntry(String path) {
        return PluginResourceLocatorImpl.getPluginEntry(PLUGIN_ID, path, ConnectivityPlugin.class.getClassLoader());
    }

    public static URL getResource(String name) {
        return PluginResourceLocatorImpl.getPluginResource(PLUGIN_ID, name, ConnectivityPlugin.class.getClassLoader());
    }

    public static boolean isRunningOSGiPlatform() {
        return Platform.getBundle((String)PLUGIN_ID) != null;
    }

    public void setPreferenceValue(String name, boolean value) {
        this.getPreferences().setValue(name, value);
    }

    public void setPreferenceValue(String name, String value) {
        this.getPreferences().setValue(name, value);
    }

    public boolean getPreferenceBooleanValue(String name) {
        return this.getPreferences().getBoolean(name);
    }

    public String getPreferenceStringValue(String name) {
        return this.getPreferences().getString(name);
    }

    public void storePreferences(OutputStream out, String header) throws IOException {
        this.getPreferences().store(out, header);
    }

    public void loadPreferences(InputStream in) throws IOException {
        this.getPreferences().load(in);
    }

    private Preferences getPreferences() {
        if (ConnectivityPlugin.isRunningOSGiPlatform()) {
            return this.getPluginPreferences();
        }
        if (this.localPreferences == null) {
            this.localPreferences = new Preferences();
        }
        return this.localPreferences;
    }

    public void log(IStatus status) {
        if (ConnectivityPlugin.isRunningOSGiPlatform()) {
            this.getLog().log(status);
        } else {
            ConnectivityPlugin.getJdkLogger().log(ConnectivityPlugin.getLogLevel(status), status.getMessage());
        }
    }

    public void log(String message) {
        this.logError(message);
    }

    public void logError(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void logInfo(String message) {
        this.log(this.createStatus(1, message));
    }

    public void logWarning(String message) {
        this.log(this.createStatus(2, message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return this.createStatus(4, message);
    }

    private IStatus createStatus(int severity, String message) {
        return new Status(severity, ConnectivityPlugin.getSymbolicName(), 10001, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        String message = e == null || e.getMessage() == null ? this.getResourceString("plugin.internal_error") : e.getMessage();
        return new Status(4, ConnectivityPlugin.getSymbolicName(), 10001, message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getJdkLogger() {
        if (jdkLogger != null) return jdkLogger;
        Class<ConnectivityPlugin> clazz = ConnectivityPlugin.class;
        synchronized (ConnectivityPlugin.class) {
            if (jdkLogger != null) return jdkLogger;
            jdkLogger = Logger.getLogger(PLUGIN_ID);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jdkLogger;
        }
    }

    private static Level getLogLevel(IStatus status) {
        int severity = status.getSeverity();
        switch (severity) {
            case 8: {
                return Level.INFO;
            }
            case 4: {
                return Level.SEVERE;
            }
            case 1: {
                return Level.INFO;
            }
            case 0: {
                return Level.FINE;
            }
            case 2: {
                return Level.WARNING;
            }
        }
        return Level.WARNING;
    }
}

