/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.flatfile.DataTypes;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSet;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaDataHelper;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.FlatFileDataReader;
import org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil.QueryTextUtil;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class FlatFileQuery
implements IQuery {
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final String NAME_LITERAL = "NAME";
    private static final String TYPE_LITERAL = "TYPE";
    private boolean hasColumnNames;
    private boolean hasTypeLine;
    private Properties connProperties;
    private String currentTableName = null;
    private int maxRows = 0;
    private IConnection connection = null;
    private ResultSetMetaData resultSetMetaData = null;
    private ResultSetMetaDataHelper resultSetMetaDataHelper = null;

    public FlatFileQuery(Properties connProperties, IConnection host) throws OdaException {
        if (connProperties == null || connProperties.getProperty("HOME") == null || host == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.connProperties = connProperties;
        this.connection = host;
        this.extractsHasColumnNamesInfo();
        this.extractsHasColumnTypeLineInfo();
    }

    private void extractsHasColumnNamesInfo() {
        this.hasColumnNames = !this.connProperties.getProperty("INCLCOLUMNNAME").equalsIgnoreCase("NO");
    }

    private void extractsHasColumnTypeLineInfo() {
        this.hasTypeLine = !this.connProperties.getProperty("INCLTYPELINE").equalsIgnoreCase("NO");
    }

    public void prepare(String queryText) throws OdaException {
        if (queryText == null) {
            throw new OdaException(Messages.getString("common_NULL_QUERY_TEXT"));
        }
        QueryTextUtil qtu = new QueryTextUtil(queryText);
        String query = qtu.getQuery();
        String colInfo = qtu.getColumnsInfo();
        this.validateOpenConnection();
        String formattedQuery = this.formatQueryText(query);
        this.prepareMetaData(formattedQuery, colInfo);
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void setProperty(String name, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void close() throws OdaException {
        this.currentTableName = null;
        this.maxRows = 0;
        this.connection = null;
        this.resultSetMetaData = null;
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        return new ResultSet(new FlatFileDataReader(this.connProperties, this.currentTableName, this.maxRows, this.resultSetMetaData, this.resultSetMetaDataHelper), this.resultSetMetaData);
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(int parameterId, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(String parameterName, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(int parameterId, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int findInParameter(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void clearInParameters() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        throw new UnsupportedOperationException();
    }

    private void validateOpenConnection() throws OdaException {
        if (!this.connection.isOpen()) {
            throw new OdaException(Messages.getString("common_CONNECTION_IS_NOT_OPEN"));
        }
    }

    private void validateNonEmptyQueryText(String formattedQuery) throws OdaException {
        if (formattedQuery == null || formattedQuery.length() == 0) {
            throw new OdaException(Messages.getString("query_COMMAND_IS_EMPTY"));
        }
    }

    private void validateSingleTableQuery(String[] parsedQuerySegments) throws OdaException {
        if (this.getPreparedTableNames(parsedQuerySegments).split(",").length != 1) {
            throw new OdaException(Messages.getString("query_DO_NOT_SUPPORT_CROSS_TABLE_QUERY"));
        }
    }

    private String getPreparedColumnNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[0];
    }

    private String getPreparedColumnLabels(String[] parsedQueryFragments) {
        return parsedQueryFragments[1];
    }

    private String getPreparedTableNames(String[] parsedQueryFragments) {
        return parsedQueryFragments[2];
    }

    private String[] parsePreparedQueryText(String formattedQuery) throws OdaException {
        String queryWithoutSELECTKeyword = this.stripSELECTKeyword(formattedQuery);
        String[] querySelectAndFromFragments = this.stripFROMKeyword(queryWithoutSELECTKeyword);
        return this.stripASKeyword(querySelectAndFromFragments);
    }

    private String[] stripASKeyword(String[] querySelectAndFromFragments) {
        String[] result = new String[3];
        result[2] = querySelectAndFromFragments[1];
        String selectedColumns = querySelectAndFromFragments[0];
        if (!this.isWildCard(selectedColumns)) {
            String[] columns = FlatFileDataReader.getStringArrayFromList(this.getQueryColumnNamesVector(selectedColumns));
            int i = 0;
            while (i < columns.length) {
                String[] columnNameAlias = columns[i].split(" AS ");
                if (columnNameAlias != null) {
                    String string = result[0] = i == 0 ? columnNameAlias[0] : String.valueOf(result[0]) + "," + columnNameAlias[0].trim();
                    result[1] = columnNameAlias.length == 2 ? (i == 0 ? columnNameAlias[1] : String.valueOf(result[1]) + "," + columnNameAlias[1].trim()) : (i == 0 ? null : String.valueOf(result[1]) + "," + null);
                }
                ++i;
            }
        } else {
            result[0] = "*";
            result[1] = null;
        }
        return result;
    }

    private Vector getQueryColumnNamesVector(String queryColumnNames) {
        Vector<String> result = new Vector<String>();
        char[] chars = queryColumnNames.toCharArray();
        ArrayList<Integer> indiceList = new ArrayList<Integer>();
        boolean inQuote = false;
        boolean isEscaped = false;
        int beginIndex = 0;
        int endIndex = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\"') {
                if (!isEscaped) {
                    inQuote = !inQuote;
                } else {
                    isEscaped = !isEscaped;
                }
            } else if (chars[i] == '\\') {
                isEscaped = !isEscaped;
            } else if (chars[i] == ',' && !inQuote) {
                indiceList.add(new Integer(i));
            }
            ++i;
        }
        if (indiceList.size() > 0) {
            int j = 0;
            while (j < indiceList.size()) {
                endIndex = (Integer)indiceList.get(j);
                result.add(queryColumnNames.substring(beginIndex, endIndex).trim());
                beginIndex = endIndex + 1;
                if (j == indiceList.size() - 1) {
                    result.add(queryColumnNames.substring(beginIndex, queryColumnNames.length()).trim());
                }
                ++j;
            }
        } else {
            result.add(queryColumnNames);
        }
        return result;
    }

    private Vector stripFormatInfoFromQueryColumnNames(Vector queryColumnNames) {
        Vector columnNames = new Vector();
        boolean isEscaped = false;
        int i = 0;
        while (i < queryColumnNames.size()) {
            StringBuffer sb = new StringBuffer();
            char[] chars = ((String)queryColumnNames.get(i)).toCharArray();
            if (chars[0] != '\"') {
                columnNames.add(queryColumnNames.get(i));
            } else {
                int j = 0;
                while (j < chars.length) {
                    if (chars[j] == '\"') {
                        if (isEscaped) {
                            sb.append(chars[j]);
                            isEscaped = !isEscaped;
                        }
                    } else if (chars[j] == '\\') {
                        if (isEscaped) {
                            sb.append(chars[j]);
                        }
                        isEscaped = !isEscaped;
                    } else {
                        sb.append(chars[j]);
                    }
                    ++j;
                }
                columnNames.add(sb.toString());
            }
            ++i;
        }
        return columnNames;
    }

    private String[] stripFROMKeyword(String queryWithoutSELECTKeyword) throws OdaException {
        String[] result = queryWithoutSELECTKeyword.split(" FROM ");
        if (result == null || result.length != 2) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        return result;
    }

    private String stripSELECTKeyword(String formattedQuery) throws OdaException {
        String[] array = formattedQuery.split(" ", 2);
        if (array == null || array.length != 2 || !array[0].trim().equalsIgnoreCase("SELECT")) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        return array[1];
    }

    private String[] createTempColumnNames(int columnCount) {
        String[] tempColumnNames = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            tempColumnNames[i] = "COLUMN_" + (i + 1);
            ++i;
        }
        return tempColumnNames;
    }

    private String[] createTempColumnTypes(int columnCount) {
        String[] tempColumnTypes = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            tempColumnTypes[i] = "STRING";
            ++i;
        }
        return tempColumnTypes;
    }

    private String[] discoverActualColumnMetaData(String tableName, String metaDataType) throws OdaException {
        FlatFileDataReader ffdsr = new FlatFileDataReader(this.connProperties, tableName, 0, null, null);
        try {
            List columnNameLine;
            if (!metaDataType.trim().equalsIgnoreCase(NAME_LITERAL) && !metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                throw new OdaException(Messages.getString("query_ARGUMENT_ERROR"));
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                while (FlatFileDataReader.isEmptyRow(ffdsr.readLine())) {
                }
            }
            while (FlatFileDataReader.isEmptyRow(columnNameLine = ffdsr.readLine())) {
            }
            String[] result = ffdsr.getColumnNameArray(columnNameLine);
            if (metaDataType.trim().equalsIgnoreCase(NAME_LITERAL)) {
                this.validateUniqueName(result);
            }
            if (metaDataType.trim().equalsIgnoreCase(TYPE_LITERAL)) {
                this.validateColumnTypeConsistency(result);
            }
            String[] stringArray = this.trimStringArray(result);
            return stringArray;
        }
        catch (IOException iOException) {
            throw new OdaException(String.valueOf(Messages.getString("query_IO_EXCEPTION")) + ffdsr.findDataFileAbsolutePath());
        }
        finally {
            ffdsr.clearBufferedReader();
        }
    }

    private String[] trimStringArray(String[] array) {
        String[] result = new String[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i].trim();
            ++i;
        }
        return result;
    }

    private void validateColumnName(String[] cCN, String[] aCN) throws OdaException {
        int i = 0;
        while (i < cCN.length) {
            if (this.findOccuranceOfValueInStringArray(cCN[i], aCN) != 1) {
                throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
            }
            ++i;
        }
    }

    private boolean isWildCard(String cCN) {
        return cCN.equalsIgnoreCase("*");
    }

    private void validateUniqueName(String[] aCN) throws OdaException {
        int i = 0;
        while (i < aCN.length) {
            if (this.findOccuranceOfValueInStringArray(aCN[i], aCN) > 1) {
                throw new OdaException(Messages.getString("query_SOURCE_DATA_ERROR"));
            }
            ++i;
        }
    }

    private void validateColumnTypeConsistency(String[] aCT) throws OdaException {
        if (!this.hasTypeLine) {
            return;
        }
        int i = 0;
        while (i < aCT.length) {
            if (!DataTypes.isValidType(aCT[i])) {
                throw new OdaException(String.valueOf(Messages.getString("dataTypes_TYPE_NAME_INVALID")) + aCT[i]);
            }
            ++i;
        }
    }

    private int findOccuranceOfValueInStringArray(String value, String[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            if (value.trim().equalsIgnoreCase(array[i].trim())) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void prepareMetaData(String query, String savedSelectedColInfo) throws OdaException {
        String[] allColumnTypes;
        this.validateNonEmptyQueryText(query);
        String[] queryFragments = this.parsePreparedQueryText(query);
        this.validateSingleTableQuery(queryFragments);
        String tableName = this.getPreparedTableNames(queryFragments);
        FlatFileDataReader ffdsr = new FlatFileDataReader(this.connProperties, tableName, 0, null, null);
        String[] allColumnNames = this.hasColumnNames ? this.discoverActualColumnMetaData(tableName, NAME_LITERAL) : this.createTempColumnNames(ffdsr.getColumnCount());
        String[] stringArray = allColumnTypes = this.hasTypeLine ? this.discoverActualColumnMetaData(tableName, TYPE_LITERAL) : this.createTempColumnTypes(ffdsr.getColumnCount());
        if (allColumnNames.length != allColumnTypes.length) {
            throw new OdaException(Messages.getString("invalid_flatfile_format"));
        }
        String[] queryColumnNames = null;
        String[] queryColumnTypes = null;
        String[] queryColumnLables = null;
        if (this.isWildCard(this.getPreparedColumnNames(queryFragments))) {
            queryColumnNames = allColumnNames;
            queryColumnTypes = allColumnTypes;
            queryColumnLables = allColumnNames;
            this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(queryColumnNames, queryColumnTypes, queryColumnLables);
            this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
        } else {
            queryColumnNames = FlatFileDataReader.getStringArrayFromList(this.stripFormatInfoFromQueryColumnNames(this.getQueryColumnNamesVector(this.getPreparedColumnNames(queryFragments))));
            this.validateColumnName(queryColumnNames, allColumnNames);
            if (savedSelectedColInfo == null || savedSelectedColInfo.length() == 0) {
                queryColumnTypes = this.hasTypeLine ? this.getQueryColumnTypes(allColumnNames, allColumnTypes, queryColumnNames) : this.createTempColumnTypes(queryColumnNames.length);
                String[] stringArray2 = queryColumnLables = this.hasColumnNames ? this.getColumnLabels(queryFragments) : queryColumnNames;
                if (queryColumnLables == null) {
                    queryColumnLables = queryColumnNames;
                }
                this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(queryColumnNames, queryColumnTypes, queryColumnLables);
                this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
            } else {
                this.resultSetMetaDataHelper = new ResultSetMetaDataHelper(savedSelectedColInfo);
                this.resultSetMetaData = new ResultSetMetaData(this.resultSetMetaDataHelper);
            }
        }
        this.currentTableName = tableName;
    }

    private String[] getQueryColumnTypes(String[] allColumnNames, String[] allColumnTypes, String[] queryColumnNames) {
        if (!this.hasTypeLine) {
            return null;
        }
        String[] queryColumnTypes = new String[queryColumnNames.length];
        int i = 0;
        while (i < queryColumnNames.length) {
            int j = 0;
            while (j < allColumnNames.length) {
                if (queryColumnNames[i].trim().equalsIgnoreCase(allColumnNames[j])) {
                    queryColumnTypes[i] = allColumnTypes[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return queryColumnTypes;
    }

    private String[] getColumnLabels(String[] queryFragments) {
        String queryColumnLabels = this.getPreparedColumnLabels(queryFragments);
        return queryColumnLabels != null ? queryColumnLabels.split(",") : null;
    }

    private String formatQueryText(String queryText) {
        StringBuffer result = new StringBuffer();
        String[] temp = queryText.trim().split(" ");
        int i = 0;
        while (i < temp.length) {
            if (temp[i].equalsIgnoreCase("AS")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("FROM")) {
                temp[i] = temp[i].toUpperCase();
            }
            if (temp[i].equalsIgnoreCase("SELECT")) {
                temp[i] = temp[i].toUpperCase();
            }
            result.append(temp[i]).append(" ");
            ++i;
        }
        return result.toString().trim();
    }

    public static class FlatFileBufferedReader {
        private Reader reader;
        private char[] charBuffer;
        private static int CHARBUFFSIZE = 8192;
        private char separator;
        private int endIndex;
        private int currentIndex;

        public FlatFileBufferedReader(InputStream in, String encoding, char seperator) throws IOException {
            this.initReader(in, encoding);
            this.separator = seperator;
            this.endIndex = -1;
            this.currentIndex = -1;
            this.charBuffer = new char[CHARBUFFSIZE];
        }

        private void initReader(InputStream in, String encoding) throws IOException {
            if ("UTF-8".equals(encoding)) {
                PushbackInputStream internalInputStream = new PushbackInputStream(in, 3);
                byte[] bom = new byte[3];
                int len = internalInputStream.read(bom);
                if ((len != 3 || bom[0] != -17 || bom[1] != -69 || bom[2] != -65) && len > 0) {
                    internalInputStream.unread(bom, 0, len);
                }
                this.reader = new BufferedReader(new InputStreamReader((InputStream)internalInputStream, encoding));
            } else {
                this.reader = new BufferedReader(new InputStreamReader(in, encoding));
            }
        }

        public List readLine() throws OdaException, IOException {
            int newLineStartIndex = this.currentIndex + 1;
            StringBuffer column = new StringBuffer();
            boolean doubleQuoted = false;
            if (!this.next()) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            do {
                char curChar = this.getChar();
                if (!doubleQuoted) {
                    if (curChar == this.separator) {
                        result.add(this.getColumnValue(column));
                        column.setLength(0);
                        continue;
                    }
                    if (curChar == '\"') {
                        if (column.toString().trim().length() > 0) {
                            throw new OdaException(Messages.getString("invalid_flatfile_format"));
                        }
                        doubleQuoted = true;
                        column.setLength(0);
                        column.append('\"');
                        continue;
                    }
                    if (curChar == '\n') {
                        if (this.currentIndex != newLineStartIndex) {
                            result.add(this.getColumnValue(column));
                        }
                        return result;
                    }
                    column.append(curChar);
                    continue;
                }
                this.moveToEndQuotation(column);
                this.moveToEndOfColumn();
                doubleQuoted = false;
            } while (this.next());
            result.add(this.getColumnValue(column));
            return result;
        }

        private void moveToEndOfColumn() throws IOException, OdaException {
            if (this.next()) {
                char curChar = this.getChar();
                if (curChar == this.separator || curChar == '\n') {
                    this.back();
                    return;
                }
                if (this.isAnEmptyChar(curChar)) {
                    this.moveToEndOfColumn();
                } else {
                    throw new OdaException(Messages.getString("invalid_flatfile_format"));
                }
            }
        }

        private void moveToEndQuotation(StringBuffer column) throws IOException, OdaException {
            char curChar = this.getChar();
            if (curChar == '\"') {
                if (this.next()) {
                    curChar = this.getChar();
                    if (curChar == '\"') {
                        column.append('\"');
                        if (this.next()) {
                            this.moveToEndQuotation(column);
                            return;
                        }
                        throw new OdaException(Messages.getString("invalid_flatfile_format"));
                    }
                    this.back();
                }
                column.append('\"');
                return;
            }
            column.append(curChar);
            if (!this.next()) {
                throw new OdaException(Messages.getString("invalid_flatfile_format"));
            }
            this.moveToEndQuotation(column);
        }

        private boolean next() throws IOException {
            if (this.currentIndex < this.endIndex) {
                ++this.currentIndex;
                return true;
            }
            int len = this.reader.read(this.charBuffer);
            if (len <= 0) {
                return false;
            }
            this.currentIndex = 0;
            this.endIndex = len - 1;
            return true;
        }

        private void back() {
            if (this.currentIndex >= 0) {
                --this.currentIndex;
            }
        }

        private char getChar() {
            return this.charBuffer[this.currentIndex];
        }

        private String getColumnValue(StringBuffer column) {
            if (column.length() >= 2 && column.charAt(0) == '\"' && column.charAt(column.length() - 1) == '\"') {
                return column.substring(1, column.length() - 1);
            }
            return column.toString().trim();
        }

        private boolean isAnEmptyChar(char c) {
            return String.valueOf(c).trim().equals("");
        }

        public void close() throws IOException {
            this.charBuffer = null;
            this.reader.close();
        }
    }
}

