/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.RepositoriesDropList;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportProfilesDialog
extends TrayDialog
implements IContextProvider {
    private Text txtFile;
    private Button mLocalRepository;
    private RepositoriesDropList mRepositories;
    private Button btnOverwrite;
    private Throwable mException;
    private IConnectionProfile[] mProfiles;
    private boolean mOverwrite;
    private boolean mUseLocalRepository;
    private IConnectionProfile mRepository;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public ImportProfilesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(80);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Text text = new Text(container, 2122);
        text.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.text.text"));
        GridData gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 3;
        text.setLayoutData((Object)gridData);
        Label label = new Label(container, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 495;
        label.setLayoutData((Object)gridData);
        label = new Label(container, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.label.text"));
        this.txtFile = new Text(container, 2048);
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = 243;
        this.txtFile.setLayoutData((Object)gridData2);
        Button button = new Button(container, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = new FileDialog(ImportProfilesDialog.this.getShell()).open();
                if (text != null) {
                    ImportProfilesDialog.this.txtFile.setText(text);
                }
            }
        });
        button.setLayoutData((Object)new GridData(64));
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.button.text"));
        this.btnOverwrite = new Button(container, 32);
        gridData2 = new GridData(512);
        gridData2.horizontalIndent = 10;
        gridData2.horizontalSpan = 3;
        this.btnOverwrite.setLayoutData((Object)gridData2);
        this.btnOverwrite.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.btnOverwrite.text"));
        Label spacer = new Label(container, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 20;
        gd.horizontalSpan = 3;
        spacer.setLayoutData((Object)gd);
        Label separator = new Label(container, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        separator.setLayoutData((Object)gd);
        this.mLocalRepository = new Button(container, 32);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.mLocalRepository.setLayoutData((Object)gd);
        this.mLocalRepository.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.localRepository"));
        this.mUseLocalRepository = true;
        this.mLocalRepository.setSelection(this.mUseLocalRepository);
        this.mLocalRepository.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportProfilesDialog.this.mUseLocalRepository = ImportProfilesDialog.this.mLocalRepository.getSelection();
                ImportProfilesDialog.this.mRepositories.getCombo().setEnabled(!ImportProfilesDialog.this.mUseLocalRepository);
            }
        });
        Label label2 = new Label(container, 0);
        label2.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.chooseRepository"));
        this.mRepositories = new RepositoriesDropList(null, container);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mRepositories.getCombo().setLayoutData((Object)gd);
        this.mRepositories.setInput(ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"));
        this.mRepositories.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    ImportProfilesDialog.this.mRepository = null;
                } else {
                    ImportProfilesDialog.this.mRepository = (IConnectionProfile)((IStructuredSelection)selection).getFirstElement();
                }
            }
        });
        this.mRepositories.getCombo().setEnabled(!this.mLocalRepository.getSelection());
        if (!this.mRepositories.hasRepositories()) {
            this.mLocalRepository.setEnabled(false);
            this.mLocalRepository.setVisible(false);
            label2.setVisible(false);
            separator.setVisible(false);
            this.mRepositories.getCombo().setVisible(false);
        }
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_IMPORT_PROFILES_DIALOG", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.null.title"));
    }

    public Throwable getException() {
        return this.mException;
    }

    public IConnectionProfile[] getProfiles() {
        return this.mProfiles;
    }

    public boolean isOverwritten() {
        return this.mOverwrite;
    }

    public boolean getUseLocalRepository() {
        return this.mUseLocalRepository;
    }

    public IConnectionProfile getSelectedRepository() {
        return this.mRepository;
    }

    protected void okPressed() {
        if (this.txtFile.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.nofile"));
            return;
        }
        if (!this.mUseLocalRepository && this.mRepository == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.norepository"));
            return;
        }
        this.mOverwrite = this.btnOverwrite.getSelection();
        try {
            byte[] bytes = new byte[5];
            char[] xml = new char[]{'<', '?', 'x', 'm', 'l'};
            FileInputStream fis = new FileInputStream(this.txtFile.getText());
            fis.read(bytes);
            fis.close();
            boolean isXML = true;
            int i = 0;
            while (isXML && i < 5) {
                isXML = bytes[i] == xml[i];
                ++i;
            }
            this.mProfiles = isXML ? ConnectionProfileMgmt.importCPs((File)new File(this.txtFile.getText()), null, (boolean)this.mOverwrite) : ConnectionProfileMgmt.importCPs((File)new File(this.txtFile.getText()), (ICipherProvider)SecurityManager.getInstance().getDefaultCipherProvider(), (boolean)this.mOverwrite);
        }
        catch (Exception e) {
            this.mException = e;
        }
        super.okPressed();
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

