/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers.models;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.IDriverValuesProvider;
import org.eclipse.datatools.connectivity.drivers.models.MySafeRunnable;
import org.eclipse.datatools.connectivity.drivers.models.OverridesPriorityComparator;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class OverrideTemplateDescriptor
implements Comparable {
    public static final String TEMPLATE_TAG = "driverExtension";
    public static final String PLUGIN_LOC = "\\[\\%PLUGIN_LOC\\%\\]";
    private static final String EXTENSION_POINT_NAME = "driverExtension";
    private static final String OVERRIDE_DRIVERTEMPLATE_ELEMENT_TAG = "driverTemplateOverride";
    private static final String OVERRIDE_PROPERTIES_ELEMENT_TAG = "propertyOverrides";
    private static final String OVERRIDE_PROPERTY_ELEMENT_TAG = "propertyOverride";
    private static final String CREATEDEFAULT_TAG = "createDefault";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PARENTCATEGORY_ATTRIBUTE = "parentCategory";
    private static final String JARLIST_ATTRIBUTE = "jarList";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String EMPTYJARLISTOK_TAG = "emptyJarListIsOK";
    private static final String VISIBLE_ATTRIBUTE = "visible";
    private static final String REMOVE_ATTRIBUTE = "remove";
    private static final String EXAMPLE_ATTRIBUTE = "example";
    private static final String REQUIRED_ATTRIBUTE = "required";
    private static final String CATEGORY_ATTRIBUTE = "category";
    private static final String CUSTOM_PROP_DESCRIPTOR_ATTRIBUTE = "customPropertyDescriptor";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String VALUESPROVIDER_ATTRIBUTE = "valuesProvider";
    private static final String DEFAULT_DEFINITION_NAME_ATTRIBUTE = "defaultDefinitionName";
    private IDriverValuesProvider driverValuesProvider = null;
    private static final OverrideTemplateDescriptor[] EMPTY = new OverrideTemplateDescriptor[0];
    private static Map fgDriverTemplateDescriptors;
    private static Map fgDriverTemplateOverrideDescriptorIDMap;
    private IConfigurationElement fElement;

    protected OverrideTemplateDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getTargetId(), (String)DriverMgmtMessages.getString("TemplateDescriptor.msg.id_missing"));
    }

    public static OverrideTemplateDescriptor[] getByDriverTemplate(String driverTemplateId) {
        List descriptors;
        if (fgDriverTemplateDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), "driverExtension");
            OverrideTemplateDescriptor.createDriverTemplateDescriptors(elements);
        }
        if ((descriptors = (List)fgDriverTemplateDescriptors.get(driverTemplateId)) != null && descriptors.size() > 0) {
            Iterator iter = descriptors.iterator();
            ArrayList<OverrideTemplateDescriptor> finalList = new ArrayList<OverrideTemplateDescriptor>();
            while (iter.hasNext()) {
                OverrideTemplateDescriptor otd = (OverrideTemplateDescriptor)iter.next();
                if (otd.getId() != null) {
                    List overrides = (List)fgDriverTemplateDescriptors.get(otd.getId());
                    if (overrides != null) {
                        OverrideTemplateDescriptor[] overridesArray = overrides.toArray(new OverrideTemplateDescriptor[descriptors.size()]);
                        Arrays.sort(overridesArray, new OverridesPriorityComparator());
                        finalList.add(overridesArray[0]);
                        continue;
                    }
                    finalList.add(otd);
                    continue;
                }
                finalList.add(otd);
            }
            Object[] array = finalList.toArray(new OverrideTemplateDescriptor[finalList.size()]);
            Arrays.sort(array);
            return array;
        }
        return EMPTY;
    }

    public static OverrideTemplateDescriptor[] getOverrideDriverTemplateDescriptors() {
        if (fgDriverTemplateDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), "driverExtension");
            OverrideTemplateDescriptor.createDriverTemplateDescriptors(elements);
        }
        return fgDriverTemplateDescriptors.values().toArray(new OverrideTemplateDescriptor[fgDriverTemplateDescriptors.size()]);
    }

    public String getTargetId() {
        return this.fElement.getAttribute(TARGET_ID_ATTRIBUTE);
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public int getPriority() {
        String value = this.fElement.getAttribute(PRIORITY_ATTRIBUTE);
        if (value == null) {
            return 1;
        }
        try {
            int valueInt = Integer.parseInt(value);
            return valueInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    public String getParentCategory() {
        return this.fElement.getAttribute(PARENTCATEGORY_ATTRIBUTE);
    }

    public String getJarList() {
        String jarList = this.fElement.getAttribute(JARLIST_ATTRIBUTE);
        if (jarList == null) {
            jarList = new String();
        }
        if (!jarList.matches(".*\\[\\%PLUGIN_LOC\\%\\].*")) {
            return jarList;
        }
        try {
            String pluginID = this.fElement.getContributor().getName();
            String pluginLoc = FileLocator.resolve((URL)Platform.getBundle((String)pluginID).getEntry("")).getFile();
            if (pluginLoc.charAt(0) == '/') {
                pluginLoc = pluginLoc.substring(1);
            }
            if (pluginLoc.charAt(pluginLoc.length() - 1) == '/') {
                pluginLoc = pluginLoc.substring(0, pluginLoc.length() - 1);
            }
            jarList = jarList.replaceAll(PLUGIN_LOC, pluginLoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jarList;
    }

    public IDriverValuesProvider getValuesProviderClass() {
        if (this.fElement.getAttribute(VALUESPROVIDER_ATTRIBUTE) != null && this.driverValuesProvider == null) {
            try {
                this.driverValuesProvider = (IDriverValuesProvider)this.fElement.createExecutableExtension(VALUESPROVIDER_ATTRIBUTE);
                this.driverValuesProvider.setDriverTemplate(TemplateDescriptor.getDriverTemplateDescriptor(this.getTargetId()));
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.driverValuesProvider;
    }

    public String getCreateDefaultFlag() {
        if (this.fElement.getAttribute(CREATEDEFAULT_TAG) != null) {
            return this.fElement.getAttribute(CREATEDEFAULT_TAG);
        }
        return null;
    }

    public String getEmptyJarListIsOKFlag() {
        if (this.fElement.getAttribute(EMPTYJARLISTOK_TAG) != null) {
            return this.fElement.getAttribute(EMPTYJARLISTOK_TAG);
        }
        return null;
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        return name;
    }

    public boolean getRemoveFlag() {
        String name = this.fElement.getAttribute(REMOVE_ATTRIBUTE);
        return name != null && name.trim().equalsIgnoreCase(Boolean.toString(true));
    }

    public String getDefaultDefinitionName() {
        String defaultDefinitionName = this.fElement.getAttribute(DEFAULT_DEFINITION_NAME_ATTRIBUTE);
        if (defaultDefinitionName == null && this.getName() != null) {
            defaultDefinitionName = this.getName();
        }
        return defaultDefinitionName;
    }

    public IConfigurationElement[] getOverrideProperties() {
        IConfigurationElement[] propertyRoot = this.fElement.getChildren(OVERRIDE_PROPERTIES_ELEMENT_TAG);
        if (propertyRoot != null && propertyRoot.length == 1) {
            IConfigurationElement[] childElements = propertyRoot[0].getChildren(OVERRIDE_PROPERTY_ELEMENT_TAG);
            return childElements;
        }
        return new IConfigurationElement[0];
    }

    public String getPropertyValueFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, VALUE_ATTRIBUTE);
    }

    public String getPropertyNameFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, NAME_ATTRIBUTE);
    }

    public String getPropertyIDFromName(String propName) {
        return this.getPropertyAttributeValueByName(propName, TARGET_ID_ATTRIBUTE);
    }

    public String getPropertyDescriptionFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, DESCRIPTION_ATTRIBUTE);
    }

    public String getPropertyVisibleFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, VISIBLE_ATTRIBUTE);
    }

    public String getPropertyExampleFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, EXAMPLE_ATTRIBUTE);
    }

    public String getPropertyRequiredFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, REQUIRED_ATTRIBUTE);
    }

    public String getPropertyCustomPropDescriptorFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, CUSTOM_PROP_DESCRIPTOR_ATTRIBUTE);
    }

    public String getPropertyCategoryFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, CATEGORY_ATTRIBUTE);
    }

    public boolean getPropertyRemoveFlagFromID(String propId) {
        String removeStr = this.getPropertyAttributeValueByID(propId, REMOVE_ATTRIBUTE);
        if (removeStr != null) {
            Boolean flag = Boolean.valueOf(removeStr);
            return flag;
        }
        return false;
    }

    public String getPropertyNameFromConfigElement(IConfigurationElement element) {
        if (element.getAttribute(NAME_ATTRIBUTE) != null) {
            return element.getAttribute(NAME_ATTRIBUTE);
        }
        return "";
    }

    private String getPropertyAttributeValueByName(String propName, String attribute) {
        String attr_value = new String();
        IConfigurationElement[] props = this.getOverrideProperties();
        int i = 0;
        while (i < props.length) {
            if (props[i].getAttribute(NAME_ATTRIBUTE) != null && propName.equals(props[i].getAttribute(NAME_ATTRIBUTE))) {
                attr_value = props[i].getAttribute(attribute);
                break;
            }
            ++i;
        }
        return attr_value;
    }

    private String getPropertyAttributeValueByID(String propId, String attribute) {
        String attr_value = new String();
        IConfigurationElement[] props = this.getOverrideProperties();
        int i = 0;
        while (i < props.length) {
            if (props[i].getAttribute(TARGET_ID_ATTRIBUTE) != null && propId.equals(props[i].getAttribute(TARGET_ID_ATTRIBUTE))) {
                attr_value = props[i].getAttribute(attribute);
                break;
            }
            ++i;
        }
        return attr_value;
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public int compareTo(Object o) {
        if (o instanceof OverrideTemplateDescriptor) {
            return ((OverrideTemplateDescriptor)o).getPriority() - this.getPriority();
        }
        return Integer.MIN_VALUE;
    }

    private static void createDriverTemplateDescriptors(IConfigurationElement[] elements) {
        fgDriverTemplateDescriptors = new HashMap();
        fgDriverTemplateOverrideDescriptorIDMap = new HashMap();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (OVERRIDE_DRIVERTEMPLATE_ELEMENT_TAG.equals(element.getName())) {
                OverrideTemplateDescriptor[] desc = new OverrideTemplateDescriptor[1];
                SafeRunner.run((ISafeRunnable)new MySafeRunnable(desc, element));
                if (desc[0] != null) {
                    ArrayList<OverrideTemplateDescriptor> descriptors = (ArrayList<OverrideTemplateDescriptor>)fgDriverTemplateDescriptors.get(desc[0].getTargetId());
                    if (descriptors == null) {
                        descriptors = new ArrayList<OverrideTemplateDescriptor>(1);
                        fgDriverTemplateDescriptors.put(desc[0].getTargetId(), descriptors);
                    }
                    descriptors.add(desc[0]);
                }
            }
            ++i;
        }
    }

    public boolean hasVisibleProperties() {
        IConfigurationElement[] templateprops = this.getOverrideProperties();
        if (templateprops != null && templateprops.length > 0) {
            int i = 0;
            while (i < templateprops.length) {
                IConfigurationElement prop = templateprops[i];
                String visible = prop.getAttribute(VISIBLE_ATTRIBUTE);
                if (visible == null || visible.equals(Boolean.toString(true))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OverrideTemplateDescriptor) {
            OverrideTemplateDescriptor compare = (OverrideTemplateDescriptor)obj;
            return this.getTargetId().equals(compare.getTargetId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getTargetId() != null) {
            return this.getTargetId().hashCode();
        }
        return super.hashCode();
    }
}

