/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder;

import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.EditComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class ExpressionsComboBoxCellEditor
extends EditComboBoxCellEditor {
    public static String ADDFUNCTION = Messages._UI_COMBO_ADDFUNCTION;
    public static String ADDCASE = Messages._UI_COMBO_ADDCASE;
    public static String ADDCAST = Messages._UI_COMBO_ADDCAST;
    public static String ADDCONSTANT = Messages._UI_COMBO_ADDCONSTANT;
    public static String SELECTSUBQUERY = Messages._UI_COMBO_SELECTSUBQUERY;
    public static String ADDEXPRBYOPERATOR = Messages._UI_COMBO_ADDEXPRBYOPERATOR;
    private boolean includeFunction = true;
    private boolean includeCase = true;
    private boolean includeCast = true;
    private boolean includeConstant = true;
    private boolean includeSubQuery = true;
    private boolean includeExprByOperator = true;
    private QueryStatement sqlStatement;
    private LabelValuePair[] expressionsArray;
    private Vector firstItems;

    public ExpressionsComboBoxCellEditor(Composite parent, QueryStatement sqlStmt) {
        super(parent, null, true);
        this.sqlStatement = sqlStmt;
        this.firstItems = null;
    }

    public ExpressionsComboBoxCellEditor(Composite parent, QueryStatement sqlStmt, Vector firstItems) {
        super(parent, null, true);
        this.sqlStatement = sqlStmt;
        this.firstItems = firstItems;
    }

    public void includeFunction(boolean includeIt) {
        this.includeFunction = includeIt;
    }

    public void includeCase(boolean includeIt) {
        this.includeCase = includeIt;
    }

    public void includeCast(boolean includeIt) {
        this.includeCast = includeIt;
    }

    public void includeConstant(boolean includeIt) {
        this.includeConstant = includeIt;
    }

    public void includeSubQuery(boolean includeIt) {
        this.includeSubQuery = includeIt;
    }

    public void includeExprByOperator(boolean includeIt) {
        this.includeExprByOperator = includeIt;
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
    }

    protected LabelValuePair createComboBoxItem(String newValue) {
        return new LabelValuePair(newValue, ExpressionHelper.createExpression(newValue));
    }

    public void fillItems() {
        Vector<LabelValuePair> availableExpressionsComboBoxItemsVector = new Vector<LabelValuePair>();
        Vector<String> availableExpressionsVector = new Vector<String>();
        if (this.sqlStatement != null) {
            availableExpressionsVector.addAll(BuilderUtility.getColumnVector((SQLQueryObject)this.sqlStatement));
        } else {
            availableExpressionsVector = new Vector();
        }
        if (this.firstItems != null) {
            availableExpressionsVector.addAll(0, this.firstItems);
        }
        if (this.includeFunction) {
            availableExpressionsVector.add(ADDFUNCTION);
        }
        if (this.includeCase) {
            availableExpressionsVector.add(ADDCASE);
        }
        if (this.includeCast) {
            availableExpressionsVector.add(ADDCAST);
        }
        if (this.includeConstant) {
            availableExpressionsVector.add(ADDCONSTANT);
        }
        if (this.includeSubQuery) {
            availableExpressionsVector.add(SELECTSUBQUERY);
        }
        if (this.includeExprByOperator) {
            availableExpressionsVector.add(ADDEXPRBYOPERATOR);
        }
        int i = 0;
        while (i < availableExpressionsVector.size()) {
            if (availableExpressionsVector.elementAt(i) instanceof QueryValueExpression) {
                availableExpressionsComboBoxItemsVector.addElement(new LabelValuePair(availableExpressionsVector.elementAt(i).toString(), availableExpressionsVector.elementAt(i)));
            } else if (availableExpressionsVector.elementAt(i) instanceof String) {
                availableExpressionsComboBoxItemsVector.addElement(new LabelValuePair(availableExpressionsVector.elementAt(i).toString(), availableExpressionsVector.elementAt(i)));
            }
            ++i;
        }
        this.expressionsArray = new LabelValuePair[availableExpressionsComboBoxItemsVector.size()];
        availableExpressionsComboBoxItemsVector.copyInto(this.expressionsArray);
        this.createItems(this.expressionsArray);
    }
}

