/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor;

import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.QuickDataTypeParser;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DataTypeStringParser;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;

public class DataTypeProviderExt
extends DataTypeProvider {
    protected DataTypeStringParser getDataTypeStringParser() {
        return new QuickDataTypeParser();
    }

    public DataType getDataType(String typeString, Schema schema, int context, DatabaseIdentifier databaseIdentifier, boolean refresh) {
        if (refresh && schema != null) {
            List schemas = null;
            if (schema.getCatalog() != null && schema.getCatalog().getSchemas() != null) {
                schemas = schema.getCatalog().getSchemas();
            }
            if (schemas == null && schema.getDatabase() != null && schema.getDatabase().getSchemas() != null) {
                schemas = schema.getDatabase().getSchemas();
            }
            if (schemas != null) {
                for (Object obj : schemas) {
                    if (!(obj instanceof ICatalogObject)) continue;
                    ((ICatalogObject)obj).refresh();
                }
            }
        }
        return this.getDataType(typeString, schema, context, databaseIdentifier);
    }

    public DataType getDataType(String typeString, Schema schema, int context, DatabaseIdentifier databaseIdentifier) {
        DataType dType = super.getDataType(typeString, schema, context, databaseIdentifier);
        if (dType == null) {
            return null;
        }
        if (!(dType instanceof PredefinedDataType)) {
            return dType;
        }
        PredefinedDataType pdType = (PredefinedDataType)dType;
        PredefinedDataTypeDefinition typeDef = this.getPredefinedDataTypeDefinition(pdType);
        if (typeDef == null) {
            return dType;
        }
        DataTypeStringParser parser = this.getDataTypeStringParser();
        String[] typeInfo = parser.parseDatatype(typeString);
        if (typeInfo.length == 1) {
            return dType;
        }
        if (typeInfo.length == 2 && !typeDef.isLengthSupported() && !typeDef.isPrecisionSupported()) {
            return null;
        }
        if (typeInfo.length == 3 && !typeDef.isScaleSupported()) {
            return null;
        }
        if (typeInfo.length > 3) {
            return null;
        }
        return dType;
    }

    public String getDataTypeString(DataType dataType, DatabaseIdentifier databaseIdentifier) {
        if (dataType == null) {
            return "";
        }
        DatabaseDefinition def = this.getDbDefinition();
        if (dataType instanceof PredefinedDataType) {
            return def.getPredefinedDataTypeFormattedName((PredefinedDataType)dataType);
        }
        if (dataType instanceof UserDefinedType) {
            String quote;
            String string = quote = SQLDevToolsUtil.isQuotedIdentifierOn((DatabaseIdentifier)databaseIdentifier) ? "\"" : "'";
            if (dataType.getName().contains("\"")) {
                return SQLUtil.quote(dataType.getName(), quote);
            }
            String typeName = SQLDevToolsUtil.quoteWhenNecessary((String)dataType.getName(), (DatabaseIdentifier)databaseIdentifier, (String)quote);
            return typeName;
        }
        return null;
    }
}

