/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class DatabaseHelper {
    public static List getTableList(Database database) {
        ArrayList tempList = new ArrayList();
        if (database != null) {
            List sList = DatabaseHelper.getSchemaList(database);
            for (Schema lSchema : sList) {
                tempList.addAll(DatabaseHelper.getTableList(lSchema));
            }
        }
        return tempList;
    }

    public static List getTableList(Schema schema) {
        ArrayList<Table> tempList = new ArrayList<Table>();
        if (schema != null) {
            EList tList = schema.getTables();
            for (Table table : tList) {
                tempList.add(table);
            }
        }
        return tempList;
    }

    public static List getSchemaList(Database database) {
        ArrayList tempList = new ArrayList();
        if (database != null && database.getSchemas() != null && database.getSchemas().size() > 0) {
            tempList.addAll(database.getSchemas());
        } else if (database != null && database.getCatalogs() != null && database.getCatalogs().size() > 0) {
            EList catalogs = database.getCatalogs();
            for (Catalog catalog : catalogs) {
                catalog.getName();
                if (catalog.getSchemas() == null || catalog.getSchemas().size() <= 0) continue;
                tempList.addAll(catalog.getSchemas());
            }
        }
        return tempList;
    }
}

