/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.IDriverInstancePropertyDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.drivers.DriverClassEditDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DriverClassBrowsePropertyDescriptor
extends TextPropertyDescriptor
implements IDriverInstancePropertyDescriptor {
    private static String DRIVER_CLASS_PROP_ID = "org.eclipse.datatools.connectivity.db.driverClass";
    private String[] mJarList = null;

    public DriverClassBrowsePropertyDescriptor() {
        super((Object)DRIVER_CLASS_PROP_ID, ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.property.label"));
    }

    public DriverClassBrowsePropertyDescriptor(Object id, String displayName, String[] jarList) {
        super(id, displayName);
        this.mJarList = jarList;
    }

    public DriverClassBrowsePropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public void setJarList(String[] jarList) {
        this.mJarList = jarList;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        DriverClassDialogCellEditor editor = new DriverClassDialogCellEditor(parent);
        return editor;
    }

    public void setDriverInstance(DriverInstance instance) {
        this.mJarList = instance.getJarListAsArray();
    }

    private class DriverClassDialogCellEditor
    extends DialogCellEditor {
        public DriverClassDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Object[] results;
            DriverClassEditDialog listDialog = new DriverClassEditDialog(cellEditorWindow.getShell());
            listDialog.setJarList(DriverClassBrowsePropertyDescriptor.this.mJarList);
            listDialog.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.jardialog.title"));
            listDialog.setMessage(ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.jardialog.msg"));
            listDialog.setHelpAvailable(false);
            listDialog.setInput(this.getValue());
            int returnCode = listDialog.open();
            if (returnCode == 0 && (results = listDialog.getResult()).length > 0 && results[0] instanceof String) {
                return results[0];
            }
            return null;
        }
    }
}

