/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tabledataeditor.actions;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.ISQLObjectNameHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.IExternalRunQuery;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.query.execute.QueryOutputHelper;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.util.ResourceLoader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SampleContentAction
extends AbstractAction {
    private static final String TEXT = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.DATA.SAMPCONTENTS");
    private final String SQ = "'";
    private final String SQ2 = "`";
    private final String DQ = "\"";
    private final String SPACE = " ";
    private String quote = "";
    private static final String EXTERNAL_RUN_QUERY = "org.eclipse.datatools.sqltools.tabledataeditor.externalRunQuery";
    private static final String EXTERNAL_RUN_QUERY_VENDOR = "vendor";
    private static final String EXTERNAL_RUN_QUERY_CLASS = "class";
    private static final String EXTERNAL_SQL_OBJECT_NAME_HELPER = "org.eclipse.datatools.modelbase.sql.sqlObjectNameHelper";
    private static final String EXTERNAL_SQL_OBJECT_NAME_HELPER_DBTYPE = "databaseType";
    private static final String EXTERNAL_SQL_OBJECT_NAME_HELPER_CLASS = "class";

    private String wrapName(String name) {
        if (this.quote.equals("'") || this.quote.equals("`")) {
            return String.valueOf(this.quote) + SampleContentAction.doubleStringDelim(name, this.quote) + this.quote;
        }
        if (" ".equals(this.quote)) {
            return SampleContentAction.doubleStringDelim(name, " ");
        }
        return "\"" + SampleContentAction.doubleStringDelim(name, "\"") + "\"";
    }

    private String getFullyQualifiedName(Table table) {
        Database db = table.getSchema().getCatalog() != null ? table.getSchema().getCatalog().getDatabase() : table.getSchema().getDatabase();
        RDBCorePlugin plugin = RDBCorePlugin.getDefault();
        DatabaseDefinition dbDefinition = plugin.getDatabaseDefinitionRegistry().getDefinition(db);
        if (dbDefinition.supportsSchema()) {
            return String.valueOf(this.wrapName(table.getSchema().getName())) + "." + this.wrapName(table.getName());
        }
        return this.wrapName(table.getName());
    }

    private Database getDatabase(Schema schema) {
        return schema.getCatalog() == null ? schema.getDatabase() : schema.getCatalog().getDatabase();
    }

    private ISQLObjectNameHelper getSQLObjectNameHelper(Database database) {
        ISQLObjectNameHelper nameHelper = null;
        if (database != null) {
            String currentDBVendor = database.getVendor();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint nameHandlerExtensionPoint = extensionRegistry.getExtensionPoint(EXTERNAL_SQL_OBJECT_NAME_HELPER);
            IExtension[] nameHandlerExtensions = nameHandlerExtensionPoint.getExtensions();
            int i = 0;
            while (i < nameHandlerExtensions.length && nameHelper == null) {
                IExtension ext = nameHandlerExtensions[i];
                IConfigurationElement[] configElements = ext.getConfigurationElements();
                int j = 0;
                while (j < configElements.length && nameHelper == null) {
                    String extVendor = configElements[j].getAttribute(EXTERNAL_SQL_OBJECT_NAME_HELPER_DBTYPE);
                    if (currentDBVendor.equalsIgnoreCase(extVendor)) {
                        try {
                            Object executableExtension = configElements[j].createExecutableExtension("class");
                            if (executableExtension instanceof ISQLObjectNameHelper) {
                                nameHelper = (ISQLObjectNameHelper)executableExtension;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++j;
                }
                ++i;
            }
        }
        return nameHelper;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (event.getSelection() instanceof IStructuredSelection) {
            Object[] sel = ((IStructuredSelection)event.getSelection()).toArray();
            if (sel == null || sel.length > 1) {
                this.setEnabled(false);
                return;
            }
            if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof EObject) {
                EObject o = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
                String groupID = containmentService.getGroupId(o);
                this.setEnabled(groupID != null && groupID.startsWith("core."));
            }
        }
    }

    public void initialize() {
        ImageDescriptor descriptor = ImageDescription.getSampleContent();
        this.initializeAction(descriptor, descriptor, TEXT, TEXT);
    }

    public void run() {
        this.quote = "\"";
        Connection connection = null;
        if (!this.event.getSelection().isEmpty()) {
            Iterator iter = ((IStructuredSelection)this.event.getSelection()).iterator();
            String selectString = "";
            Object selectedObj = iter.next();
            Database database = null;
            if (selectedObj instanceof Table) {
                Table table = (Table)selectedObj;
                database = this.getDatabase(table.getSchema());
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                try {
                    this.quote = connection.getMetaData().getIdentifierQuoteString();
                }
                catch (Exception exception) {}
                String tableName = null;
                ISQLObjectNameHelper nameProvider = this.getSQLObjectNameHelper(database);
                if (nameProvider != null) {
                    nameProvider.setIdentifierQuoteString(this.quote);
                    tableName = nameProvider.getQualifiedNameInSQLFormat(table);
                }
                if (tableName == null) {
                    tableName = this.getFullyQualifiedName(table);
                }
                selectString = String.valueOf(selectString) + "SELECT * FROM " + tableName;
            } else if (selectedObj instanceof Column) {
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                try {
                    this.quote = connection.getMetaData().getIdentifierQuoteString();
                }
                catch (Exception exception) {}
                Column column = (Column)selectedObj;
                String columnName = column.getName();
                database = this.getDatabase(column.getTable().getSchema());
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                DataType datatype = column.getDataType();
                if (datatype instanceof DistinctUserDefinedType) {
                    datatype = ((DistinctUserDefinedType)datatype).getPredefinedRepresentation();
                }
                PredefinedDataTypeDefinition datatypeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(datatype.getName());
                Table table = column.getTable();
                String tableName = null;
                ISQLObjectNameHelper nameProvider = this.getSQLObjectNameHelper(database);
                if (nameProvider != null) {
                    tableName = nameProvider.getQualifiedNameInSQLFormat(table);
                }
                if (tableName == null) {
                    tableName = this.getFullyQualifiedName(table);
                }
                if (datatypeDefinition.isOrderingSupported() && datatypeDefinition.isGroupingSupported()) {
                    selectString = String.valueOf(selectString) + "SELECT DISTINCT " + this.wrapName(columnName) + " , COUNT(*) AS OCCURRENCE";
                    selectString = String.valueOf(selectString) + " FROM " + tableName;
                    selectString = String.valueOf(selectString) + " GROUP BY " + this.wrapName(columnName);
                    selectString = String.valueOf(selectString) + " ORDER BY " + this.wrapName(columnName);
                } else {
                    selectString = String.valueOf(selectString) + "SELECT " + this.wrapName(columnName);
                    selectString = String.valueOf(selectString) + " FROM " + tableName;
                }
            }
            String profileName = DatabaseConnectionRegistry.getConnectionForDatabase(database).getName();
            IExternalRunQuery externalRun = (IExternalRunQuery)this.getExternalRunQuery(database);
            if (externalRun != null) {
                externalRun.init(selectString, connection, profileName, database, ResourceLoader.INSTANCE.queryString("_UI_SAMPLE_CONTENTS_OUTPUTVIEW_TITLE"));
                externalRun.runQuery();
            } else {
                QueryOutputHelper queryHelper = new QueryOutputHelper(selectString, connection, profileName, database.getName());
                queryHelper.setObjectName(ResourceLoader.INSTANCE.queryString("_UI_SAMPLE_CONTENTS_OUTPUTVIEW_TITLE"));
                queryHelper.runQuery();
            }
        }
    }

    private Object getExternalRunQuery(Database database) {
        Object externalExecutable = null;
        if (database != null) {
            String thisVendor = database.getVendor();
            try {
                IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                IExtensionPoint runQueryExtensionPoint = extensionRegistry.getExtensionPoint(EXTERNAL_RUN_QUERY);
                IExtension[] runQueryExtensions = runQueryExtensionPoint.getExtensions();
                int numExt = 0;
                while (numExt < runQueryExtensions.length) {
                    IExtension ext = runQueryExtensions[numExt];
                    IConfigurationElement[] configElements = ext.getConfigurationElements();
                    int config = 0;
                    while (config < configElements.length) {
                        String extensionVendor = configElements[config].getAttribute(EXTERNAL_RUN_QUERY_VENDOR);
                        if (thisVendor.equalsIgnoreCase(extensionVendor)) {
                            externalExecutable = configElements[config].createExecutableExtension("class");
                            break;
                        }
                        ++config;
                    }
                    ++numExt;
                }
            }
            catch (CoreException coreException) {}
        }
        return externalExecutable;
    }

    public static String doubleStringDelim(String s, String delim) {
        if (delim == null || delim.length() == 0) {
            return s;
        }
        int i = s.indexOf(delim);
        if (i != -1) {
            StringBuffer sb = new StringBuffer(s);
            while (i != -1) {
                sb = sb.insert(i, delim);
                int j = i + 2 * delim.length();
                i = sb.toString().indexOf(delim, j);
            }
            return sb.toString();
        }
        return s;
    }
}

