/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr;

import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseOptionsPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSearchPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSimplePage;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CaseExpressionWizard
extends Wizard
implements INewWizard {
    private CaseOptionsPage caseOptionsPage;
    private CaseSearchPage caseSearchPage;
    private CaseSimplePage caseSimplePage;
    private SQLDomainModel domainModel;
    private SQLQueryObject sqlStatement;
    private QueryValueExpression inputSQLExpression;
    private QueryValueExpression updatedSQLExpression;

    public CaseExpressionWizard(SQLDomainModel domainModel, SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr) {
        this.domainModel = domainModel;
        this.sqlStatement = sqlStatementArg;
        this.updatedSQLExpression = this.inputSQLExpression = sqlExpr;
        this.setWindowTitle(Messages._UI_WIZARD_CASE_EXPRESSION_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)SQLBuilderPlugin.getPlugin())).getClass(), (String)"icons/expressionbuilder_wiz.gif"));
    }

    public Wizard createSmartGuide() {
        return this;
    }

    public void addPages() {
        if (this.inputSQLExpression == null) {
            this.caseOptionsPage = new CaseOptionsPage(this.sqlStatement, null);
            this.caseSearchPage = new CaseSearchPage(this.domainModel, this.sqlStatement, null);
            this.caseSimplePage = new CaseSimplePage(this.domainModel, this.sqlStatement, null);
            this.addPage((IWizardPage)this.caseOptionsPage);
            this.addPage((IWizardPage)this.caseSearchPage);
            this.addPage((IWizardPage)this.caseSimplePage);
        } else if (this.inputSQLExpression != null) {
            if (this.inputSQLExpression instanceof ValueExpressionCaseSearch) {
                this.caseSearchPage = new CaseSearchPage(this.domainModel, this.sqlStatement, this.inputSQLExpression);
                this.addPage((IWizardPage)this.caseSearchPage);
            } else if (this.inputSQLExpression instanceof ValueExpressionCaseSimple) {
                this.caseSimplePage = new CaseSimplePage(this.domainModel, this.sqlStatement, this.inputSQLExpression);
                this.addPage((IWizardPage)this.caseSimplePage);
            } else {
                this.caseOptionsPage = new CaseOptionsPage(this.sqlStatement, null);
                this.caseSearchPage = new CaseSearchPage(this.domainModel, this.sqlStatement, null);
                this.caseSimplePage = new CaseSimplePage(this.domainModel, this.sqlStatement, null);
                this.addPage((IWizardPage)this.caseOptionsPage);
                this.addPage((IWizardPage)this.caseSearchPage);
                this.addPage((IWizardPage)this.caseSimplePage);
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setSQLExpression(QueryValueExpression sqlExpr) {
        this.updatedSQLExpression = sqlExpr;
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        WizardPage nextPage = null;
        if (currentPage instanceof CaseOptionsPage) {
            Object type = ((CaseOptionsPage)currentPage).getCaseType();
            if (type.equals(CaseOptionsPage.CASE_SEARCH_WHEN_CLAUSE)) {
                nextPage = this.caseSearchPage;
            } else if (type.equals(CaseOptionsPage.CASE_SIMPLE_WHEN_CLAUSE)) {
                nextPage = this.caseSimplePage;
            } else {
                return null;
            }
            return nextPage;
        }
        return null;
    }

    public void setCaseOptionsPageComplete(boolean bComplete) {
        if (this.caseOptionsPage != null) {
            this.caseOptionsPage.setPageComplete(bComplete);
        }
        if (this.caseSearchPage != null) {
            this.caseSearchPage.setPageComplete(bComplete);
        }
        if (this.caseSimplePage != null) {
            this.caseSimplePage.setPageComplete(bComplete);
        }
    }

    public boolean performFinish() {
        if (this.caseSearchPage != null && this.caseSearchPage.currentPage()) {
            this.caseSearchPage.performOk();
        } else if (this.caseSimplePage != null && this.caseSimplePage.currentPage()) {
            this.caseSimplePage.performOk();
        }
        return true;
    }
}

