/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParserConstants;
import org.eclipse.datatools.sqltools.sql.parser.Token;

public abstract class SQLParser
implements SQLParserConstants {
    private static String SEPARATOR = "(\r\n|\r|\n|\u0085|\u2028|\u2029)";
    private static Pattern p = Pattern.compile("(.*" + SEPARATOR + ")");
    public static final String SPECIAL_TOKEN = "!%^&";
    protected ParserParameters _parameters = new ParserParameters(false, 100);
    protected int fScope;
    protected String _input = "";

    public synchronized ParsingResult parse(String text) {
        ParserParameters param = new ParserParameters(false, 100);
        return this.parse(text, param);
    }

    public synchronized ParsingResult parse(String text, ParserParameters parameters) {
        ParserParameters oldParameters = this._parameters;
        this.setParameters(parameters);
        this._input = text;
        ParsingResult result = this.doParse(text);
        result.setScope(this.getScope());
        this.setParameters(oldParameters);
        return result;
    }

    public abstract String[] getStatementTerminators();

    public abstract String[] getStatementStartTokens();

    protected int getScope() {
        return this.fScope;
    }

    protected ParserParameters getParameters() {
        return this._parameters;
    }

    protected void setParameters(ParserParameters parameters) {
        this._parameters = parameters;
    }

    protected abstract ParsingResult doParse(String var1);

    protected final int setScope(int scope) {
        return this.setScope("", scope);
    }

    protected final int setScope(String name, int scope) {
        int oldScope = this.fScope;
        this.fScope = scope;
        return oldScope;
    }

    public boolean isComplete() {
        return true;
    }

    public int getStartIndex(Token t) {
        Matcher m = p.matcher(this._input);
        int i = 1;
        int count = 0;
        while (m.find() && i < t.beginLine) {
            ++i;
            count = m.end(1);
        }
        return count + t.beginColumn - 1;
    }

    public int getEndIndex(Token t) {
        Matcher m = p.matcher(this._input);
        int i = 1;
        int count = 0;
        while (m.find() && i < t.endLine) {
            ++i;
            count = m.end(1);
        }
        return count + t.endColumn;
    }

    public int[] getRange(Token t) {
        Matcher m = p.matcher(this._input);
        int i = 1;
        int count = 0;
        while (m.find() && i < t.endLine) {
            ++i;
            count = m.end(1);
        }
        int[] range = new int[]{count + t.beginColumn - 1, count + t.endColumn};
        return range;
    }
}

