/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLSource;

public class XMLSourceFromPath
implements IXMLSource {
    private String path;
    private String encoding;

    public XMLSourceFromPath(String path) throws OdaException {
        if (path == null || path.equals("")) {
            throw new OdaException(Messages.getString("Connection.PropertiesMissing"));
        }
        this.path = path;
    }

    public XMLSourceFromPath(String path, String encoding) throws OdaException {
        this(path);
        this.encoding = encoding;
    }

    public InputStream openInputStream() throws OdaException {
        try {
            File f = new File(this.path);
            if (f.exists()) {
                return new BufferedInputStream(new FileInputStream(f));
            }
        }
        catch (FileNotFoundException e) {
            throw new OdaException((Throwable)e);
        }
        try {
            URL url = new URL(this.path);
            return new BufferedInputStream(url.openStream());
        }
        catch (MalformedURLException malformedURLException) {
            throw new OdaException(Messages.getString("Connection.InvalidSource"));
        }
        catch (IOException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public void release() throws OdaException {
    }

    public String getEncoding() {
        return this.encoding;
    }
}

