/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class RoutineInfoASALoader {
    private Routine routine;
    private Connection conn;
    private ICatalogObject catalogObj;

    public RoutineInfoASALoader(Routine catalogRoutine) {
        this.routine = catalogRoutine;
        this.catalogObj = (ICatalogObject)catalogRoutine;
        this.conn = this.catalogObj.getConnection();
    }

    public final void loadRoutineInfo() {
        boolean deliver;
        block6: {
            deliver = this.routine.eDeliver();
            this.routine.eSetDeliver(false);
            SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    Schema schema = this.routine.getSchema();
                    stmt = this.conn.prepareStatement(SQLScriptsProvider.getQueryRoutineInfo((Database)db));
                    stmt.setString(1, schema.getName());
                    stmt.setString(2, this.routine.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.processResultSet(rs);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.routine.eSetDeliver(deliver);
    }

    protected void processResultSet(ResultSet rs) throws SQLException {
        String remark = rs.getString(2);
        String source = rs.getString(3);
        String def = rs.getString(4);
        this.routine.setDescription(remark);
        Source src = SQLRoutinesFactory.eINSTANCE.createSource();
        src.setBody(source != null ? source : def);
        this.routine.setSource(src);
    }
}

