/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.core.ext;

import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.compare.ITypedElement;
import org.eclipse.emf.diffmerge.connector.core.Messages;
import org.eclipse.emf.diffmerge.connector.core.ext.AbstractRevisionScopeDefinitionFactory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.history.LocalFileRevision;

public class LocalHistoryScopeDefinitionFactory
extends AbstractRevisionScopeDefinitionFactory {
    @Override
    protected String getLabelForRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        String result;
        IResourceVariant variant = this.getVariant(revision_p);
        if (variant != null) {
            result = variant.getContentIdentifier();
        } else if (revision_p.getTimestamp() != -1L) {
            Calendar fileRevDate = Calendar.getInstance();
            fileRevDate.setTimeInMillis(revision_p.getTimestamp());
            result = String.format(Messages.LocalHistoryModelScopeDefinitionFactory_RevisionLabel, revision_p.getName(), DateFormat.getInstance().format(fileRevDate.getTime()));
        } else {
            result = super.getLabelForRevision(revision_p, entrypoint_p);
        }
        return result;
    }

    @Override
    protected boolean isApplicableToRevision(IFileRevision revision_p, ITypedElement entrypoint_p) {
        return revision_p instanceof LocalFileRevision;
    }
}

