/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.java.dynamic.compilation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class JavaClassObject
extends SimpleJavaFileObject {
    private static final char SLASH = '/';
    private static final char DOT = '.';
    private static final String STRING_URI = "string:///";
    private final String name;
    private final String content;
    private final long lastModified;
    private final ByteArrayOutputStream bos;

    public JavaClassObject(String name, JavaFileObject.Kind kind, String content, long lastModified) {
        super(URI.create(STRING_URI + name.replace('.', '/') + kind.extension), kind);
        this.name = name;
        this.content = content.trim();
        this.lastModified = lastModified;
        this.bos = new ByteArrayOutputStream();
    }

    public byte[] getBytes() {
        return this.bos.toByteArray();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.content != null ? this.content : super.getCharContent(ignoreEncodingErrors);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.bos.reset();
        return this.bos;
    }
}

