/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.metrics;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.dirigible.runtime.metrics.TimeUtils;
import org.eclipse.dirigible.runtime.registry.PathUtils;

public class AccessLogRecord {
    private String requestUri;
    private String remoteUser;
    private String remoteHost;
    private String method;
    private String userAgent;
    private Date timestamp;
    private Date period;
    private int responseStatus;
    private int responseTime;
    private String sessionId;
    private String pattern;
    private String projectName;

    public AccessLogRecord(HttpServletRequest request, String pattern) {
        this.requestUri = request.getRequestURI();
        this.remoteUser = request.getRemoteUser();
        this.remoteHost = request.getRemoteHost();
        HttpSession session = request.getSession(true);
        this.sessionId = session.getId();
        this.method = request.getMethod();
        this.userAgent = request.getHeader("User-Agent");
        if (this.userAgent != null && this.userAgent.length() > 32) {
            this.userAgent = this.userAgent.substring(0, 31);
        }
        this.timestamp = new Date();
        this.period = TimeUtils.roundCeilingHour(this.timestamp);
        this.pattern = pattern;
        String pathInfo = PathUtils.extractPath((HttpServletRequest)request);
        this.projectName = this.extractProjectName(pathInfo);
    }

    private String extractProjectName(String pathInfo) {
        if (pathInfo != null && pathInfo.length() > 2 && pathInfo.charAt(0) == '/' && pathInfo.substring(1).indexOf("/") > 0) {
            String project = pathInfo.substring(1);
            String string = project.substring(0, project.indexOf("/"));
        }
        return "none";
    }

    public AccessLogRecord(String requestUri, String remoteUser, String remoteHost, String sessionId, String method, String userAgent, int responseStatus, Date timestamp, Date period, String pattern, String projectName, int responseTime) {
        this.requestUri = requestUri;
        this.remoteUser = remoteUser;
        this.remoteHost = remoteHost;
        this.method = method;
        this.userAgent = userAgent;
        this.timestamp = timestamp;
        this.responseStatus = responseStatus;
        this.responseTime = responseTime;
        this.sessionId = sessionId;
        this.pattern = pattern;
        this.projectName = projectName;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
    }

    public int getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(int responseTime) {
        this.responseTime = responseTime;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getPeriod() {
        return this.period;
    }

    public void setPeriod(Date period) {
        this.period = period;
    }
}

