/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.editor.text.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.editor.text.editor.ContentProviderException;
import org.eclipse.dirigible.ide.editor.text.editor.ContentProviderFactory;
import org.eclipse.dirigible.ide.editor.text.editor.IContentProvider;
import org.eclipse.dirigible.ide.editor.text.editor.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractTextEditor
extends EditorPart {
    private static final String COLON = ": ";
    private static final String SAVE_ERROR = Messages.AbstractTextEditor_SAVE_ERROR;
    private static final String CANNOT_SAVE_DOCUMENT = Messages.AbstractTextEditor_CANNOT_SAVE_DOCUMENT;
    private static final Logger logger = Logger.getLogger(AbstractTextEditor.class);
    private boolean isDirty;

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        String contents = this.getEditorContents();
        IContentProvider contentProvider = this.getContentProvider(input);
        if (contentProvider != null && contents != null) {
            try {
                contentProvider.save(monitor, input, contents, true);
                this.setDirty(false);
            }
            catch (ContentProviderException e) {
                logger.error(CANNOT_SAVE_DOCUMENT, (Throwable)e);
                MessageDialog.openError(null, (String)SAVE_ERROR, (String)(String.valueOf(CANNOT_SAVE_DOCUMENT) + COLON + e.getMessage()));
            }
        }
    }

    protected void setDirty(boolean b) {
        this.isDirty = b;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setFocus() {
        Control control = this.getEditorControl();
        if (control != null) {
            control.setFocus();
        }
    }

    protected abstract String getEditorContents();

    protected abstract Control getEditorControl();

    protected IContentProvider getContentProvider(IEditorInput input) {
        return ContentProviderFactory.getInstance().getContentProvider(input);
    }
}

