/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.text.pattern.Parse;
import org.hamcrest.text.pattern.PatternComponent;
import org.hamcrest.text.pattern.PatternMatchException;
import org.hamcrest.text.pattern.internal.naming.GroupNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatcher
extends TypeSafeMatcher<String>
implements PatternComponent {
    private GroupNamespace groups = new GroupNamespace();
    private PatternComponent root;
    private Pattern pattern;

    public PatternMatcher(PatternComponent root) {
        this.root = root;
        this.pattern = PatternMatcher.compile(root, this.groups);
    }

    @Factory
    public static PatternMatcher matchesPattern(PatternComponent pattern) {
        return new PatternMatcher(pattern);
    }

    @Factory
    public static PatternMatcher matchesPattern(PatternMatcher pattern) {
        return pattern;
    }

    public String toString() {
        return this.pattern.toString();
    }

    public void describeTo(Description description) {
        description.appendText("a string matching ");
        description.appendValue((Object)this.toString());
    }

    public boolean matchesSafely(String s) {
        return this.pattern.matcher(s).matches();
    }

    public Parse parse(String input) throws PatternMatchException {
        Matcher matcher = this.pattern.matcher(input);
        if (matcher.matches()) {
            return new Parse(this.groups, matcher);
        }
        throw new PatternMatchException("did not match input: " + input);
    }

    @Override
    public void buildRegex(StringBuilder builder, GroupNamespace groups) {
        this.root.buildRegex(builder, groups);
    }

    private static Pattern compile(PatternComponent root, GroupNamespace groups) {
        StringBuilder builder = new StringBuilder();
        root.buildRegex(builder, groups);
        return Pattern.compile(builder.toString());
    }
}

