/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.designer.ui;

import org.eclipse.dirigible.ide.designer.ui.DesignerEditorWidget;
import org.eclipse.dirigible.ide.designer.ui.IDesignerEditorWidgetListener;
import org.eclipse.dirigible.ide.designer.ui.Messages;
import org.eclipse.dirigible.ide.editor.text.editor.ContentProviderException;
import org.eclipse.dirigible.ide.editor.text.editor.TextEditor;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;

public class DesignerEditor
extends TextEditor {
    private static final String EMPTY_HTML = "<!DOCTYPE html><html><head></head><body></body></html>";
    private static final String ERROR = Messages.DesignerEditor_Error;
    private static final String CANNOT_LOAD_DOCUMENT = Messages.DesignerEditor_Cannot_load_document;
    private static final Logger logger = Logger.getLogger(DesignerEditor.class);
    private DesignerEditorWidget text = null;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        final DesignerEditor designerEditor = this;
        IEditorInput input = this.getEditorInput();
        this.text = new DesignerEditorWidget(parent);
        this.text.setLayoutData(new GridData(4, 4, true, true));
        try {
            String content = this.getContentProvider(input).getContent(input);
            if (content == null || "".equals(content)) {
                content = EMPTY_HTML;
            }
            this.text.setText(content);
        }
        catch (ContentProviderException e) {
            logger.error(CANNOT_LOAD_DOCUMENT, (Throwable)e);
            MessageDialog.openError(null, (String)ERROR, (String)CANNOT_LOAD_DOCUMENT);
        }
        this.text.setListener(new IDesignerEditorWidgetListener(){

            @Override
            public void dirtyStateChanged(boolean dirty) {
                designerEditor.setDirty(dirty);
            }

            @Override
            public void save() {
                DesignerEditor.this.doSave(null);
            }
        });
    }

    protected String getEditorContents() {
        return this.text != null ? this.text.getText() : null;
    }

    protected Control getEditorControl() {
        return this.text;
    }

    protected void setDirty(boolean b) {
        super.setDirty(b);
        if (this.text != null) {
            this.text.setDirty(b);
        }
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }
}

