/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.editor.text.editor;

import java.util.Arrays;

public enum EditorMode {
    JS("javascript", "js"),
    SQL("sql", "sql"),
    JSON("json", "json", "odata", "ws", "table", "view", "entity", "menu", "access", "extensionpoint", "extension", "command", "flow", "job"),
    XML("xml", "xml", "xsd", "wsdl", "xsl", "xslt", "routes"),
    HTML("html", "html"),
    CSS("css", "css"),
    MARKDOWN("markdown", "markdown", "mdown", "mkdn", "md", "mkd", "mdwn"),
    TEXTILE("textile", "textile"),
    TXT("text", "txt"),
    RUBY("ruby", "rb"),
    JAVA("java", "java"),
    GROOVY("groovy", "groovy", "gvy", "gy", "gsh"),
    PROPERTIES("properties", "properties");

    private static final EditorMode DEFAULT_MODE;
    private String name;
    private String[] extensions;

    static {
        DEFAULT_MODE = TXT;
    }

    private EditorMode(String name, String ... extensions) {
        this.name = name;
        this.extensions = extensions;
        Arrays.sort(this.extensions);
    }

    public String getName() {
        return this.name;
    }

    public static EditorMode getByExtension(String extension) {
        EditorMode[] editorModeArray = EditorMode.values();
        int n = editorModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorMode mode = editorModeArray[n2];
            if (Arrays.binarySearch(mode.extensions, extension) >= 0) {
                return mode;
            }
            ++n2;
        }
        return DEFAULT_MODE;
    }
}

