/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.create;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.workspace.dual.ProjectCreatorEnhancer;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.shared.ValidationStatus;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.Messages;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.ProjectTemplateType;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.logging.Logger;

public class NewProjectWizardModel {
    private static final String ERROR_OCCURED_WHEN_TRYING_TO_VALIDATE_NEW_PROJECT_NAME = Messages.NewProjectWizardModel_ERROR_OCCURED_WHEN_TRYING_TO_VALIDATE_NEW_PROJECT_NAME;
    private static final String PROJECT_WITH_NAME_S_WAS_ALREADY_CREATED_FROM_USER_S = Messages.NewProjectWizardModel_PROJECT_WITH_NAME_S_WAS_ALREADY_CREATED_FROM_USER_S;
    private static final String PROJECT_WITH_THIS_NAME_ALREADY_EXISTS = Messages.NewProjectWizardModel_PROJECT_WITH_THIS_NAME_ALREADY_EXISTS;
    private static final String INVALID_PROJECT_NAME = Messages.NewProjectWizardModel_INVALID_PROJECT_NAME;
    public static final Logger logger = Logger.getLogger((String)NewProjectWizardModel.class.getCanonicalName());
    private static final String INITIAL_LOCATION = "project";
    private String projectName = "project";
    private String conflictUser;
    private ProjectTemplateType template;
    private boolean useTemplate = true;

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String location) {
        this.projectName = location;
    }

    public IValidationStatus validate() {
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IStatus pathValidation = workspace.validateName(this.projectName, 4);
        if (!pathValidation.isOK()) {
            return ValidationStatus.createError((String)INVALID_PROJECT_NAME);
        }
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(this.projectName);
        if (project.exists()) {
            return ValidationStatus.createError((String)PROJECT_WITH_THIS_NAME_ALREADY_EXISTS);
        }
        if (!this.isValidRepositoryProject()) {
            return ValidationStatus.createError((String)String.format(PROJECT_WITH_NAME_S_WAS_ALREADY_CREATED_FROM_USER_S, this.projectName, this.conflictUser));
        }
        return ValidationStatus.createOk();
    }

    private boolean isValidRepositoryProject() {
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ICollection userFolders = repository.getCollection("/db/dirigible/users/");
        boolean isValid = true;
        try {
            for (ICollection user : userFolders.getCollections()) {
                if (!user.exists()) continue;
                ICollection workspace = user.getCollection("workspace");
                for (ICollection nextProject : workspace.getCollections()) {
                    if (!nextProject.exists() || !nextProject.getName().equals(this.projectName)) continue;
                    this.conflictUser = user.getName();
                    isValid = false;
                    break;
                }
                if (isValid) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            String message = ERROR_OCCURED_WHEN_TRYING_TO_VALIDATE_NEW_PROJECT_NAME;
            logger.error(message, (Throwable)e);
        }
        return isValid;
    }

    /*
     * Unable to fully structure code
     */
    public IProject execute() throws CoreException {
        workspace = WorkspaceLocator.getWorkspace();
        root = workspace.getRoot();
        project = root.getProject(this.projectName);
        try {
            project.create(null);
        }
        catch (CoreException e) {
            NewProjectWizardModel.logger.error(e.getMessage(), (Throwable)e);
        }
        project.open(null);
        if (this.isUseTemplate()) {
            contentPath = this.template.getContentPath();
            try {
                repository = RepositoryFacade.getInstance().getRepository();
                contentResource = repository.getResource(contentPath);
                if (!contentResource.exists()) ** GOTO lbl36
                data = contentResource.getContent();
                location = project.getRawLocation();
                if (location == null) {
                    location = project.getLocation();
                }
                filter = new HashMap<String, String>();
                filter.put("PROJECT_NAME", this.projectName);
                repository.importZip(data, location.toString(), false, false, filter);
            }
            catch (RepositoryException e) {
                NewProjectWizardModel.logger.error(e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dirigible.ide.workspace.ui", e.getMessage()));
            }
            catch (IOException e) {
                NewProjectWizardModel.logger.error(e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dirigible.ide.workspace.ui", e.getMessage()));
            }
        } else {
            publishers = PublishManager.getPublishers();
            for (IPublisher publisher : publishers) {
                folder = project.getFolder(publisher.getFolderType());
                folder.create(true, false, null);
            }
        }
lbl36:
        // 3 sources

        ProjectCreatorEnhancer.enhance((IProject)project);
        project.refreshLocal(2, null);
        return project;
    }

    public ProjectTemplateType getTemplate() {
        return this.template;
    }

    public void setTemplate(ProjectTemplateType template) {
        this.template = template;
    }

    public String getTemplateLocation() {
        if (this.template == null) {
            return null;
        }
        return this.template.getLocation();
    }

    public void setUseTemplate(boolean b) {
        this.useTemplate = b;
    }

    public boolean isUseTemplate() {
        return this.useTemplate;
    }
}

