/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.create;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.dirigible.ide.template.ui.common.TemplateUtils;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.Messages;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.swt.graphics.Image;

public class ProjectTemplateType {
    private static final String PARAM_CATEGORY = "category";
    private static final String EXT_PROPERTIES = ".properties";
    private static final String SEPARATOR = "/";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_CONTENT = "content";
    private static final String PARAM_IMAGE = "image";
    private static final String PARAM_IMAGE_PREVIEW = "preview";
    private static final String PARAM_NAME = "name";
    private static final String PROJECT_TEMPLATE_CONTENT_DOES_NOT_EXIST_AT_S = Messages.ProjectTemplateType_PROJECT_TEMPLATE_CONTENT_DOES_NOT_EXIST_AT_S;
    private static final String PROJECT_TEMPLATE_METADATA_DOES_NOT_EXIST_AT_S = Messages.ProjectTemplateType_PROJECT_TEMPLATE_METADATA_DOES_NOT_EXIST_AT_S;
    private static final String PROJECT_TEMPLATE_LOCATION_S_IS_NOT_VALID = Messages.ProjectTemplateType_PROJECT_TEMPLATE_LOCATION_S_IS_NOT_VALID;
    private String location;
    private String name;
    private String description;
    private Image image;
    private Image imagePreview;
    private String contentPath;
    private String category;

    public static ProjectTemplateType createTemplateType(IRepository repository, String location) throws IOException {
        ICollection projectTemplateRoot = repository.getCollection(location);
        if (!projectTemplateRoot.exists()) {
            throw new IOException(String.format(PROJECT_TEMPLATE_LOCATION_S_IS_NOT_VALID, location));
        }
        IResource projectMetadataResource = projectTemplateRoot.getResource("project.properties");
        if (!projectMetadataResource.exists()) {
            throw new IOException(String.format(PROJECT_TEMPLATE_METADATA_DOES_NOT_EXIST_AT_S, location));
        }
        Properties projectMetadata = new Properties();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ProjectTemplateType templateType;
            byteArrayInputStream = new ByteArrayInputStream(projectMetadataResource.getContent());
            projectMetadata.load(byteArrayInputStream);
            String name = (String)projectMetadata.get(PARAM_NAME);
            String description = (String)projectMetadata.get(PARAM_DESCRIPTION);
            String imageName = (String)projectMetadata.get(PARAM_IMAGE);
            String imagePreviewName = (String)projectMetadata.get(PARAM_IMAGE_PREVIEW);
            String contentName = (String)projectMetadata.get(PARAM_CONTENT);
            Image image = TemplateUtils.createImageFromResource((ICollection)projectTemplateRoot, (String)imageName);
            Image imagePreview = TemplateUtils.createImageFromResource((ICollection)projectTemplateRoot, (String)imagePreviewName);
            IResource contentResource = projectTemplateRoot.getResource(contentName);
            if (!contentResource.exists()) {
                throw new IOException(String.format(PROJECT_TEMPLATE_CONTENT_DOES_NOT_EXIST_AT_S, contentName));
            }
            ProjectTemplateType projectTemplateType = templateType = new ProjectTemplateType(name, description, location, image, imagePreview, contentResource.getPath(), "template");
            return projectTemplateType;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
    }

    public static ProjectTemplateType createGitTemplateType(File project) throws FileNotFoundException, IOException {
        Image image = null;
        Image imagePreview = null;
        String name = null;
        String imageName = null;
        String imagePreviewName = null;
        String description = null;
        String contentPath = null;
        String contentName = null;
        String category = null;
        Properties projectMetadata = new Properties();
        File[] fileArray = project.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File nextFile = fileArray[n2];
            String fileName = nextFile.getName();
            if (ProjectTemplateType.isPropertiesFile(fileName)) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(nextFile);
                    projectMetadata.load(fileInputStream);
                    name = projectMetadata.getProperty(PARAM_NAME);
                    imageName = projectMetadata.getProperty(PARAM_IMAGE);
                    imagePreviewName = projectMetadata.getProperty(PARAM_IMAGE_PREVIEW);
                    contentName = projectMetadata.getProperty(PARAM_CONTENT);
                    description = projectMetadata.getProperty(PARAM_DESCRIPTION);
                    contentPath = String.valueOf(project.getCanonicalPath()) + SEPARATOR + contentName;
                    category = projectMetadata.getProperty(PARAM_CATEGORY);
                    image = TemplateUtils.createImageFromStream((File)project, (String)imageName);
                    imagePreview = TemplateUtils.createImageFromStream((File)project, (String)imagePreviewName);
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            ++n2;
        }
        ProjectTemplateType templateType = new ProjectTemplateType(name, description, project.getCanonicalPath(), image, imagePreview, contentPath, category);
        return templateType;
    }

    private ProjectTemplateType(String name, String description, String location, Image image, Image imagePreview, String contentPath, String category) {
        this.name = name;
        this.description = description;
        this.location = location;
        this.image = image;
        this.imagePreview = imagePreview;
        this.contentPath = contentPath;
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImagePreview() {
        return this.imagePreview;
    }

    public void setImagePreview(Image imagePreview) {
        this.imagePreview = imagePreview;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public void setContentPath(String contentPath) {
        this.contentPath = contentPath;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public static boolean isPropertiesFile(String fileName) {
        String suffix = EXT_PROPERTIES;
        return fileName.endsWith(suffix);
    }
}

