/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.getstarted;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.workspace.dual.ProjectCreatorEnhancer;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.shared.ValidationStatus;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.Messages;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public class GetStartedProjectWizardModel {
    private static final String ERROR_OCCURED_WHEN_TRYING_TO_VALIDATE_NEW_PROJECT_NAME = Messages.NewProjectWizardModel_ERROR_OCCURED_WHEN_TRYING_TO_VALIDATE_NEW_PROJECT_NAME;
    private static final String PROJECT_WITH_NAME_S_WAS_ALREADY_CREATED_FROM_USER_S = Messages.NewProjectWizardModel_PROJECT_WITH_NAME_S_WAS_ALREADY_CREATED_FROM_USER_S;
    private static final String PROJECT_WITH_THIS_NAME_ALREADY_EXISTS = Messages.NewProjectWizardModel_PROJECT_WITH_THIS_NAME_ALREADY_EXISTS;
    private static final String INVALID_PROJECT_NAME = Messages.NewProjectWizardModel_INVALID_PROJECT_NAME;
    public static final Logger logger = Logger.getLogger((String)GetStartedProjectWizardModel.class.getCanonicalName());
    private static final String INITIAL_LOCATION = "MyFirstProject";
    private String projectName = "MyFirstProject";
    private String conflictUser;

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String location) {
        this.projectName = location;
    }

    public IValidationStatus validate() {
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IStatus pathValidation = workspace.validateName(this.projectName, 4);
        if (!pathValidation.isOK()) {
            return ValidationStatus.createError((String)INVALID_PROJECT_NAME);
        }
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(this.projectName);
        if (project.exists()) {
            return ValidationStatus.createError((String)PROJECT_WITH_THIS_NAME_ALREADY_EXISTS);
        }
        if (!this.isValidRepositoryProject()) {
            return ValidationStatus.createError((String)String.format(PROJECT_WITH_NAME_S_WAS_ALREADY_CREATED_FROM_USER_S, this.projectName, this.conflictUser));
        }
        return ValidationStatus.createOk();
    }

    private boolean isValidRepositoryProject() {
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ICollection userFolders = repository.getCollection("/db/dirigible/users/");
        boolean isValid = true;
        try {
            for (ICollection user : userFolders.getCollections()) {
                if (!user.exists()) continue;
                ICollection workspace = user.getCollection("workspace");
                for (ICollection nextProject : workspace.getCollections()) {
                    if (!nextProject.exists() || !nextProject.getName().equals(this.projectName)) continue;
                    this.conflictUser = user.getName();
                    isValid = false;
                    break;
                }
                if (isValid) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            String message = ERROR_OCCURED_WHEN_TRYING_TO_VALIDATE_NEW_PROJECT_NAME;
            logger.error(message, (Throwable)e);
        }
        return isValid;
    }

    public IProject execute() throws CoreException {
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(this.projectName);
        try {
            project.create(null);
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        project.open(null);
        List publishers = PublishManager.getPublishers();
        for (IPublisher publisher : publishers) {
            IFolder folder = project.getFolder(publisher.getFolderType());
            folder.create(true, false, null);
        }
        ProjectCreatorEnhancer.enhance((IProject)project);
        this.createGetStartedArtifacts(project);
        this.activateAndPublish(project);
        project.refreshLocal(2, null);
        return project;
    }

    private void createGetStartedArtifacts(IProject project) {
        this.generateAndStoreArtifact(project, "user_books.table", "DataStructures");
        this.generateAndStoreArtifact(project, "user_books_lib.js", "ScriptingServices");
        this.generateAndStoreArtifact(project, "user_books.js", "ScriptingServices");
        this.generateAndStoreArtifact(project, "user_books.entity", "ScriptingServices");
        this.generateAndStoreArtifact(project, "user_books.html", "WebContent");
        this.generateAndStoreArtifact(project, "header.html", "WebContent");
        this.generateAndStoreArtifact(project, "footer.html", "WebContent");
        this.generateAndStoreArtifact(project, "main.menu", "WebContent");
        this.generateAndStoreArtifact(project, "index.html", "WebContent");
    }

    private void generateAndStoreArtifact(IProject project, String resource, String folder) {
        InputStream in = GetStartedProjectWizardModel.class.getResourceAsStream(resource);
        String user = CommonParameters.getUserName();
        user = user.toLowerCase();
        try {
            String content = IOUtils.toString((InputStream)in, (String)"UTF-8");
            content = content.replace("${User}", CommonUtils.toCamelCase((String)user));
            content = content.replace("${user}", user);
            content = content.replace("${USER}", user.toUpperCase());
            IFolder pckg = project.getFolder(String.valueOf(folder) + "/" + user + "_books");
            if (!pckg.exists()) {
                pckg.create(true, false, null);
            }
            IFile file = project.getFile(String.valueOf(folder) + "/" + user + "_books/" + resource.replace("user", user));
            file.create(IOUtils.toInputStream((String)content), true, null);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void activateAndPublish(IProject project) {
        try {
            PublishManager.publishProject((IProject)project);
        }
        catch (PublishException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

