/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.common;

import java.util.List;

public class CommonUtils {
    public static String formatToIDEPath(String folder, String runtimePath) {
        StringBuilder path = new StringBuilder(runtimePath);
        int metaFolderIndex = runtimePath.indexOf("/", runtimePath.indexOf("/") + 1);
        if (metaFolderIndex != -1) {
            path.insert(metaFolderIndex, "/" + folder);
        }
        return path.toString();
    }

    public static String formatToRuntimePath(String folder, String idePath) {
        StringBuilder path = new StringBuilder(idePath);
        int indexOfWorkspace = path.indexOf("workspace");
        int indexOfSlash = path.indexOf("/", indexOfWorkspace);
        path.replace(0, indexOfSlash, "");
        int indexOfFolder = path.indexOf(folder);
        path.replace(0, indexOfFolder + folder.length(), "");
        return path.toString();
    }

    public static String replaceNonAlphaNumericCharacters(String text) {
        return text.replaceAll("[^\\w]", "");
    }

    public static String getFileNameNoExtension(String fileName) {
        String result = fileName;
        if (fileName != null && fileName.indexOf(46) > 0) {
            result = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return result;
    }

    public static String concatenateListOfStrings(List<String> list, String separator) {
        StringBuffer buff = new StringBuffer();
        for (String s : list) {
            buff.append(s).append(separator);
        }
        return buff.toString();
    }

    public static String toCamelCase(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append(input.substring(0, 1).toUpperCase());
        result.append(input.substring(1).toLowerCase());
        return result.toString();
    }
}

